/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.internal.contexts.ContextRegistryEvent;
import org.eclipse.ui.internal.contexts.IContextRegistry;
import org.eclipse.ui.internal.contexts.IContextRegistryListener;

abstract class AbstractContextRegistry
implements IContextRegistry {
    protected List contextContextBindingDefinitions = Collections.EMPTY_LIST;
    protected List contextDefinitions = Collections.EMPTY_LIST;
    private ContextRegistryEvent contextRegistryEvent;
    private List contextRegistryListeners;

    protected AbstractContextRegistry() {
    }

    public void addContextRegistryListener(IContextRegistryListener contextRegistryListener) {
        if (contextRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.contextRegistryListeners == null) {
            this.contextRegistryListeners = new ArrayList();
        }
        if (!this.contextRegistryListeners.contains(contextRegistryListener)) {
            this.contextRegistryListeners.add(contextRegistryListener);
        }
    }

    protected void fireContextRegistryChanged() {
        if (this.contextRegistryListeners != null) {
            int i = 0;
            while (i < this.contextRegistryListeners.size()) {
                if (this.contextRegistryEvent == null) {
                    this.contextRegistryEvent = new ContextRegistryEvent(this);
                }
                ((IContextRegistryListener)this.contextRegistryListeners.get(i)).contextRegistryChanged(this.contextRegistryEvent);
                ++i;
            }
        }
    }

    public List getContextContextBindingDefinitions() {
        return this.contextContextBindingDefinitions;
    }

    public List getContextDefinitions() {
        return this.contextDefinitions;
    }

    public void removeContextRegistryListener(IContextRegistryListener contextRegistryListener) {
        if (contextRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.contextRegistryListeners != null) {
            this.contextRegistryListeners.remove(contextRegistryListener);
        }
    }
}

