/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.help.internal.base.HelpBasePlugin;

public class BrowserLog {
    private static BrowserLog instance;
    private String logFileName;
    private boolean newSession;
    DateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
    String LN = System.getProperty("line.separator");

    private BrowserLog() {
        try {
            this.newSession = true;
            this.logFileName = HelpBasePlugin.getDefault().getStateLocation().append("browser.log").toOSString();
        }
        catch (Exception exception) {}
    }

    private static BrowserLog getInstance() {
        if (instance == null) {
            instance = new BrowserLog();
        }
        return instance;
    }

    public static synchronized void log(String message) {
        BrowserLog.getInstance().append(message);
    }

    private void append(String message) {
        block6: {
            if (this.logFileName == null) {
                return;
            }
            Writer outWriter = null;
            try {
                outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, true), "UTF-8"));
                if (this.newSession) {
                    this.newSession = false;
                    outWriter.write(String.valueOf(this.LN) + this.formatter.format(new Date()) + " NEW SESSION" + this.LN);
                }
                outWriter.write(String.valueOf(this.formatter.format(new Date())) + " " + message + this.LN);
                outWriter.flush();
                outWriter.close();
            }
            catch (Exception exception) {
                if (outWriter == null) break block6;
                try {
                    outWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

