/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.DependencySystem;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementChange;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.ResolutionDelta;
import org.eclipse.osgi.internal.resolver.Eclipse30SelectionPolicy;
import org.eclipse.osgi.internal.resolver.ResolverHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverImpl
implements Resolver {
    private State state;
    private DependencySystem dependencies;

    public void resolve(BundleDescription[] reRefresh) {
        int i = 0;
        while (i < reRefresh.length) {
            this.unresolveBundle(reRefresh[i]);
            ++i;
        }
        this.resolve();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void resolve() {
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (this.dependencies == null) {
            this.dependencies = ResolverHelper.buildDependencySystem(this.state, new Eclipse30SelectionPolicy());
        }
        delta = null;
        do {
            success = true;
            try {
                delta = this.dependencies.resolve();
                continue;
            }
            catch (DependencySystem.CyclicSystemException e) {
                success = false;
                cycles = e.getCycles();
                i = 0;
                ** while (i < cycles.length)
            }
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < cycles[i].length) {
                    ((ElementSet)cycles[i][j]).removeFromCycle();
                    ++j;
                }
                ++i;
                continue;
            }
lbl23:
            // 2 sources

        } while (!success);
        this.processInnerDelta(delta);
        this.resolvePackages();
    }

    public void setState(State newState) {
        if (this.state == newState) {
            return;
        }
        if (this.state != null) {
            State oldState = this.state;
            this.state = null;
            oldState.setResolver(null);
        }
        this.state = newState;
        if (newState != null) {
            this.state.setResolver((Resolver)this);
        }
        this.flush();
    }

    private void processInnerDelta(ResolutionDelta delta) {
        ElementChange[] changes = delta.getAllChanges();
        int i = 0;
        while (i < changes.length) {
            Element element = changes[i].getElement();
            BundleDescription bundle = (BundleDescription)element.getUserObject();
            int kind = changes[i].getKind();
            if ((kind & 4) != 0) {
                this.state.resolveBundle(bundle, 4);
                this.resolveConstraints(element);
            } else if ((kind & 8) != 0) {
                this.state.resolveBundle(bundle, 2);
            } else if (kind == 16) {
                this.resolveConstraints(element);
            }
            ++i;
        }
    }

    private void resolveConstraints(Element element) {
        Dependency[] dependencies = element.getDependencies();
        int j = 0;
        while (j < dependencies.length) {
            if (dependencies[j].getResolvedVersionId() != null) {
                VersionConstraint constraint = (VersionConstraint)dependencies[j].getUserObject();
                Version actualVersion = (Version)dependencies[j].getResolvedVersionId();
                BundleDescription supplier = this.state.getBundle(constraint.getName(), actualVersion);
                this.state.resolveConstraint(constraint, actualVersion, supplier);
            }
            ++j;
        }
    }

    public void bundleAdded(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.add(bundle, this.dependencies);
    }

    public void bundleRemoved(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.remove(bundle, this.dependencies);
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.update(newDescription, existingDescription, this.dependencies);
    }

    public State getState() {
        return this.state;
    }

    public void flush() {
        this.dependencies = null;
    }

    private boolean resolvePackages() {
        PackageSpecification exported;
        int j;
        PackageSpecification[] required;
        int i;
        HashMap<String, PackageSpecification> availablePackages;
        boolean success;
        int tries = 0;
        do {
            ++tries;
            success = true;
            BundleDescription[] initialBundles = this.state.getResolvedBundles();
            availablePackages = new HashMap<String, PackageSpecification>(11);
            i = 0;
            while (i < initialBundles.length) {
                required = initialBundles[i].getPackages();
                j = 0;
                while (j < required.length) {
                    if (required[j].isExported()) {
                        Version existingVersion;
                        Version toExport = required[j].getVersionRange().getMinimum();
                        PackageSpecification existing = (PackageSpecification)availablePackages.get(required[j].getName());
                        Version version = existingVersion = existing == null ? null : existing.getVersionRange().getMinimum();
                        if (existingVersion == null || toExport != null && toExport.isGreaterThan(existingVersion)) {
                            availablePackages.put(required[j].getName(), required[j]);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < initialBundles.length) {
                required = initialBundles[i].getPackages();
                j = 0;
                while (j < required.length) {
                    Version exportedVersion;
                    exported = (PackageSpecification)availablePackages.get(required[j].getName());
                    Version version = exportedVersion = exported == null ? null : exported.getVersionRange().getMinimum();
                    if (exported == null || !required[j].isSatisfiedBy(exportedVersion)) {
                        this.unresolveRequirementChain(initialBundles[i]);
                        success = false;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } while (!success);
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        i = 0;
        while (i < resolvedBundles.length) {
            required = resolvedBundles[i].getPackages();
            j = 0;
            while (j < required.length) {
                exported = (PackageSpecification)availablePackages.get(required[j].getName());
                this.state.resolveConstraint((VersionConstraint)required[j], exported.getVersionRange().getMinimum(), exported.getBundle());
                ++j;
            }
            ++i;
        }
        return tries > 1;
    }

    private void unresolveRequirementChain(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        this.state.resolveBundle(bundle, 2);
        if (bundle.getSymbolicName() == null) {
            return;
        }
        ElementSet bundleElementSet = this.dependencies.getElementSet(bundle.getSymbolicName());
        Collection requiring = bundleElementSet.getRequiringElements(bundle.getVersion());
        Iterator requiringIter = requiring.iterator();
        while (requiringIter.hasNext()) {
            Element requiringElement = (Element)requiringIter.next();
            BundleDescription requiringBundle = this.state.getBundle((String)requiringElement.getId(), (Version)requiringElement.getVersionId());
            if (requiringBundle == null) continue;
            this.unresolveRequirementChain(requiringBundle);
        }
    }

    private void unresolveBundle(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        if (this.dependencies != null) {
            ResolverHelper.unresolve(bundle, this.dependencies);
        }
    }
}

