/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class Container
extends Resource
implements IContainer {
    protected Container(IPath path, Workspace container) {
        super(path, container);
    }

    public void convertToPhantom() throws CoreException {
        if (this.isPhantom()) {
            return;
        }
        super.convertToPhantom();
        IResource[] members = this.members(3);
        int i = 0;
        while (i < members.length) {
            ((Resource)members[i]).convertToPhantom();
            ++i;
        }
    }

    public boolean exists(IPath childPath) {
        return this.workspace.getResourceInfo(this.getFullPath().append(childPath), false, false) != null;
    }

    public IResource findMember(String name) {
        return this.findMember(name, false);
    }

    public IResource findMember(String name, boolean phantom) {
        IPath childPath = this.getFullPath().append(name);
        ResourceInfo info = this.workspace.getResourceInfo(childPath, phantom, false);
        return info == null ? null : this.workspace.newResource(childPath, info.getType());
    }

    public IResource findMember(IPath childPath) {
        return this.findMember(childPath, false);
    }

    public IResource findMember(IPath childPath, boolean phantom) {
        childPath = this.getFullPath().append(childPath);
        ResourceInfo info = this.workspace.getResourceInfo(childPath, phantom, false);
        return info == null ? null : this.workspace.newResource(childPath, info.getType());
    }

    protected void fixupAfterMoveSource() throws CoreException {
        super.fixupAfterMoveSource();
        if (!this.synchronizing(this.getResourceInfo(true, false))) {
            return;
        }
        IResource[] members = this.members(3);
        int i = 0;
        while (i < members.length) {
            ((Resource)members[i]).fixupAfterMoveSource();
            ++i;
        }
    }

    protected IResource[] getChildren(Container parent, boolean phantom) {
        return this.getChildren(parent.getFullPath(), phantom);
    }

    protected IResource[] getChildren(IPath parentPath, boolean phantom) {
        IPath[] children = null;
        try {
            children = this.workspace.tree.getChildren(parentPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (children == null || children.length == 0) {
            return ICoreConstants.EMPTY_RESOURCE_ARRAY;
        }
        IResource[] result = new Resource[children.length];
        int j = 0;
        int i = 0;
        while (i < children.length) {
            ResourceInfo info = this.workspace.getResourceInfo(children[i], phantom, false);
            if (info != null) {
                result[j++] = this.workspace.newResource(children[i], info.getType());
            }
            ++i;
        }
        if (j == result.length) {
            return result;
        }
        IResource[] trimmedResult = new Resource[j];
        System.arraycopy(result, 0, trimmedResult, 0, j);
        return trimmedResult;
    }

    public IFile getFile(String name) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(name), 1));
    }

    public IFile getFile(IPath childPath) {
        return (IFile)((Object)this.workspace.newResource(this.getFullPath().append(childPath), 1));
    }

    public IFolder getFolder(String name) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(name), 2));
    }

    public IFolder getFolder(IPath childPath) {
        return (IFolder)((Object)this.workspace.newResource(this.getFullPath().append(childPath), 2));
    }

    public boolean isLocal(int flags, int depth) {
        if (!super.isLocal(flags, depth)) {
            return false;
        }
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(this, false);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResource[] members() throws CoreException {
        return this.members(0);
    }

    public IResource[] members(boolean phantom) throws CoreException {
        return this.members(phantom ? 1 : 0);
    }

    public IResource[] members(int memberFlags) throws CoreException {
        boolean phantom = (memberFlags & 1) != 0;
        ResourceInfo info = this.getResourceInfo(phantom, false);
        this.checkExists(this.getFlags(info), true);
        IResource[] allMembers = this.getChildren(this, phantom);
        if ((memberFlags & 2) != 0) {
            return allMembers;
        }
        int teamPrivateMemberCount = 0;
        int i = 0;
        while (i < allMembers.length) {
            Resource child = (Resource)allMembers[i];
            ResourceInfo childInfo = child.getResourceInfo(phantom, false);
            if (this.isTeamPrivateMember(this.getFlags(childInfo))) {
                ++teamPrivateMemberCount;
                allMembers[i] = null;
            }
            ++i;
        }
        if (teamPrivateMemberCount == 0) {
            return allMembers;
        }
        IResource[] reducedMembers = new IResource[allMembers.length - teamPrivateMemberCount];
        int nextPosition = 0;
        int i2 = 0;
        while (i2 < allMembers.length) {
            Resource child = (Resource)allMembers[i2];
            if (child != null) {
                reducedMembers[nextPosition++] = child;
            }
            ++i2;
        }
        return reducedMembers;
    }

    public String getDefaultCharset() throws CoreException {
        return this.getDefaultCharset(true);
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        HistoryStore historyStore = this.getLocalManager().getHistoryStore();
        IPath basePath = this.getFullPath();
        IWorkspaceRoot root = this.getWorkspace().getRoot();
        HashSet<IFile> deletedFiles = new HashSet<IFile>();
        if (depth == 0) {
            IFile file;
            if (historyStore.getStates(basePath).length > 0 && !(file = root.getFile(basePath)).exists()) {
                deletedFiles.add(file);
            }
        } else {
            Set allFilePaths = historyStore.allFiles(basePath, depth);
            Iterator it = allFilePaths.iterator();
            while (it.hasNext()) {
                IPath filePath = (IPath)it.next();
                IFile file = root.getFile(filePath);
                if (file.exists()) continue;
                deletedFiles.add(file);
            }
        }
        return deletedFiles.toArray(new IFile[deletedFiles.size()]);
    }

    public void setDefaultCharset(String charset) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), charset);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDefaultCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingDefaultCharsetContainer", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this.getType() == 8 ? this : this.getProject());
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
                    IElementContentVisitor visitor = new IElementContentVisitor(){
                        boolean visitedRoot = false;

                        public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                            if (elementContents == null) {
                                return false;
                            }
                            IPath nodePath = requestor.requestPath();
                            if (!this.visitedRoot) {
                                this.visitedRoot = true;
                                ResourceInfo info = Container.this.workspace.getResourceInfo(nodePath, false, true);
                                if (info == null) {
                                    return false;
                                }
                                info.incrementCharsetGenerationCount();
                                return true;
                            }
                            if (Container.this.workspace.getCharsetManager().getCharsetFor(nodePath, false) != null) {
                                return false;
                            }
                            ResourceInfo info = Container.this.workspace.getResourceInfo(nodePath, false, true);
                            if (info == null) {
                                return false;
                            }
                            info.incrementCharsetGenerationCount();
                            return true;
                        }
                    };
                    try {
                        new ElementTreeIterator(this.workspace.getElementTree(), this.getFullPath()).iterate(visitor);
                    }
                    catch (WrappedRuntimeException e) {
                        throw (CoreException)e.getTargetException();
                    }
                    monitor.worked(Policy.opWork);
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var8_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        monitor.done();
    }
}

