/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.refresh.PollingMonitor;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class MonitorManager
implements IResourceChangeListener,
IResourceDeltaVisitor,
IPathVariableChangeListener {
    private RefreshProvider[] providers;
    protected PollingMonitor pollMonitor;
    protected RefreshManager refreshManager;
    protected Map registeredMonitors;
    protected IWorkspace workspace;

    public MonitorManager(IWorkspace workspace, RefreshManager refreshManager) {
        this.workspace = workspace;
        this.refreshManager = refreshManager;
        this.registeredMonitors = Collections.synchronizedMap(new HashMap(10));
        this.pollMonitor = new PollingMonitor(refreshManager);
    }

    private RefreshProvider[] getRefreshProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        IPluginDescriptor descriptor = ResourcesPlugin.getPlugin().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("refreshProviders");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        ArrayList<RefreshProvider> providerList = new ArrayList<RefreshProvider>(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            RefreshProvider provider = null;
            try {
                provider = (RefreshProvider)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
            if (provider != null) {
                providerList.add(provider);
            }
            ++i;
        }
        this.providers = providerList.toArray(new RefreshProvider[providerList.size()]);
        return this.providers;
    }

    private List getResourcesToMonitor() {
        ArrayList<IResource> resourcesToMonitor = new ArrayList<IResource>(10);
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            resourcesToMonitor.add(projects[i]);
            try {
                IResource[] members = projects[i].members();
                int j = 0;
                while (j < members.length) {
                    if (members[j].isLinked()) {
                        resourcesToMonitor.add(members[j]);
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            }
            ++i;
        }
        return resourcesToMonitor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMonitoring(IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List resources;
            Iterator i = this.registeredMonitors.keySet().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while ((resources = (List)this.registeredMonitors.get(i.next())) == null || !resources.contains(resource));
            return true;
        }
    }

    boolean monitor(IResource resource) {
        if (this.isMonitoring(resource)) {
            return false;
        }
        boolean pollingMonitorNeeded = true;
        RefreshProvider[] providers = this.getRefreshProviders();
        int i = 0;
        while (i < providers.length) {
            IRefreshMonitor monitor = this.safeInstallMonitor(providers[i], resource);
            if (monitor != null) {
                this.registerMonitor(monitor, resource);
                pollingMonitorNeeded = false;
            }
            ++i;
        }
        if (pollingMonitorNeeded) {
            this.pollMonitor.monitor(resource);
            this.registerMonitor(this.pollMonitor, resource);
        }
        return pollingMonitorNeeded;
    }

    private IRefreshMonitor safeInstallMonitor(RefreshProvider provider, IResource resource) {
        Throwable t = null;
        try {
            return provider.installMonitor(resource, this.refreshManager);
        }
        catch (Exception e) {
            t = e;
        }
        catch (LinkageError e) {
            t = e;
        }
        if (t != null) {
            Status error = new Status(4, "org.eclipse.core.resources", 1, Policy.bind("refresh.installError"), t);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)error);
        }
        return null;
    }

    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
        if (RefreshManager.DEBUG) {
            System.err.println("Auto-refresh:  monitor (" + monitor + ") failed to monitor resource: " + resource);
        }
        if (this.registeredMonitors == null || monitor == null) {
            return;
        }
        if (resource == null) {
            List resources = (List)this.registeredMonitors.get(monitor);
            if (resources == null || resources.isEmpty()) {
                this.registeredMonitors.remove(monitor);
                return;
            }
            Map map = this.registeredMonitors;
            synchronized (map) {
                Iterator i = resources.iterator();
                while (i.hasNext()) {
                    resource = (IResource)i.next();
                    this.pollMonitor.monitor(resource);
                    this.registerMonitor(this.pollMonitor, resource);
                }
                this.registeredMonitors.remove(monitor);
            }
        } else {
            this.removeMonitor(monitor, resource);
            this.pollMonitor.monitor(resource);
            this.registerMonitor(this.pollMonitor, resource);
        }
    }

    public void pathVariableChanged(IPathVariableChangeEvent event) {
        if (this.registeredMonitors.isEmpty()) {
            return;
        }
        String variableName = event.getVariableName();
        HashSet<IResource> invalidResources = new HashSet<IResource>();
        Iterator<Object> i = this.registeredMonitors.values().iterator();
        while (i.hasNext()) {
            Iterator j = ((List)i.next()).iterator();
            while (j.hasNext()) {
                IResource resource = (IResource)j.next();
                IPath rawLocation = resource.getRawLocation();
                if (rawLocation == null || rawLocation.segmentCount() <= 0 || !variableName.equals(rawLocation.segment(0)) || invalidResources.contains(resource)) continue;
                invalidResources.add(resource);
            }
        }
        if (!invalidResources.isEmpty()) {
            i = invalidResources.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                this.unmonitor(resource);
                this.monitor(resource);
            }
        }
    }

    private void registerMonitor(IRefreshMonitor monitor, IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            ArrayList<IResource> resources = (ArrayList<IResource>)this.registeredMonitors.get(monitor);
            if (resources == null) {
                resources = new ArrayList<IResource>(1);
                this.registeredMonitors.put(monitor, resources);
            }
            if (!resources.contains(resource)) {
                resources.add(resource);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  added monitor (" + monitor + ") on resource: " + resource);
        }
    }

    private void removeMonitor(IRefreshMonitor monitor, IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List resources = (List)this.registeredMonitors.get(monitor);
            if (resources != null && !resources.isEmpty()) {
                resources.remove(resource);
            } else {
                this.registeredMonitors.remove(monitor);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  removing monitor (" + monitor + ") on resource: " + resource);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                IProject project = (IProject)event.getResource();
                this.unmonitor(project);
                break;
            }
            default: {
                try {
                    event.getDelta().accept(this);
                    break;
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
        }
    }

    public void start() {
        boolean refreshNeeded = false;
        Iterator i = this.getResourcesToMonitor().iterator();
        while (i.hasNext()) {
            refreshNeeded |= !this.monitor((IResource)i.next());
        }
        this.workspace.addResourceChangeListener(this);
        this.workspace.getPathVariableManager().addChangeListener(this);
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  starting monitor manager.");
        }
        if (refreshNeeded) {
            new PollingMonitor(this.refreshManager).runOnce();
        }
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this);
        this.workspace.getPathVariableManager().removeChangeListener(this);
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator i = this.registeredMonitors.keySet().iterator();
            while (i.hasNext()) {
                IRefreshMonitor monitor = (IRefreshMonitor)i.next();
                monitor.unmonitor(null);
            }
        }
        this.registeredMonitors.clear();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  stopping monitor manager.");
        }
    }

    void unmonitor(IResource resource) {
        if (resource == null || !this.isMonitoring(resource)) {
            return;
        }
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator i = this.registeredMonitors.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry current = i.next();
                List resources = (List)current.getValue();
                if (resources == null || resources.isEmpty() || !resources.contains(resource)) continue;
                ((IRefreshMonitor)current.getKey()).unmonitor(resource);
                resources.remove(resource);
            }
        }
        if (resource.getType() == 4) {
            this.unmonitorLinkedContents((IProject)resource);
        }
    }

    private void unmonitorLinkedContents(IProject project) {
        IResource[] children = null;
        try {
            children = project.members();
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        if (children != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isLinked()) {
                    this.unmonitor(children[i]);
                }
                ++i;
            }
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 1: 
            case 2: {
                if (resource.isLinked()) {
                    switch (delta.getKind()) {
                        case 1: {
                            this.monitor(resource);
                            break;
                        }
                        case 2: {
                            this.unmonitor(resource);
                            break;
                        }
                    }
                }
                return false;
            }
            case 8: {
                return true;
            }
            case 4: {
                IProject project = (IProject)resource;
                switch (delta.getKind()) {
                    case 1: {
                        if (!project.isOpen()) break;
                        this.monitor(project);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) == 0 || !project.isOpen()) break;
                        this.monitor(project);
                        break;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

