/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.optipngwrapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.jpn.xucker.optipngwrapper.ResultData;
import org.jpn.xucker.rcp.optipngwrapper.OptimizeListener;

public class OptiPNGExecuter {
    private int finish;
    private String level = "5";
    private File output;
    private List fileList = new Vector();
    private String optipngPath = "optipng.exe";
    private String backupExtension = ".bk";
    private boolean doBackup;
    private List resultVector = new Vector();
    private boolean timeKeep;
    private OptimizeListener optimizeListener;

    public ResultData[] getResultData() {
        return this.resultVector.toArray(new ResultData[this.resultVector.size()]);
    }

    public String getBackupExtension() {
        return this.backupExtension;
    }

    public void setBackupExtension(String backupExtension) {
        this.backupExtension = backupExtension;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public void setDoBackup(boolean doBackup) {
        this.doBackup = doBackup;
    }

    public String getOptipngPath() {
        return this.optipngPath;
    }

    public void setOptipngPath(String optipngPath) {
        this.optipngPath = optipngPath;
    }

    public void addFile(String path) {
        this.fileList.add(path);
    }

    public void execute() throws IOException {
        File f = new File(this.optipngPath);
        if (!f.exists()) {
            throw new IOException("file not exsits :" + this.optipngPath);
        }
        try {
            int v = Integer.parseInt(this.level);
            if (v < 0 || v > 7) {
                v = 7;
            }
            String cfr_ignored_0 = "" + v;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] paths = this.fileList.toArray(new String[this.fileList.size()]);
        int i = 0;
        while (i < paths.length) {
            this.preExecute(new File(paths[i]));
            ++i;
        }
    }

    private void preExecute(File file) {
        if (this.output != null) {
            String rootFolder = file.getParent();
            this.doExecute(rootFolder, this.output, file);
        } else {
            this.doExecute(null, null, file);
        }
    }

    private String getRelativePath(File file, String basePath) {
        if (!file.getAbsolutePath().startsWith(basePath)) {
            throw new RuntimeException("not start basePath");
        }
        if (!basePath.endsWith(System.getProperty("file.separator"))) {
            throw new RuntimeException("basepath not ends with file separator");
        }
        if (file.isDirectory()) {
            throw new RuntimeException("file is must file");
        }
        return file.getAbsolutePath().substring(basePath.length());
    }

    private void doExecute(String rootFolder, File output, File file) {
        if (this.optimizeListener != null) {
            this.optimizeListener.optimizeStart(file, output);
        }
        if (file.isDirectory()) {
            String[] list = file.list();
            int i = 0;
            while (i < list.length) {
                File tmp = new File(file, list[i]);
                if (tmp.isDirectory() || tmp.getName().toLowerCase().endsWith(".png")) {
                    this.doExecute(rootFolder, output, tmp);
                }
                ++i;
            }
        } else {
            long predate = file.lastModified();
            long pre = file.length();
            File optimizeFile = null;
            if (output != null) {
                optimizeFile = new File(output, this.getRelativePath(file, rootFolder));
                if (!file.getAbsolutePath().equals(optimizeFile.getAbsolutePath())) {
                    try {
                        FileUtils.copyFile((File)file, (File)optimizeFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                optimizeFile = file;
            }
            if (optimizeFile.getAbsolutePath().equals(file.getAbsolutePath()) && this.isDoBackup()) {
                try {
                    FileUtils.copyFile((File)file, (File)new File(optimizeFile.getParentFile(), String.valueOf(optimizeFile.getName()) + this.getBackupExtension()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.callOptiPng(optimizeFile, this.level);
            if (this.timeKeep) {
                optimizeFile.setLastModified(predate);
            }
            long end = optimizeFile.length();
            ResultData result = new ResultData();
            result.setFile(optimizeFile.getName());
            result.setDirectory(optimizeFile.getParent());
            result.setSize(pre, end);
            this.resultVector.add(result);
            if (this.optimizeListener != null) {
                this.optimizeListener.optimizeEnd(file, output, pre, end);
            }
        }
    }

    private void callOptiPng(File outputFile, String level) {
        Runtime runtime = Runtime.getRuntime();
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String[] args = new String[]{this.optipngPath, "-q", "-v", "-o", level, outputFile.getAbsolutePath()};
        try {
            Process process = runtime.exec(args);
            process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.finish;
    }

    public static String readAll(InputStream reader) {
        StringBuffer text = new StringBuffer();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                System.out.println((char)c);
                text.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    public String getLevel() {
        return this.level;
    }

    public File getOutput() {
        return this.output;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public OptimizeListener getOptimizeListener() {
        return this.optimizeListener;
    }

    public void setOptimizeListener(OptimizeListener optimizeListener) {
        this.optimizeListener = optimizeListener;
    }

    public boolean isTimeKeep() {
        return this.timeKeep;
    }

    public void setTimeKeep(boolean timeKeep) {
        this.timeKeep = timeKeep;
    }
}

