/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.io.read.BeanBindAction;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadConfiguration;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class BeanRuleSet
implements RuleSet {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanRuleSet == null ? (class$org$apache$commons$betwixt$io$BeanRuleSet = BeanRuleSet.class$("org.apache.commons.betwixt.io.BeanRuleSet")) : class$org$apache$commons$betwixt$io$BeanRuleSet));
    private String basePath;
    private ElementDescriptor baseElementDescriptor;
    private DigesterReadContext context;
    private String classNameAttribute = "className";
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanRuleSet;

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, boolean matchIDs) {
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        BindingConfiguration bindingConfiguration = new BindingConfiguration();
        bindingConfiguration.setMapIDs(matchIDs);
        this.context = new DigesterReadContext(log, bindingConfiguration, new ReadConfiguration());
        this.context.setRootClass(baseBeanClass);
        this.context.setXMLIntrospector(introspector);
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Context context) {
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        this.context = new DigesterReadContext(context, new ReadConfiguration());
        this.context.setRootClass(baseElementDescriptor.getSingularPropertyType());
        this.context.setXMLIntrospector(introspector);
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, Context context) {
        this(introspector, basePath, baseElementDescriptor, baseBeanClass, new ReadContext(context, new ReadConfiguration()));
    }

    public BeanRuleSet(XMLIntrospector introspector, String basePath, ElementDescriptor baseElementDescriptor, Class baseBeanClass, ReadContext baseContext) {
        this.basePath = basePath;
        this.baseElementDescriptor = baseElementDescriptor;
        this.context = new DigesterReadContext(baseContext);
        this.context.setRootClass(baseBeanClass);
        this.context.setXMLIntrospector(introspector);
    }

    public String getClassNameAttribute() {
        return this.context.getClassNameAttribute();
    }

    public void setClassNameAttribute(String classNameAttribute) {
        this.context.setClassNameAttribute(classNameAttribute);
    }

    public String getNamespaceURI() {
        return null;
    }

    public void addRuleInstances(Digester digester) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding rules to:" + digester));
        }
        this.context.setDigester(digester);
        if (this.context.getClassLoader() == null) {
            this.context.setClassLoader(digester.getClassLoader());
        }
        digester.addRule("!" + this.basePath + "/*", (Rule)new ActionMappingRule());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DigesterReadContext
    extends ReadContext {
        private Digester digester;

        public DigesterReadContext(Context context, ReadConfiguration readConfiguration) {
            super(context, readConfiguration);
        }

        public DigesterReadContext(BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
            super(bindingConfiguration, readConfiguration);
        }

        public DigesterReadContext(Log log, BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
            super(log, bindingConfiguration, readConfiguration);
        }

        public DigesterReadContext(ReadContext readContext) {
            super(readContext);
        }

        public Digester getDigester() {
            return this.digester;
        }

        public void setDigester(Digester digester) {
            this.digester = digester;
        }

        public void pushBean(Object bean) {
            super.pushBean(bean);
            this.digester.push(bean);
        }

        public Object popBean() {
            Object bean = super.popBean();
            Object top = this.digester.pop();
            return bean;
        }
    }

    private final class ActionMappingRule
    extends Rule {
        private ActionMappingRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            if (log.isTraceEnabled()) {
                int attributesLength = attributes.getLength();
                if (attributesLength > 0) {
                    log.trace((Object)"Attributes:");
                }
                int i = 0;
                int size = attributesLength;
                while (i < size) {
                    log.trace((Object)("Local:" + attributes.getLocalName(i)));
                    log.trace((Object)("URI:" + attributes.getURI(i)));
                    log.trace((Object)("QName:" + attributes.getQName(i)));
                    ++i;
                }
            }
            BeanRuleSet.this.context.pushElement(name);
            MappingAction nextAction = this.nextAction(namespace, name, attributes, BeanRuleSet.this.context);
            BeanRuleSet.this.context.pushMappingAction(nextAction);
        }

        private MappingAction nextAction(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            MappingAction result = null;
            MappingAction lastAction = context.currentMappingAction();
            result = lastAction == null ? BeanBindAction.INSTANCE : lastAction.next(namespace, name, attributes, context);
            return ((MappingAction)result).begin(namespace, name, attributes, context);
        }

        public void body(String namespace, String name, String text) throws Exception {
            log.trace((Object)("[BRS] Body with text " + text));
            if (this.digester.getCount() > 0) {
                MappingAction action = BeanRuleSet.this.context.currentMappingAction();
                action.body(text, BeanRuleSet.this.context);
            } else {
                log.trace((Object)"[BRS] ZERO COUNT");
            }
        }

        public void end(String namespace, String name) throws Exception {
            MappingAction action = BeanRuleSet.this.context.popMappingAction();
            action.end(BeanRuleSet.this.context);
        }

        public void finish() {
            BeanRuleSet.this.context.clearBeans();
        }
    }
}

