/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#ifndef ADP_BASE_H
#define ADP_BASE_H
#include <fstream>
#include <vector>
#include <map>
#include <string>
#include <cctype>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <sstream>
#include <functional>
#include <time.h>
#include <limits.h>
#include <float.h>
#include <stdlib.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <boost/regex.hpp>

#ifdef _WIN32
#include <windows.h>
#include <Wincrypt.h>
#include <io.h>
#include <direct.h>
#pragma comment (lib, "Crypt32")
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <openssl/sha.h>
#include <unistd.h>
#define SOCKET	int
#define closesocket	close
#endif
#include "kz_base.h"
#include "kz_array.h"
#include "kz_array_noexpand.h"
#include "kz_cformat.h"
#include "kz_net.h"
#include "kz_odbc.h"
#include "kz_readcsv.h"
#include "kz_scanregex.h"

using namespace std;

#ifdef ADP_COMMON_CPP
#define EXTERN 
#else
#define EXTERN	extern
#endif


// vf
class PObject;
class PNil;
class PString;
class PDouble;
class PInteger;
class PList;
class PArray;
class PPredicate;
class PVeriable;
class PEVeriable;
class PWildCard;
class PGoal;
class PHorn;
class PHorns;
class PMemoryManager;

// s 
class CompileContext;
class ExecContext_Factory;
struct ExecContextRoot;
struct ExecContextBase;
struct ExecContext;

// IuWFNg̔j 
struct MyDeleteObject {
	template <typename T> void operator() (const T* ptr) const {
		delete ptr;
	}
};

// ύǗ}bv 
typedef vector<string> VNames;

// O[oɎg^i{j 
typedef long long PINTEGER;
#define PINTEGER_MAX (LLONG_MAX)
#define PINTEGER_MIN (LLONG_MIN)
typedef Array<const PObject*> PObjectArray;
typedef ArrayNoexpand<const PObject*> PObjectArrayNE;
typedef ArrayNoexpand<const PObject*> VLocal;
typedef map<string, size_t> PHashArrayMap;
typedef pair<string, size_t> PHashArrayPair;

typedef map<string,string>	ssmap;
typedef pair<string,string>	sspair;
typedef std::vector< std::string > string_array;

typedef ExecContextRoot *(*ExecContext_FactoryFunction)(ExecContext *, void *, const PPredicate *pred_, VLocal *l);
typedef Array<ExecContextRoot*>	ExecContextRootArray;
typedef ArrayNoexpand<ExecContextRoot*>	ExecContextRootArrayNE;

// O[oϐi萔j 
extern PNil pnil;
extern PWildCard pwildcard;

// vbgz[ˑ̒` 
#if _WIN32
const char	pseparator = '\\';
#define NOALIAS_FUNC	__declspec(noalias)
#define RESTRICT_FUNC	__declspec(restrict)
#define  __attribute__(X) 
#define atoll _atoi64
#define strtoll	_strtoi64
#else
const char	pseparator = '/';
#define NOALIAS_FUNC 
#define RESTRICT_FUNC 
#define __forceinline 
#define _chdir chdir
#define _unlink unlink
#define _rmdir rmdir
#endif

// O[o֐ O`KvȂ́i`ł悯 adp_global.hŒ` 
void print_header();

template <class T> int sign(T v) {
    if ( v < 0 ) return -1;
    if ( v == 0 ) return 0;
    return 1;
};


// string ̃nbVl
inline int string_hash(const string &value) {
	size_t siz = value.size();
	int h = siz;
	for ( size_t i = 0; i < siz; i++ ) {
		h += value[i];
		h <<= 4;
		h += value[i];
	}
	return h;
}

#endif
