/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.install.ConfigurationPanel;
import org.compiere.install.Setup_Help;
import org.compiere.swing.CFrame;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;

public class Setup
extends CFrame
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("org.compiere.install.SetupRes");
    private JPanel contentPane;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private CMenuItem menuFileExit = new CMenuItem();
    private JMenu menuHelp = new JMenu();
    private CMenuItem menuHelpInfo = new CMenuItem();
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout = new BorderLayout();
    private ConfigurationPanel configurationPanel = new ConfigurationPanel(this.statusBar);

    public Setup() {
        CLogger.get().info(Adempiere.getSummaryAscii());
        this.enableEvents(64L);
        this.setDefaultCloseOperation(3);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        AEnv.showCenterScreen((Window)((Object)this));
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.configurationPanel.dynInit();
            AEnv.positionCenterScreen((Window)((Object)this));
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(Adempiere.getImage16());
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout);
        this.setTitle(res.getString("AdempiereServerSetup"));
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setText(" ");
        this.menuFile.setText(res.getString("File"));
        this.menuFileExit.setText(res.getString("Exit"));
        this.menuFileExit.addActionListener((ActionListener)this);
        this.menuHelp.setText(res.getString("Help"));
        this.menuHelpInfo.setText(res.getString("Help"));
        this.menuHelpInfo.addActionListener((ActionListener)this);
        this.borderLayout.setHgap(5);
        this.borderLayout.setVgap(5);
        this.menuFile.add((JMenuItem)this.menuFileExit);
        this.menuHelp.add((JMenuItem)this.menuHelpInfo);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)((Object)this.configurationPanel), "Center");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuFileExit) {
            System.exit(0);
        } else if (e.getSource() == this.menuHelpInfo) {
            new Setup_Help((Frame)((Object)this));
        }
    }

    public static void main(String[] args) {
        CLogMgt.initialize((boolean)true);
        CLogFile fileHandler = new CLogFile(System.getProperty("user.dir"), false, false);
        CLogMgt.addHandler((Handler)fileHandler);
        if (args.length > 0) {
            CLogMgt.setLevel((String)args[0]);
        } else {
            CLogMgt.setLevel((Level)Level.INFO);
        }
        if (fileHandler.getLevel().intValue() > Level.FINE.intValue()) {
            fileHandler.setLevel(Level.FINE);
        }
        new Setup();
    }
}

