/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.net.InetAddress;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigJBoss
extends Config {
    public ConfigJBoss(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setAppsServerDeployDir(this.getDeployDir());
        this.p_data.setAppsServerDeployDir(false);
        this.p_data.setAppsServerJNPPort("1099");
        this.p_data.setAppsServerJNPPort(true);
        this.p_data.setAppsServerWebPort("80");
        this.p_data.setAppsServerWebPort(true);
        this.p_data.setAppsServerSSLPort("443");
        this.p_data.setAppsServerSSLPort(true);
    }

    private String getDeployDir() {
        return this.p_data.getAdempiereHome() + File.separator + "jboss" + File.separator + "server" + File.separator + "adempiere" + File.separator + "deploy";
    }

    public String test() {
        String server = this.p_data.getAppsServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        InetAddress appsServer = null;
        String error = "Not correct: AppsServer = " + server;
        try {
            if (pass) {
                appsServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okAppsServer, "ErrorAppsServer", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: AppsServer = " + appsServer);
        this.setProperty("ADEMPIERE_APPS_SERVER", appsServer.getHostName());
        this.setProperty("ADEMPIERE_APPS_TYPE", this.p_data.getAppsServerType());
        this.p_data.setAppsServerDeployDir(this.getDeployDir());
        File deploy = new File(this.p_data.getAppsServerDeployDir());
        pass = deploy.exists();
        error = "Not found: " + deploy;
        this.signalOK(this.getPanel().okDeployDir, "ErrorDeployDir", pass, true, error);
        if (!pass) {
            return error;
        }
        this.setProperty("ADEMPIERE_APPS_DEPLOY", this.p_data.getAppsServerDeployDir());
        log.info("OK: Deploy Directory = " + deploy);
        int JNPPort = this.p_data.getAppsServerJNPPort();
        pass = !this.p_data.testPort(appsServer, JNPPort, false) && this.p_data.testServerPort(JNPPort);
        error = "Not correct: JNP Port = " + JNPPort;
        this.signalOK(this.getPanel().okJNPPort, "ErrorJNPPort", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: JNPPort = " + JNPPort);
        this.setProperty("ADEMPIERE_JNP_PORT", String.valueOf(JNPPort));
        int WebPort = this.p_data.getAppsServerWebPort();
        pass = !this.p_data.testPort("http", appsServer.getHostName(), WebPort, "/") && this.p_data.testServerPort(WebPort);
        error = "Not correct: Web Port = " + WebPort;
        this.signalOK(this.getPanel().okWebPort, "ErrorWebPort", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: Web Port = " + WebPort);
        this.setProperty("ADEMPIERE_WEB_PORT", String.valueOf(WebPort));
        int sslPort = this.p_data.getAppsServerSSLPort();
        pass = !this.p_data.testPort("https", appsServer.getHostName(), sslPort, "/") && this.p_data.testServerPort(sslPort);
        error = "Not correct: SSL Port = " + sslPort;
        this.signalOK(this.getPanel().okSSLPort, "ErrorWebPort", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: SSL Port = " + sslPort);
        this.setProperty("ADEMPIERE_SSL_PORT", String.valueOf(sslPort));
        return null;
    }
}

