/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.net.InetAddress;
import java.sql.Connection;
import org.compiere.db.DB_Fyracle;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigFyracle
extends Config {
    private String[] p_discovered = null;
    private DB_Fyracle p_db = new DB_Fyracle();

    public ConfigFyracle(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setDatabasePort(String.valueOf(3050));
    }

    public String[] discoverDatabases(String selected) {
        if (this.p_discovered != null) {
            return this.p_discovered;
        }
        this.p_discovered = new String[0];
        return this.p_discovered;
    }

    public String test() {
        String server = this.p_data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabaseServer", pass, true, error);
        log.info("OK: Database Server = " + databaseServer);
        this.setProperty("ADEMPIERE_DB_SERVER", databaseServer.getHostName());
        this.setProperty("ADEMPIERE_DB_TYPE", this.p_data.getDatabaseType());
        int databasePort = this.p_data.getDatabasePort();
        pass = this.p_data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabasePort", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: Database Port = " + databasePort);
        this.setProperty("ADEMPIERE_DB_PORT", String.valueOf(databasePort));
        String databaseName = this.p_data.getDatabaseName();
        String systemPassword = this.p_data.getDatabaseSystemPassword();
        String urlSystem = this.p_db.getConnectionURL(databaseServer.getHostName(), databasePort, this.p_db.getSystemDatabase(databaseName), this.p_db.getSystemUser());
        pass = this.testJDBC(urlSystem, this.p_db.getSystemUser(), systemPassword);
        error = "Error connecting: " + urlSystem + " - " + this.p_db.getSystemUser() + "/" + systemPassword;
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: System Connection = " + urlSystem);
        this.setProperty("ADEMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = this.p_data.getDatabaseUser();
        String databasePassword = this.p_data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "No Database User Password entered";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url = this.p_db.getConnectionURL(databaseServer.getHostName(), databasePort, databaseName, databaseUser);
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Database imported? Cannot connect to User: " + databaseUser + "/" + databasePassword;
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, false, error);
        if (pass) {
            log.info("OK: Database User = " + databaseUser);
        } else {
            log.warning(error);
        }
        this.setProperty("ADEMPIERE_DB_URL", url);
        this.setProperty("ADEMPIERE_DB_NAME", databaseName);
        this.setProperty("ADEMPIERE_DB_USER", databaseUser);
        this.setProperty("ADEMPIERE_DB_PASSWORD", databasePassword);
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        try {
            Connection conn = this.p_db.getDriverConnection(url, uid, pwd);
        }
        catch (Exception e) {
            log.severe(e.toString());
            return false;
        }
        return true;
    }
}

