/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import com.ibm.db2.jcc.DB2Driver;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.util.Env;

public class ConfigDB2
extends Config {
    private static DB2Driver s_db2Driver = null;
    private Connection m_con = null;

    public ConfigDB2(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setDatabasePort(String.valueOf(50000));
        this.p_data.setDatabaseName("adempiere");
        this.p_data.setDatabaseSystemPassword(true);
    }

    public String test() {
        String server = this.p_data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabaseServer", pass, true, error);
        log.info("OK: Database Server = " + databaseServer);
        this.setProperty("ADEMPIERE_DB_SERVER", databaseServer.getHostName());
        this.setProperty("ADEMPIERE_DB_TYPE", this.p_data.getDatabaseType());
        int databasePort = this.p_data.getDatabasePort();
        pass = this.p_data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabasePort", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: Database Port = " + databasePort);
        this.setProperty("ADEMPIERE_DB_PORT", String.valueOf(databasePort));
        String databaseName = this.p_data.getDatabaseName();
        String systemPassword = this.p_data.getDatabaseSystemPassword();
        pass = systemPassword != null && systemPassword.length() > 0;
        error = "No Database System Password entered";
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url = "jdbc:db2://" + databaseServer.getHostName() + ":" + databasePort + "/" + databaseName;
        pass = this.testJDBC(url, "db2admin", systemPassword);
        error = "Error connecting: " + url + " - as db2admin/" + systemPassword;
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        log.info("OK: Connection = " + url);
        this.setProperty("ADEMPIERE_DB_URL", url);
        log.info("OK: Database System User " + databaseName);
        this.setProperty("ADEMPIERE_DB_NAME", databaseName);
        this.setProperty("ADEMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = this.p_data.getDatabaseUser();
        String databasePassword = this.p_data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "Invalid Database User Password";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Database imported? Cannot connect to User: " + databaseUser + "/" + databasePassword;
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, false, error);
        if (pass) {
            log.info("OK: Database User = " + databaseUser);
            if (this.m_con != null) {
                this.setProperty("ADEMPIERE_WEBSTORES", this.getWebStores(this.m_con));
            }
        } else {
            log.warning(error);
        }
        this.setProperty("ADEMPIERE_DB_USER", databaseUser);
        this.setProperty("ADEMPIERE_DB_PASSWORD", databasePassword);
        if (!this.p_data.getAppsServerType().equals(ConfigurationData.APPSTYPE_TOMCAT)) {
            String cmd = "db2 ";
            if (Env.isWindows()) {
                cmd = "db2cmd -c -w -i db2 ";
            }
            String sqlcmd1 = cmd + "connect to xx";
            String sqlcmd2 = cmd + "-f utils/db2/Test.sql";
            log.config(sqlcmd2);
            pass = this.testSQL(sqlcmd2);
            error = "Error connecting via: " + sqlcmd2;
            this.signalOK(this.getPanel().okDatabaseSQL, "ErrorTNS", pass, true, error);
            if (pass) {
                log.info("OK: Database SQL Connection");
            }
        }
        this.m_con = null;
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        log.fine("Url=" + url + ", UID=" + uid);
        try {
            if (s_db2Driver == null) {
                s_db2Driver = new DB2Driver();
                DriverManager.registerDriver((Driver)s_db2Driver);
            }
            this.m_con = DriverManager.getConnection(url, uid, pwd);
        }
        catch (Exception e) {
            log.warning(e.toString());
            return false;
        }
        return true;
    }

    private boolean testSQL(String sqlcmd) {
        return true;
    }
}

