/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.ServerHome;
import org.compiere.interfaces.Status;
import org.compiere.interfaces.StatusHome;

public class StatusInfo
extends HttpServlet {
    private static final String CONTENT_TYPE = "text/html";

    public void init() throws ServletException {
        this.getServletContext().log("StatusInfo.init");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>Status Info</title></head>");
        out.println("<body>");
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (Exception ex) {
            out.println("<p><b>" + ex + "</b></p>");
        }
        try {
            StatusHome statusHome = (StatusHome)context.lookup("adempiere/Status");
            Status status = statusHome.create();
            out.println("<p>" + status.getStatus() + "</p>");
            status.remove();
        }
        catch (Exception ex) {
            out.println("<p><b>" + ex + "</b></p>");
        }
        try {
            ServerHome serverHome = (ServerHome)context.lookup("adempiere/Server");
            Server server = serverHome.create();
            out.println("<p>" + server.getStatus() + "</p>");
            server.remove();
        }
        catch (Exception ex) {
            out.println("<p><b>" + ex + "</b></p>");
        }
        try {
            out.println("<h2>-- /</h2>");
            NamingEnumeration<NameClassPair> ne = context.list("/");
            while (ne.hasMore()) {
                out.println("<br>   " + ne.nextElement());
            }
            out.println("<h2>-- java</h2>");
            ne = context.list("java:");
            while (ne.hasMore()) {
                out.println("<br>   " + ne.nextElement());
            }
            out.println("<h2>-- ejb</h2>");
            ne = context.list("ejb");
            while (ne.hasMore()) {
                out.println("<br>   " + ne.nextElement());
            }
            out.println("<h2>-- DS</h2>");
            DataSource ds = (DataSource)context.lookup("java:/OracleDS");
            out.println("<br>  DataSource " + ds.getClass().getName() + " LoginTimeout=" + ds.getLoginTimeout());
            Connection con = ds.getConnection("adempiere", "adempiere");
            out.println("<br>  Connection ");
            this.getServletContext().log("Connection closed=" + con.isClosed());
            DatabaseMetaData dbmd = con.getMetaData();
            this.getServletContext().log("DB " + dbmd.getDatabaseProductName());
            this.getServletContext().log("DB V " + dbmd.getDatabaseProductVersion());
            this.getServletContext().log("Driver " + dbmd.getDriverName());
            this.getServletContext().log("Driver V " + dbmd.getDriverVersion());
            this.getServletContext().log("JDBC " + dbmd.getJDBCMajorVersion());
            this.getServletContext().log("JDBC mV " + dbmd.getJDBCMinorVersion());
            this.getServletContext().log("User " + dbmd.getUserName());
            this.getServletContext().log("ANSI 92 " + dbmd.supportsANSI92FullSQL());
            this.getServletContext().log("Connection Alter Table ADD" + dbmd.supportsAlterTableWithAddColumn());
            this.getServletContext().log("Connection Alter Table DROP " + dbmd.supportsAlterTableWithDropColumn());
            this.getServletContext().log("Connection DDL&DML " + dbmd.supportsDataDefinitionAndDataManipulationTransactions());
            this.getServletContext().log("Connection CatalogsIn DML " + dbmd.supportsCatalogsInDataManipulation());
            this.getServletContext().log("Connection Schema In DML " + dbmd.supportsSchemasInDataManipulation());
        }
        catch (Exception e) {
            out.println("<p><b>" + e + "</b></p>");
        }
        out.println("</body></html>");
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        this.getServletContext().log("StatusInfo.destroy");
    }
}

