/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.session;

import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.sql.RowSet;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MQuery;
import org.compiere.model.MSequence;
import org.compiere.model.MTask;
import org.compiere.model.MUser;
import org.compiere.model.POInfo;
import org.compiere.model.POInfoColumn;
import org.compiere.model.PaymentProcessor;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CStatement;
import org.compiere.util.CStatementVO;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflow;

public class ServerBean
implements SessionBean {
    private SessionContext m_Context;
    private static CLogger log = CLogger.getCLogger(ServerBean.class);
    private static int s_no = 0;
    private int m_no = 0;
    private int m_windowCount = 0;
    private int m_postCount = 0;
    private int m_processCount = 0;
    private int m_workflowCount = 0;
    private int m_paymentCount = 0;
    private int m_nextSeqCount = 0;
    private int m_stmt_rowSetCount = 0;
    private int m_stmt_updateCount = 0;
    private int m_cacheResetCount = 0;
    private int m_updateLOBCount = 0;

    public GridWindowVO getWindowVO(Properties ctx, int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        log.info("getWindowVO[" + this.m_no + "] Window=" + AD_Window_ID);
        GridWindowVO vo = GridWindowVO.create(ctx, WindowNo, AD_Window_ID, AD_Menu_ID);
        ++this.m_windowCount;
        return vo;
    }

    public String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        log.info("[" + this.m_no + "] Table=" + AD_Table_ID + ", Record=" + Record_ID);
        ++this.m_postCount;
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
        return Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, trxName);
    }

    public RowSet pstmt_getRowSet(CStatementVO info) throws NotSerializableException {
        log.finer("[" + this.m_no + "]");
        ++this.m_stmt_rowSetCount;
        CPreparedStatement pstmt = new CPreparedStatement(info);
        return pstmt.remote_getRowSet();
    }

    public RowSet stmt_getRowSet(CStatementVO info) {
        log.finer("[" + this.m_no + "]");
        ++this.m_stmt_rowSetCount;
        CStatement stmt = new CStatement(info);
        return stmt.remote_getRowSet();
    }

    public int stmt_executeUpdate(CStatementVO info) {
        log.finer("[" + this.m_no + "]");
        ++this.m_stmt_updateCount;
        if (info.getParameterCount() == 0) {
            CStatement stmt = new CStatement(info);
            return stmt.remote_executeUpdate();
        }
        CPreparedStatement pstmt = new CPreparedStatement(info);
        return pstmt.remote_executeUpdate();
    }

    public int getNextID(int AD_Client_ID, String TableName, String trxName) {
        int retValue = MSequence.getNextID(AD_Client_ID, TableName, trxName);
        log.finer("[" + this.m_no + "] " + TableName + " = " + retValue);
        ++this.m_nextSeqCount;
        return retValue;
    }

    public String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        ++this.m_nextSeqCount;
        String dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName);
        if (dn == null) {
            dn = MSequence.getDocumentNo(AD_Client_ID, TableName, trxName);
        }
        return dn;
    }

    public String getDocumentNo(int C_DocType_ID, String trxName) {
        ++this.m_nextSeqCount;
        String dn = MSequence.getDocumentNo(C_DocType_ID, trxName);
        if (dn == null) {
            dn = MSequence.getDocumentNo(C_DocType_ID, trxName);
        }
        return dn;
    }

    public ProcessInfo process(Properties ctx, ProcessInfo pi) {
        String className = pi.getClassName();
        log.info(className + " - " + pi);
        ++this.m_processCount;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            log.log(Level.WARNING, className, ex);
            pi.setSummary("ClassNotFound", true);
            return pi;
        }
        SvrProcess process = null;
        try {
            process = (SvrProcess)clazz.newInstance();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Instance for " + className, ex);
            pi.setSummary("InstanceError", true);
            return pi;
        }
        Trx trx = Trx.get(Trx.createTrxName("ServerPrc"), true);
        try {
            boolean ok = process.startProcess(ctx, pi, trx);
            pi = process.getProcessInfo();
            trx.commit();
            trx.close();
        }
        catch (Exception ex1) {
            trx.rollback();
            trx.close();
            pi.setSummary("ProcessError", true);
            return pi;
        }
        return pi;
    }

    public ProcessInfo workflow(Properties ctx, ProcessInfo pi, int AD_Workflow_ID) {
        log.info("[" + this.m_no + "] " + AD_Workflow_ID);
        ++this.m_workflowCount;
        MWorkflow wf = MWorkflow.get(ctx, AD_Workflow_ID);
        MWFProcess wfProcess = null;
        wfProcess = pi.isBatch() ? wf.start(pi) : wf.startWait(pi);
        log.fine(pi.toString());
        return pi;
    }

    public boolean paymentOnline(Properties ctx, int C_Payment_ID, int C_PaymentProcessor_ID, String trxName) {
        MPayment payment = new MPayment(ctx, C_Payment_ID, trxName);
        MPaymentProcessor mpp = new MPaymentProcessor(ctx, C_PaymentProcessor_ID, null);
        log.info("[" + this.m_no + "] " + payment + " - " + mpp);
        ++this.m_paymentCount;
        boolean approved = false;
        try {
            PaymentProcessor pp = PaymentProcessor.create(mpp, payment);
            if (pp == null) {
                payment.setErrorMessage("No Payment Processor");
            } else {
                approved = pp.processCC();
                if (approved) {
                    payment.setErrorMessage(null);
                } else {
                    payment.setErrorMessage("From " + payment.getCreditCardName() + ": " + payment.getR_RespMsg());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            payment.setErrorMessage("Payment Processor Error");
        }
        payment.save();
        return approved;
    }

    public EMail createEMail(Properties ctx, int AD_Client_ID, String to, String subject, String message) {
        MClient client = MClient.get(ctx, AD_Client_ID);
        return client.createEMail(to, subject, message);
    }

    public EMail createEMail(Properties ctx, int AD_Client_ID, int AD_User_ID, String to, String subject, String message) {
        MClient client = MClient.get(ctx, AD_Client_ID);
        MUser from = new MUser(ctx, AD_User_ID, null);
        return client.createEMail(from, to, subject, message);
    }

    public String executeTask(int AD_Task_ID) {
        MTask task = new MTask(Env.getCtx(), AD_Task_ID, null);
        return task.execute();
    }

    public int cacheReset(String tableName, int Record_ID) {
        log.config(tableName + " - " + Record_ID);
        ++this.m_cacheResetCount;
        return CacheMgt.get().reset(tableName, Record_ID);
    }

    public boolean updateLOB(String sql, int displayType, Object value) {
        if (sql == null || value == null) {
            log.fine("No sql or data");
            return false;
        }
        log.fine(sql);
        ++this.m_updateLOBCount;
        boolean success = true;
        Connection con = DB.createConnection(false, 2);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(sql);
            if (displayType == 36) {
                pstmt.setString(1, (String)value);
            } else {
                pstmt.setBytes(1, (byte[])value);
            }
            int no = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.FINE, sql, e);
            success = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (success) {
            try {
                con.commit();
                con.close();
                con = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "commit", e);
                success = false;
            }
        }
        if (!success) {
            log.severe("rollback");
            try {
                con.rollback();
                con.close();
                con = null;
            }
            catch (Exception ee) {
                log.log(Level.SEVERE, "rollback", ee);
            }
        }
        try {
            if (con != null) {
                con.close();
            }
            con = null;
        }
        catch (Exception e) {
            con = null;
        }
        return success;
    }

    public String getStatus() {
        StringBuffer sb = new StringBuffer("ServerBean[");
        sb.append(this.m_no).append("-Window=").append(this.m_windowCount).append(",Post=").append(this.m_postCount).append(",Process=").append(this.m_processCount).append(",NextSeq=").append(this.m_nextSeqCount).append(",Workflow=").append(this.m_workflowCount).append(",Payment=").append(this.m_paymentCount).append(",RowSet=").append(this.m_stmt_rowSetCount).append(",Update=").append(this.m_stmt_updateCount).append(",CacheReset=").append(this.m_cacheResetCount).append(",UpdateLob=").append(this.m_updateLOBCount).append("]");
        return sb.toString();
    }

    public String toString() {
        return this.getStatus();
    }

    public void ejbCreate() throws EJBException, CreateException {
        this.m_no = ++s_no;
        try {
            Adempiere.startup(false);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "ejbCreate", ex);
        }
        log.info("#" + this.getStatus());
    }

    public void setSessionContext(SessionContext aContext) throws EJBException {
        this.m_Context = aContext;
    }

    public void ejbActivate() throws EJBException {
        if (log == null) {
            log = CLogger.getCLogger(this.getClass());
        }
        log.info("ejbActivate " + this.getStatus());
    }

    public void ejbPassivate() throws EJBException {
        log.info("ejbPassivate " + this.getStatus());
    }

    public void ejbRemove() throws EJBException {
        log.info("ejbRemove " + this.getStatus());
    }

    protected static void dumpSVUID(Class clazz) {
        String s = clazz.getName() + " ==\nstatic final long serialVersionUID = " + ObjectStreamClass.lookup(clazz).getSerialVersionUID() + "L;\n";
        System.out.println(s);
    }

    public static void main(String[] args) {
        ServerBean.dumpSVUID(ProcessInfo.class);
        ServerBean.dumpSVUID(CStatementVO.class);
        ServerBean.dumpSVUID(MQuery.class);
        ServerBean.dumpSVUID(POInfo.class);
        ServerBean.dumpSVUID(POInfoColumn.class);
        ServerBean.dumpSVUID(GridWindowVO.class);
        ServerBean.dumpSVUID(GridTabVO.class);
        ServerBean.dumpSVUID(GridFieldVO.class);
        ServerBean.dumpSVUID(MLookupInfo.class);
    }
}

