/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAttachment;
import org.compiere.model.MNote;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.server.AdempiereServer;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class Scheduler
extends AdempiereServer {
    private MScheduler m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private Trx m_trx = null;

    public Scheduler(MScheduler model) {
        super(model, 240);
        this.m_model = model;
    }

    protected void doWork() {
        this.m_summary = new StringBuffer(this.m_model.toString()).append(" - ");
        MProcess process = this.m_model.getProcess();
        try {
            this.m_trx = Trx.get(Trx.createTrxName("Scheduler"), true);
            if (process.isReport()) {
                this.m_summary.append(this.runReport(process));
            } else {
                this.m_summary.append(this.runProcess(process));
            }
            this.m_trx.commit();
        }
        catch (Exception e) {
            if (this.m_trx != null) {
                this.m_trx.rollback();
            }
            this.log.log(Level.WARNING, process.toString(), e);
            this.m_summary.append(e.toString());
        }
        if (this.m_trx != null) {
            this.m_trx.close();
        }
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    private String runReport(MProcess process) throws Exception {
        this.log.info(process.toString());
        if (!process.isReport() || process.getAD_ReportView_ID() == 0) {
            return "Not a Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName();
        }
        int AD_Table_ID = 0;
        int Record_ID = 0;
        MPInstance pInstance = new MPInstance(process, Record_ID);
        this.fillParameter(pInstance);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(this.m_model.getUpdatedBy());
        pi.setAD_Client_ID(this.m_model.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        if (!process.processIt(pi, this.m_trx) && pi.getClassName() != null) {
            return "Process failed: (" + pi.getClassName() + ") " + pi.getSummary();
        }
        ReportEngine re = ReportEngine.get(this.getCtx(), pi);
        if (re == null) {
            return "Cannot create Report AD_Process_ID=" + process.getAD_Process_ID() + " - " + process.getName();
        }
        File report = re.getPDF();
        int AD_Message_ID = 884;
        Integer[] userIDs = this.m_model.getRecipientAD_User_IDs();
        for (int i = 0; i < userIDs.length; ++i) {
            MNote note = new MNote(this.getCtx(), AD_Message_ID, (int)userIDs[i], this.m_trx.getTrxName());
            note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
            note.setTextMsg(this.m_model.getName());
            note.setDescription(this.m_model.getDescription());
            note.setRecord(AD_Table_ID, Record_ID);
            note.save();
            MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), this.m_trx.getTrxName());
            attachment.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
            attachment.addEntry(report);
            attachment.setTextMsg(this.m_model.getName());
            attachment.save();
        }
        return pi.getSummary();
    }

    private String runProcess(MProcess process) throws Exception {
        this.log.info(process.toString());
        int AD_Table_ID = 0;
        int Record_ID = 0;
        MPInstance pInstance = new MPInstance(process, Record_ID);
        this.fillParameter(pInstance);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(this.m_model.getUpdatedBy());
        pi.setAD_Client_ID(this.m_model.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        process.processIt(pi, this.m_trx);
        return pi.getSummary();
    }

    private void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = this.m_model.getParameters(false);
        MPInstancePara[] iParams = pInstance.getParameters();
        block2: for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            for (int np = 0; np < sParams.length; ++np) {
                MSchedulerPara sPara = sParams[np];
                if (!iPara.getParameterName().equals(sPara.getColumnName())) continue;
                String variable = sPara.getParameterDefault();
                this.log.fine(sPara.getColumnName() + " = " + variable);
                String value = variable;
                if (variable == null || variable != null && variable.length() == 0) {
                    value = null;
                } else if (variable.indexOf("@") != -1) {
                    int index = variable.indexOf("@");
                    String columnName = variable.substring(index + 1);
                    if ((index = columnName.indexOf("@")) == -1) {
                        this.log.warning(sPara.getColumnName() + " - cannot evaluate=" + variable);
                        continue block2;
                    }
                    columnName = columnName.substring(0, index);
                    String env = Env.getContext(this.getCtx(), columnName);
                    if (env.length() == 0) {
                        this.log.warning(sPara.getColumnName() + " - not in environment =" + columnName + "(" + variable + ")");
                        continue block2;
                    }
                    value = env;
                }
                if (value == null) {
                    this.log.fine(sPara.getColumnName() + " - empty");
                    continue block2;
                }
                try {
                    if (DisplayType.isNumeric(sPara.getDisplayType()) || DisplayType.isID(sPara.getDisplayType())) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + bd + "=)");
                    } else if (DisplayType.isDate(sPara.getDisplayType())) {
                        Timestamp ts = null;
                        ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        iPara.setP_Date(ts);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + ts + "=)");
                    } else {
                        iPara.setP_String(value.toString());
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (iPara.save()) continue block2;
                    this.log.warning("Not Saved - " + sPara.getColumnName());
                }
                catch (Exception e) {
                    this.log.warning(sPara.getColumnName() + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
                continue block2;
            }
        }
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

