/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class AcctProcessor
extends AdempiereServer {
    private MAcctProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;
    private MAcctSchema[] m_ass = null;

    public AcctProcessor(MAcctProcessor model) {
        super(model, 30);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.m_ass = this.m_model.getC_AcctSchema_ID() == 0 ? MAcctSchema.getClientAcctSchema(this.getCtx(), this.m_model.getAD_Client_ID()) : new MAcctSchema[]{new MAcctSchema(this.getCtx(), this.m_model.getC_AcctSchema_ID(), null)};
        this.postSession();
        MCost.create(this.m_client);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAcctProcessorLog pLog = new MAcctProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    private void postSession() {
        for (int i = 0; i < Doc.documentsTableID.length; ++i) {
            int AD_Table_ID = Doc.documentsTableID[i];
            String TableName = Doc.documentsTableName[i];
            if (this.m_model.getAD_Table_ID() != 0 && this.m_model.getAD_Table_ID() != AD_Table_ID) continue;
            StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=?").append(" AND Processed='Y' AND Posted='N' AND IsActive='Y'").append(" ORDER BY Created");
            int count = 0;
            int countError = 0;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                ResultSet rs = pstmt.executeQuery();
                while (!this.isInterrupted() && rs.next()) {
                    ++count;
                    boolean ok = true;
                    try {
                        Doc doc = Doc.get(this.m_ass, AD_Table_ID, rs, null);
                        if (doc == null) {
                            this.log.severe(this.getName() + ": No Doc for " + TableName);
                            ok = false;
                        } else {
                            String error = doc.post(false, false);
                            ok = error == null;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, this.getName() + ": " + TableName, e);
                        ok = false;
                    }
                    if (ok) continue;
                    ++countError;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (count > 0) {
                this.m_summary.append(TableName).append("=").append(count);
                if (countError > 0) {
                    this.m_summary.append("(Errors=").append(countError).append(")");
                }
                this.m_summary.append(" - ");
                this.log.finer(this.getName() + ": " + this.m_summary.toString());
                continue;
            }
            this.log.finer(this.getName() + ": " + TableName + " - no work");
        }
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

