/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_ProjectIssue
extends Doc {
    private DocLine m_line = null;
    private MProjectIssue m_issue = null;

    public Doc_ProjectIssue(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MProjectIssue.class, rs, "PJI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.m_issue = (MProjectIssue)this.getPO();
        this.setDateDoc(this.m_issue.getMovementDate());
        this.setDateAcct(this.m_issue.getMovementDate());
        this.m_line = new DocLine(this.m_issue, this);
        this.m_line.setQty(this.m_issue.getMovementQty(), true);
        if (this.m_line.getM_Product_ID() == 0) {
            this.log.warning(this.m_line.toString() + " - No Product");
        }
        this.log.fine(this.m_line.toString());
        return null;
    }

    @Override
    public String getDocumentNo() {
        MProject p = this.m_issue.getParent();
        if (p != null) {
            return p.getValue() + " #" + this.m_issue.getLine();
        }
        return "(" + this.m_issue.get_ID() + ")";
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        MProject project = new MProject(this.getCtx(), this.m_issue.getC_Project_ID(), null);
        String ProjectCategory = project.getProjectCategory();
        MProduct product = MProduct.get(this.getCtx(), this.m_issue.getM_Product_ID());
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal cost = null;
        if (this.m_issue.getM_InOutLine_ID() != 0) {
            cost = this.getPOCost(as);
        } else if (this.m_issue.getS_TimeExpenseLine_ID() != 0) {
            cost = this.getLaborCost(as);
        }
        if (cost == null) {
            cost = this.m_line.getProductCosts(as, this.getAD_Org_ID(), false);
        }
        int acctType = 62;
        if ("A".equals(ProjectCategory)) {
            acctType = 61;
        }
        dr = fact.createLine(this.m_line, this.getAccount(acctType, as), as.getC_Currency_ID(), cost, null);
        dr.setQty(this.m_line.getQty().negate());
        acctType = 3;
        if (product.isService()) {
            acctType = 2;
        }
        cr = fact.createLine(this.m_line, this.m_line.getAccount(acctType, as), as.getC_Currency_ID(), null, cost);
        cr.setM_Locator_ID(this.m_line.getM_Locator_ID());
        cr.setLocationFromLocator(this.m_line.getM_Locator_ID(), true);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private BigDecimal getPOCost(MAcctSchema as) {
        BigDecimal retValue = null;
        String sql = "SELECT currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateOrdered, o.C_ConversionType_ID, ?, ?) FROM C_OrderLine ol INNER JOIN M_InOutLine iol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID) INNER JOIN C_Order o ON (o.C_Order_ID=ol.C_Order_ID) WHERE iol.M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, as.getC_Currency_ID());
            pstmt.setInt(2, this.getAD_Client_ID());
            pstmt.setInt(3, this.getAD_Org_ID());
            pstmt.setInt(4, this.m_issue.getM_InOutLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
                this.log.fine("POCost = " + retValue);
            } else {
                this.log.warning("Not found for M_InOutLine_ID=" + this.m_issue.getM_InOutLine_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    private BigDecimal getLaborCost(MAcctSchema as) {
        BigDecimal retValue = null;
        return retValue;
    }
}

