/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Inventory
extends Doc {
    public Doc_Inventory(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInventory.class, rs, "MMI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInventory inventory = (MInventory)this.getPO();
        this.setDateDoc(inventory.getMovementDate());
        this.setDateAcct(inventory.getMovementDate());
        this.p_lines = this.loadLines(inventory);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInventory inventory) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInventoryLine[] lines = inventory.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInventoryLine line = lines[i];
            if (line.getQtyBook().compareTo(line.getQtyCount()) == 0 && line.getQtyInternalUse().signum() == 0) continue;
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyInternalUse();
            if (Qty.signum() != 0) {
                Qty = Qty.negate();
            } else {
                BigDecimal QtyBook = line.getQtyBook();
                BigDecimal QtyCount = line.getQtyCount();
                Qty = QtyCount.subtract(QtyBook);
            }
            docLine.setQty(Qty, false);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
            if (costs == null || costs.signum() == 0) {
                this.p_Error = "No Costs for " + line.getProduct().getName();
                return null;
            }
            dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
            if (dr == null) continue;
            dr.setM_Locator_ID(line.getM_Locator_ID());
            MAccount invDiff = line.getChargeAccount(as, costs.negate());
            if (invDiff == null) {
                invDiff = this.getAccount(50, as);
            }
            if ((cr = fact.createLine(line, invDiff, as.getC_Currency_ID(), costs.negate())) == null) continue;
            cr.setM_Locator_ID(line.getM_Locator_ID());
            cr.setQty(line.getQty().negate());
            if (line.getC_Charge_ID() != 0) {
                cr.setAD_Org_ID(line.getAD_Org_ID());
            }
            MCostDetail.createInventory(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), this.getTrxName());
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

