/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.a.SqlException;
import com.ibm.db2.jcc.a.ec;
import com.ibm.db2.jcc.a.o;
import com.ibm.db2.jcc.a.rd;
import com.ibm.db2.jcc.a.yc;
import com.ibm.db2.jcc.c.b;
import com.ibm.db2.jcc.c.i;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.t2zos.T2zosConnection;
import com.ibm.db2.jcc.uw.UWConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class DB2Driver
implements Driver {
    private transient int traceFileSuffixIndex_ = 0;
    private static final int DB2_PROTOCOL = 1;
    private static final int DB2_LEGACY_PROTOCOL = 2;
    private static final int CLOUDSCAPE_REMOTE_PROTOCOL = 3;
    private static final int DEFAULT_CONNECTION_PROTOCOL = 4;
    private static SqlException exceptionsOnLoadDriver__ = null;
    private static DB2Driver registeredDriver__ = null;
    private static ClassLoader myClassLoader = (class$com$ibm$db2$jcc$DB2Driver == null ? (class$com$ibm$db2$jcc$DB2Driver = DB2Driver.class$("com.ibm.db2.jcc.DB2Driver")) : class$com$ibm$db2$jcc$DB2Driver).getClassLoader();
    public static final int jccTestBuild = 1;
    public static final int jccBetaBuild = 2;
    public static final int jccReleaseBuild = 3;
    static /* synthetic */ Class class$com$ibm$db2$jcc$DB2Driver;

    public static ClassLoader getMyClassLoader() {
        return myClassLoader;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        int n2;
        Properties properties2;
        StringTokenizer stringTokenizer;
        int n3;
        if (exceptionsOnLoadDriver__ != null) {
            throw exceptionsOnLoadDriver__;
        }
        if (properties == null) {
            properties = new Properties();
        }
        if ((n3 = DB2Driver.tokenizeProtocol(string, stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true))) == 0) {
            return null;
        }
        String string2 = null;
        if (n3 == 1 || n3 == 3) {
            try {
                string2 = stringTokenizer.nextToken(":/");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SqlException(null, noSuchElementException, "Invalid database url syntax: " + string);
            }
        } else if (n3 == 2) {
            string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken(":/") : null;
        } else if (n3 == 4) {
            string2 = null;
        }
        if (n3 != 4 && string2 != null && string2.equals("/")) {
            int n4;
            Properties properties3;
            if (n3 == 2) {
                throw new SqlException(null, "Deprecated DB2 OS/390 protocol not supported by T4: " + string + "  Use protocol jdbc:db2:");
            }
            if (o.Jb || o.Mb || o.Nb) {
                throw new SqlException(null, "Type-4 connectivity not supported under CICS, IMS, or Java SP environments. Use Type-2 connectivity only.");
            }
            String string3 = DB2Driver.tokenizeServerName(stringTokenizer, string);
            int n5 = DB2Driver.tokenizeOptionalPortNumber(stringTokenizer, string);
            if (n5 == 0) {
                switch (n3) {
                    case 1: {
                        n5 = 446;
                        break;
                    }
                    case 3: {
                        n5 = 1527;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
            }
            String string4 = DB2Driver.tokenizeDatabase(stringTokenizer, string);
            if (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    throw new SqlException(null, "Invalid database url syntax: " + string);
                }
                properties3 = DB2Driver.tokenizeURLProperties(stringTokenizer, string, properties);
            } else {
                properties3 = properties;
            }
            try {
                n4 = DB2BaseDataSource.getTraceLevel(properties3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SqlException(null, numberFormatException, "trouble reading traceLevel connection property");
            }
            ec ec2 = DB2BaseDataSource.computeJccLogWriterForNewConnection(4, DriverManager.getLogWriter(), DB2BaseDataSource.getTraceDirectory(properties3), DB2BaseDataSource.getTraceFile(properties3), DB2BaseDataSource.getTraceFileAppend(properties3), n4, "_driver", this.traceFileSuffixIndex_++);
            b b2 = new b((i)ec2, DriverManager.getLoginTimeout(), string3, n5, string4, properties3);
            return b2;
        }
        String string5 = string2;
        if (T2Configuration.u != null) {
            throw T2Configuration.u;
        }
        if (stringTokenizer.hasMoreTokens()) {
            if (string5 != null && string5.equals(":")) {
                string5 = null;
            } else if (!stringTokenizer.nextToken(":").equals(":")) {
                throw new SqlException(null, "Invalid database url syntax: " + string);
            }
            properties2 = DB2Driver.tokenizeURLProperties(stringTokenizer, string, properties);
        } else {
            properties2 = (Properties)((Hashtable)properties).clone();
        }
        try {
            n2 = DB2BaseDataSource.getTraceLevel(properties2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(null, numberFormatException, "trouble reading traceLevel connection property");
        }
        ec ec3 = DB2BaseDataSource.computeJccLogWriterForNewConnection(2, DriverManager.getLogWriter(), DB2BaseDataSource.getTraceDirectory(properties2), DB2BaseDataSource.getTraceFile(properties2), DB2BaseDataSource.getTraceFileAppend(properties2), n2, "_driver", this.traceFileSuffixIndex_++);
        switch (T2Configuration.a()) {
            case 1: {
                return T2zosConnection.a(ec3, string5, properties2, n3 == 4);
            }
            case 2: {
                return new UWConnection((i)ec3, DriverManager.getLoginTimeout(), string5, properties2, this);
            }
        }
        throw new SqlException(ec3, "Unrecognized type 2 driver platform for IBM DB2 JDBC Universal Driver Architecture");
    }

    public boolean acceptsURL(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true);
        int n2 = DB2Driver.tokenizeProtocol(string, stringTokenizer);
        return n2 != 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfoArray[0].description = yc.a("7");
        driverPropertyInfoArray[1].description = yc.a("8");
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1].required = false;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 7;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public int getJCCBuildNumber() {
        return this.getJccBuildNumber();
    }

    public int getJccBuildNumber() {
        return 58;
    }

    public int getJCCBuildCertification() {
        return this.getJccBuildCertification();
    }

    public int getJccBuildCertification() {
        return 3;
    }

    public String[] getJCCCompatibleJREVersions() {
        return this.getJccCompatibleJREVersions();
    }

    public String[] getJccCompatibleJREVersions() {
        return o.cb;
    }

    private static int tokenizeProtocol(String string, StringTokenizer stringTokenizer) throws SqlException {
        if (string == null) {
            return 0;
        }
        if (stringTokenizer == null) {
            return 0;
        }
        try {
            String string2 = stringTokenizer.nextToken(":");
            if (!string2.equals("jdbc")) {
                return 0;
            }
            if (!stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            String string3 = stringTokenizer.nextToken(":");
            int n2 = 0;
            if (string3.equals("db2")) {
                n2 = 1;
            } else if (string3.equals("db2os390") || string3.equals("db2os390sqlj")) {
                n2 = 2;
            } else if (string3.equals("db2j") || string3.equals("derby")) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    return 0;
                }
                if (!stringTokenizer.nextToken(":").equals("net")) {
                    return 0;
                }
                n2 = 3;
            } else if (string3.equals("default")) {
                if (!stringTokenizer.nextToken(":").equals(":")) {
                    return 0;
                }
                if (!stringTokenizer.nextToken(":").equals("connection")) {
                    return 0;
                }
                n2 = 4;
            } else {
                return 0;
            }
            if (n2 != 4 && !stringTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            return n2;
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            if (!stringTokenizer.nextToken("/").equals("/")) {
                throw new SqlException(null, "Invalid database url syntax: " + string);
            }
            return stringTokenizer.nextToken("/:");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            String string2 = stringTokenizer.nextToken(":/");
            if (string2.equals(":")) {
                String string3 = stringTokenizer.nextToken("/");
                if (!stringTokenizer.nextToken("/").equals("/")) {
                    throw new SqlException(null, "Invalid database url syntax: " + string);
                }
                return Integer.parseInt(string3);
            }
            if (string2.equals("/")) {
                return 0;
            }
            throw new SqlException(null, "Invalid database url syntax: " + string);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    private static String tokenizeDatabase(StringTokenizer stringTokenizer, String string) throws SqlException {
        try {
            String string2 = stringTokenizer.nextToken(":\"");
            if (string2.equals("\"")) {
                string2 = stringTokenizer.nextToken("\"");
                String string3 = stringTokenizer.nextToken("\"");
                if (!string3.equals("\"")) {
                    throw new SqlException(null, "Invalid database url syntax: " + string);
                }
            }
            return string2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
    }

    private static Properties tokenizeURLProperties(StringTokenizer stringTokenizer, String string, Properties properties) throws SqlException {
        Properties properties2 = (Properties)((Hashtable)properties).clone();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken("=");
                if (!stringTokenizer.nextToken("=").equals("=")) {
                    throw new SqlException(null, "Invalid database url syntax: " + string);
                }
                String string3 = stringTokenizer.nextToken(";");
                if (!stringTokenizer.nextToken(";").equals(";")) {
                    throw new SqlException(null, "Invalid database url syntax: " + string + "A semicolon is needed after property value " + string3);
                }
                if (properties.getProperty(string2) != null) {
                    throw new SqlException(null, "java.util.Properties object passed to java.sql.Driver.connect() cannot be overriden by URL: " + string);
                }
                properties2.setProperty(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, noSuchElementException, "Invalid database url syntax: " + string);
        }
        return properties2;
    }

    protected void deregisterDriver() {
        try {
            if (registeredDriver__ != null) {
                DriverManager.deregisterDriver(registeredDriver__);
                registeredDriver__ = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (o.Gb != null) {
            exceptionsOnLoadDriver__ = rd.a(o.Gb, exceptionsOnLoadDriver__);
        }
        try {
            registeredDriver__ = new DB2Driver();
            DriverManager.registerDriver(registeredDriver__);
        }
        catch (SQLException sQLException) {
            exceptionsOnLoadDriver__ = new SqlException(null, "Error occurred while trying to register Jcc driver with JDBC 1 Driver Manager");
            exceptionsOnLoadDriver__.setNextException(sQLException);
        }
    }
}

