/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.util.Arrays;

public class Spline {
    private double[] xx;
    private double[] yy;
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public Spline(double[] dArray, double[] dArray2) {
        this.setValues(dArray, dArray2);
    }

    public void setValues(double[] dArray, double[] dArray2) {
        this.xx = dArray;
        this.yy = dArray2;
        if (dArray.length > 1) {
            this.calculateCoefficients();
        }
    }

    public double getValue(double d2) {
        if (this.xx.length == 0) {
            return Double.NaN;
        }
        if (this.xx.length == 1) {
            if (this.xx[0] == d2) {
                return this.yy[0];
            }
            return Double.NaN;
        }
        int n = Arrays.binarySearch(this.xx, d2);
        if (n > 0) {
            return this.yy[n];
        }
        if ((n = -(n + 1) - 1) < 0) {
            return this.yy[0];
        }
        return this.a[n] + this.b[n] * (d2 - this.xx[n]) + this.c[n] * Math.pow(d2 - this.xx[n], 2.0) + this.d[n] * Math.pow(d2 - this.xx[n], 3.0);
    }

    public double getDx(double d2) {
        if (this.xx.length == 0 || this.xx.length == 1) {
            return 0.0;
        }
        int n = Arrays.binarySearch(this.xx, d2);
        if (n < 0) {
            n = -(n + 1) - 1;
        }
        return this.b[n] + 2.0 * this.c[n] * (d2 - this.xx[n]) + 3.0 * this.d[n] * Math.pow(d2 - this.xx[n], 2.0);
    }

    private void calculateCoefficients() {
        int n;
        int n2 = this.yy.length;
        this.a = new double[n2];
        this.b = new double[n2];
        this.c = new double[n2];
        this.d = new double[n2];
        if (n2 == 2) {
            this.a[0] = this.yy[0];
            this.b[0] = this.yy[1] - this.yy[0];
            return;
        }
        double[] dArray = new double[n2 - 1];
        for (int j = 0; j < n2 - 1; ++j) {
            this.a[j] = this.yy[j];
            dArray[j] = this.xx[j + 1] - this.xx[j];
        }
        this.a[n2 - 1] = this.yy[n2 - 1];
        double[][] dArray2 = new double[n2 - 2][n2 - 2];
        double[] dArray3 = new double[n2 - 2];
        for (n = 0; n < n2 - 2; ++n) {
            dArray3[n] = 3.0 * ((this.yy[n + 2] - this.yy[n + 1]) / dArray[n + 1] - (this.yy[n + 1] - this.yy[n]) / dArray[n]);
            dArray2[n][n] = 2.0 * (dArray[n] + dArray[n + 1]);
            if (n > 0) {
                dArray2[n][n - 1] = dArray[n];
            }
            if (n >= n2 - 3) continue;
            dArray2[n][n + 1] = dArray[n + 1];
        }
        this.solve(dArray2, dArray3);
        for (n = 0; n < n2 - 2; ++n) {
            this.c[n + 1] = dArray3[n];
            this.b[n] = (this.a[n + 1] - this.a[n]) / dArray[n] - (2.0 * this.c[n] + this.c[n + 1]) / 3.0 * dArray[n];
            this.d[n] = (this.c[n + 1] - this.c[n]) / (3.0 * dArray[n]);
        }
        this.b[n2 - 2] = (this.a[n2 - 1] - this.a[n2 - 2]) / dArray[n2 - 2] - (2.0 * this.c[n2 - 2] + this.c[n2 - 1]) / 3.0 * dArray[n2 - 2];
        this.d[n2 - 2] = (this.c[n2 - 1] - this.c[n2 - 2]) / (3.0 * dArray[n2 - 2]);
    }

    public void solve(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length;
        for (n = 1; n < n2; ++n) {
            dArray[n][n - 1] = dArray[n][n - 1] / dArray[n - 1][n - 1];
            dArray[n][n] = dArray[n][n] - dArray[n - 1][n] * dArray[n][n - 1];
            dArray2[n] = dArray2[n] - dArray[n][n - 1] * dArray2[n - 1];
        }
        dArray2[n2 - 1] = dArray2[n2 - 1] / dArray[n2 - 1][n2 - 1];
        for (n = dArray2.length - 2; n >= 0; --n) {
            dArray2[n] = (dArray2[n] - dArray[n][n + 1] * dArray2[n + 1]) / dArray[n][n];
        }
    }
}

