/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient boolean isDoubleBuffered = false;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = Color.black;
    protected transient Color highlightColor = Color.black;
    protected transient Color lockedHandleColor = Color.black;

    public VertexRenderer() {
        this.defaultForeground = UIManager.getColor("Tree.textForeground");
        this.defaultBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        this.gridColor = jGraph.getGridColor();
        this.highlightColor = jGraph.getHighlightColor();
        this.lockedHandleColor = jGraph.getLockedHandleColor();
        this.isDoubleBuffered = jGraph.isDoubleBuffered();
        if (cellView instanceof VertexView) {
            this.view = (VertexView)cellView;
            this.setComponentOrientation(jGraph.getComponentOrientation());
            if (jGraph.getEditingCell() != cellView.getCell()) {
                String string = jGraph.convertValueToString(cellView);
                if (string != null) {
                    this.setText(string.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.hasFocus = bl2;
            this.childrenSelected = jGraph.getSelectionModel().isChildrenSelected(cellView.getCell());
            this.selected = bl;
            this.preview = bl3;
            if (this.view.isLeaf() || GraphConstants.isGroupOpaque(cellView.getAllAttributes())) {
                this.installAttributes(cellView);
            } else {
                this.resetAttributes();
            }
            return this;
        }
        return null;
    }

    protected void resetAttributes() {
        this.setText(null);
        this.setBorder(null);
        this.setOpaque(false);
        this.setGradientColor(null);
        this.setIcon(null);
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        AttributeMap attributeMap = cellView.getAllAttributes();
        this.setIcon(GraphConstants.getIcon(attributeMap));
        this.setOpaque(GraphConstants.isOpaque(attributeMap));
        this.setBorder(GraphConstants.getBorder(attributeMap));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(attributeMap));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(attributeMap));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(attributeMap));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(attributeMap));
        this.bordercolor = GraphConstants.getBorderColor(attributeMap);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(attributeMap)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = GraphConstants.getForeground(attributeMap)) != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getGradientColor(attributeMap);
        this.setGradientColor(color2);
        Color color3 = GraphConstants.getBackground(attributeMap);
        this.setBackground(color3 != null ? color3 : this.defaultBackground);
        this.setFont(GraphConstants.getFont(attributeMap));
    }

    public void paint(Graphics graphics) {
        try {
            if (this.gradientColor != null && !this.preview && this.isOpaque()) {
                this.setOpaque(false);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(graphics);
            this.paintSelectionBorder(graphics);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void paintSelectionBorder(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected || this.selected) {
            if (this.childrenSelected) {
                graphics.setColor(this.gridColor);
            } else if (this.hasFocus && this.selected) {
                graphics.setColor(this.lockedHandleColor);
            } else if (this.selected) {
                graphics.setColor(this.highlightColor);
            }
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        graphics2D.setStroke(stroke);
    }

    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d2 + d4 / 2.0;
        double d7 = d3 + d5 / 2.0;
        double d8 = point2D2.getX() - d6;
        double d9 = point2D2.getY() - d7;
        double d10 = Math.atan2(d9, d8);
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = Math.PI;
        double d14 = 1.5707963267948966;
        double d15 = d14 - d10;
        double d16 = Math.atan2(d5, d4);
        if (d10 < -d13 + d16 || d10 > d13 - d16) {
            d11 = d2;
            d12 = d7 - d4 * Math.tan(d10) / 2.0;
        } else if (d10 < -d16) {
            d12 = d3;
            d11 = d6 - d5 * Math.tan(d15) / 2.0;
        } else if (d10 < d16) {
            d11 = d2 + d4;
            d12 = d7 + d4 * Math.tan(d10) / 2.0;
        } else {
            d12 = d3 + d5;
            d11 = d6 + d5 * Math.tan(d15) / 2.0;
        }
        return new Point2D.Double(d11, d12);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object2, Object object3) {
        if (string == "text") {
            super.firePropertyChange(string, object2, object3);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c2, char c3) {
    }

    public void firePropertyChange(String string, short s2, short s3) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f2, float f3) {
    }

    public void firePropertyChange(String string, double d2, double d3) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color color) {
        this.gradientColor = color;
    }
}

