/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;

public class PortView
extends AbstractCellView {
    public static transient int SIZE = 6;
    public static transient PortRenderer renderer = new PortRenderer();
    public static boolean allowPortMagic = true;
    protected transient CellView lastParent;

    public PortView() {
    }

    public PortView(Object object2) {
        super(object2);
    }

    public CellView getParentView() {
        CellView cellView = super.getParentView();
        if (cellView == null) {
            cellView = this.lastParent;
        } else {
            this.lastParent = cellView;
        }
        return cellView;
    }

    public Rectangle2D getBounds() {
        Point2D point2D = this.getLocation();
        double d2 = 0.0;
        double d3 = 0.0;
        if (point2D != null) {
            d2 = point2D.getX();
            d3 = point2D.getY();
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, 0.0, 0.0);
        double_.setFrame(((RectangularShape)double_).getX() - (double)(SIZE / 2), ((RectangularShape)double_).getY() - (double)(SIZE / 2), SIZE, SIZE);
        return double_;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return null;
    }

    public Point2D getLocation() {
        return this.getLocation(null, null);
    }

    public Point2D getLocation(EdgeView edgeView) {
        return this.getLocation(edgeView, null);
    }

    public Point2D getLocation(EdgeView edgeView, Point2D point2D) {
        Port port = null;
        if (this.cell instanceof Port) {
            port = ((Port)this.cell).getAnchor();
        }
        CellView cellView = this.getParentView();
        Point2D point2D2 = null;
        if (cellView != null) {
            PortView portView = null;
            Point2D point2D3 = GraphConstants.getOffset(this.allAttributes);
            if (edgeView == null && point2D3 == null) {
                point2D2 = PortView.getCenterPoint(cellView);
            }
            if (point2D3 != null) {
                double d2 = point2D3.getX();
                double d3 = point2D3.getY();
                Rectangle2D rectangle2D = cellView.getBounds();
                boolean bl = GraphConstants.isAbsoluteX(this.allAttributes);
                boolean bl2 = GraphConstants.isAbsoluteY(this.allAttributes);
                if (!bl) {
                    d2 = d2 * (rectangle2D.getWidth() - 1.0) / 1000.0;
                }
                if (!bl2) {
                    d3 = d3 * (rectangle2D.getHeight() - 1.0) / 1000.0;
                }
                point2D2 = portView != null ? portView.getLocation(edgeView, point2D) : new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                point2D2 = new Point2D.Double(point2D2.getX() + d2, point2D2.getY() + d3);
            } else if (edgeView != null) {
                if (point2D == null) {
                    return PortView.getCenterPoint(cellView);
                }
                point2D2 = cellView.getPerimeterPoint(edgeView, point2D2, point2D);
                if (this.shouldInvokePortMagic(edgeView) && point2D != null) {
                    Rectangle2D rectangle2D = cellView.getBounds();
                    if (point2D.getX() > rectangle2D.getX() && point2D.getX() < rectangle2D.getX() + rectangle2D.getWidth()) {
                        point2D2.setLocation(point2D.getX(), point2D2.getY());
                    } else if (point2D.getY() >= rectangle2D.getY() && point2D.getY() < rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D2.setLocation(point2D2.getX(), point2D.getY());
                    }
                    if (point2D.getY() < rectangle2D.getY()) {
                        point2D2.setLocation(point2D2.getX(), rectangle2D.getY());
                    } else if (point2D.getY() > rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D2.setLocation(point2D2.getX(), rectangle2D.getY() + rectangle2D.getHeight());
                    }
                }
            }
        }
        return point2D2;
    }

    protected boolean shouldInvokePortMagic(EdgeView edgeView) {
        return allowPortMagic && !(this.getParentView() instanceof EdgeView) && edgeView.getPointCount() > 2 && GraphConstants.getLineStyle(edgeView.getAllAttributes()) == 11;
    }
}

