/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.GraphModel;

public class ParentMap
implements Serializable {
    protected ArrayList entries = new ArrayList();
    protected Set changedNodes = new HashSet();
    protected Map childCount = new Hashtable();

    public ParentMap() {
    }

    public ParentMap(Object[] objectArray, Object object2) {
        this.addEntries(objectArray, object2);
    }

    public static ParentMap create(GraphModel graphModel, Object[] objectArray, boolean bl, boolean bl2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int j = 0; j < objectArray.length; ++j) {
            hashSet.add(objectArray[j]);
        }
        ParentMap parentMap = new ParentMap();
        for (int j = 0; j < objectArray.length; ++j) {
            Object object2 = graphModel.getParent(objectArray[j]);
            if (object2 != null && (!bl2 || !bl && hashSet.contains(object2))) {
                parentMap.addEntry(objectArray[j], bl ? null : object2);
            }
            if (!bl) continue;
            while (hashSet.contains(object2)) {
                object2 = graphModel.getParent(object2);
            }
            for (int k = 0; k < graphModel.getChildCount(objectArray[j]); ++k) {
                Object object3 = graphModel.getChild(objectArray[j], k);
                if (hashSet.contains(object3)) continue;
                parentMap.addEntry(object3, object2);
            }
        }
        return parentMap;
    }

    public void addEntry(Object object2, Object object3) {
        if (object2 != null) {
            this.entries.add(new Entry(object2, object3));
            this.changedNodes.add(object2);
            if (object3 != null) {
                this.changedNodes.add(object3);
            }
        }
    }

    public void addEntries(Object[] objectArray, Object object2) {
        for (int j = 0; j < objectArray.length; ++j) {
            this.addEntry(objectArray[j], object2);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public Set getChangedNodes() {
        return this.changedNodes;
    }

    public ParentMap clone(Map map2) {
        ParentMap parentMap = new ParentMap();
        Iterator iterator = this.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Object object2 = map2.get(entry.getChild());
            Object object3 = map2.get(entry.getParent());
            if (object2 == null) {
                object2 = entry.getChild();
            }
            if (object3 == null) {
                object3 = entry.getParent();
            }
            if (object2 == null || object3 == null) continue;
            parentMap.addEntry(object2, object3);
        }
        return parentMap;
    }

    public String toString() {
        String string = super.toString() + "\n";
        Iterator iterator = this.entries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            string = string + " child=" + entry.getChild() + " parent=" + entry.getParent() + "\n";
        }
        return string;
    }

    public class Entry
    implements Serializable {
        protected Object child;
        protected Object parent;

        public Entry(Object object2, Object object3) {
            this.child = object2;
            this.parent = object3;
        }

        public Object getChild() {
            return this.child;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

