/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;

public class GraphTransferHandler
extends TransferHandler {
    protected boolean alwaysReceiveAsCopyAction = false;
    protected Object out;
    protected Object in;
    protected int inCount = 0;

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int j = 0; j < dataFlavorArray.length; ++j) {
            if (dataFlavorArray[j] != GraphTransferable.dataFlavor) continue;
            return true;
        }
        return false;
    }

    public Transferable createTransferableForGraph(JGraph jGraph) {
        return this.createTransferable(jGraph);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        JGraph jGraph;
        if (jComponent instanceof JGraph && !(jGraph = (JGraph)jComponent).isSelectionEmpty()) {
            return this.createTransferable(jGraph, jGraph.getSelectionCells());
        }
        return null;
    }

    protected Transferable createTransferable(JGraph jGraph, Object[] objectArray) {
        Object[] objectArray2 = jGraph.getDescendants(jGraph.order(objectArray));
        ParentMap parentMap = ParentMap.create(jGraph.getModel(), objectArray2, false, true);
        ConnectionSet connectionSet = ConnectionSet.create(jGraph.getModel(), objectArray2, false);
        Map map2 = GraphConstants.createAttributes(objectArray2, jGraph.getGraphLayoutCache());
        Rectangle2D rectangle2D = jGraph.getCellBounds(jGraph.getSelectionCells());
        rectangle2D = new AttributeMap.SerializableRectangle2D(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.out = objectArray2;
        return this.create(jGraph, objectArray2, map2, rectangle2D, connectionSet, parentMap);
    }

    protected GraphTransferable create(JGraph jGraph, Object[] objectArray, Map map2, Rectangle2D rectangle2D, ConnectionSet connectionSet, ParentMap parentMap) {
        return new GraphTransferable(objectArray, map2, rectangle2D, connectionSet, parentMap);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (jComponent instanceof JGraph && transferable instanceof GraphTransferable) {
            JGraph jGraph = (JGraph)jComponent;
            if (n == 2) {
                Object[] objectArray = ((GraphTransferable)transferable).getCells();
                jGraph.getGraphLayoutCache().remove(objectArray);
            }
            jGraph.getUI().updateHandle();
            jGraph.getUI().setInsertionLocation(null);
        }
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            if (jComponent instanceof JGraph) {
                JGraph jGraph = (JGraph)jComponent;
                GraphModel graphModel = jGraph.getModel();
                GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
                if (transferable.isDataFlavorSupported(GraphTransferable.dataFlavor) && jGraph.isEnabled()) {
                    int n;
                    Point point = jGraph.getUI().getInsertionLocation();
                    Object object2 = transferable.getTransferData(GraphTransferable.dataFlavor);
                    GraphTransferable graphTransferable = (GraphTransferable)object2;
                    Object[] objectArray = graphTransferable.getCells();
                    boolean bl = true;
                    for (n = 0; n < objectArray.length && bl; ++n) {
                        bl = bl && graphModel.contains(objectArray[n]);
                    }
                    this.inCount = this.in == objectArray ? ++this.inCount : (bl ? 1 : 0);
                    this.in = objectArray;
                    if (point != null && this.in == this.out && jGraph.getUI().getHandle() != null) {
                        n = jGraph.getUI().getDropAction() == 1 ? 2 : 0;
                        jGraph.getUI().getHandle().mouseReleased(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
                        return false;
                    }
                    Rectangle2D rectangle2D = graphTransferable.getBounds();
                    Hashtable hashtable = graphTransferable.getAttributeMap();
                    ConnectionSet connectionSet = graphTransferable.getConnectionSet();
                    ParentMap parentMap = graphTransferable.getParentMap();
                    if (!bl || point == null || this.alwaysReceiveAsCopyAction || jGraph.getUI().getDropAction() == 1) {
                        double d2 = 0.0;
                        double d3 = 0.0;
                        if (hashtable != null) {
                            if (point != null && rectangle2D != null) {
                                Point2D point2D = jGraph.fromScreen(jGraph.snap((Point2D)point.clone()));
                                d2 = point2D.getX() - rectangle2D.getX();
                                d3 = point2D.getY() - rectangle2D.getY();
                            } else {
                                d2 = (double)this.inCount * jGraph.getGridSize();
                                d3 = (double)this.inCount * jGraph.getGridSize();
                            }
                        }
                        this.handleExternalDrop(jGraph, objectArray, hashtable, connectionSet, parentMap, d2, d3);
                        return jGraph.getUI().getDropAction() == 2 && !bl;
                    }
                    if (point != null) {
                        Point2D point2D = jGraph.fromScreen(jGraph.snap(new Point(point)));
                        if (rectangle2D != null && hashtable != null) {
                            double d4 = point2D.getX() - rectangle2D.getX();
                            double d5 = point2D.getY() - rectangle2D.getY();
                            AttributeMap.translate(hashtable.values(), d4, d5);
                        } else if (rectangle2D == null) {
                            double d6 = 2.0 * jGraph.getGridSize();
                            hashtable = new Hashtable();
                            Hashtable hashtable2 = new Hashtable();
                            for (int j = 0; j < objectArray.length; ++j) {
                                if (!graphModel.isEdge(objectArray[j]) && !graphModel.isPort(objectArray[j])) {
                                    Rectangle2D rectangle2D2 = jGraph.getCellBounds(objectArray[j]);
                                    if (rectangle2D2 == null) {
                                        rectangle2D2 = GraphConstants.getBounds(graphModel.getAttributes(objectArray[j]));
                                    }
                                    if (rectangle2D2 != null) {
                                        rectangle2D2 = (Rectangle2D)rectangle2D2.clone();
                                    }
                                    Hashtable hashtable3 = new Hashtable();
                                    Object object3 = graphModel.getParent(objectArray[j]);
                                    if (rectangle2D2 == null) {
                                        rectangle2D2 = new Rectangle2D.Double(point.getX(), point.getY(), d6 / 2.0, d6);
                                        GraphConstants.setResize(hashtable3, true);
                                        point.setLocation(point.getX() + d6, point.getY() + d6);
                                        jGraph.snap(point);
                                    } else if (object3 == null || !hashtable.keySet().contains(graphModel.getParent(objectArray[j]))) {
                                        CellView cellView = jGraph.getGraphLayoutCache().getMapping(objectArray[j], false);
                                        if (cellView != null && !cellView.isLeaf()) {
                                            double d7 = point.getX() - rectangle2D2.getX();
                                            double d8 = point.getY() - rectangle2D2.getY();
                                            GraphLayoutCache.translateViews(new CellView[]{cellView}, d7, d8);
                                        } else {
                                            rectangle2D2.setFrame(point.getX(), point.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                                        }
                                        point.setLocation(point.getX() + d6, point.getY() + d6);
                                        jGraph.snap(point);
                                    }
                                    GraphConstants.setBounds(hashtable3, rectangle2D2);
                                    hashtable.put(objectArray[j], hashtable3);
                                    continue;
                                }
                                hashtable.put(objectArray[j], hashtable2);
                            }
                        }
                        graphLayoutCache.edit(hashtable, null, null, null);
                    }
                    jGraph.setSelectionCells(DefaultGraphModel.getTopmostCells(graphModel, objectArray));
                    return false;
                }
                return this.importDataImpl(jComponent, transferable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected void handleExternalDrop(JGraph jGraph, Object[] objectArray, Map map2, ConnectionSet connectionSet, ParentMap parentMap, double d2, double d3) {
        Object object2;
        Iterator iterator = connectionSet.connections();
        while (iterator.hasNext()) {
            object2 = (ConnectionSet.Connection)iterator.next();
            if (parentMap.getChangedNodes().contains(((ConnectionSet.Connection)object2).getPort()) || jGraph.getModel().contains(((ConnectionSet.Connection)object2).getPort())) continue;
            iterator.remove();
        }
        object2 = jGraph.cloneCells(objectArray);
        jGraph.getGraphLayoutCache().insertClones(objectArray, (Map)object2, map2, connectionSet, parentMap, d2, d3);
    }

    protected boolean importDataImpl(JComponent jComponent, Transferable transferable) {
        return false;
    }

    public boolean isAlwaysReceiveAsCopyAction() {
        return this.alwaysReceiveAsCopyAction;
    }

    public void setAlwaysReceiveAsCopyAction(boolean bl) {
        this.alwaysReceiveAsCopyAction = bl;
    }
}

