/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

public class GraphLayoutCache
implements CellMapper,
Serializable {
    protected boolean autoSizeOnValueChange = false;
    protected boolean showsExistingConnections = true;
    protected boolean showsChangedConnections = true;
    protected boolean showsInvisibleEditedCells = true;
    protected boolean showsInsertedCells = true;
    protected boolean showsInsertedConnections = true;
    protected boolean hidesExistingConnections = true;
    protected boolean hidesDanglingConnections = false;
    protected boolean remembersCellViews = true;
    protected boolean selectsAllInsertedCells = true;
    protected boolean selectsLocalInsertedCells = true;
    protected boolean movesChildrenOnExpand = true;
    protected boolean movesParentsOnCollapse = true;
    protected boolean resizesParentsOnCollapse = false;
    protected double collapseXScale = 1.0;
    protected double collapseYScale = 1.0;
    protected boolean reconnectsEdgesToVisibleParent = false;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected Map hiddenMapping = new Hashtable();
    protected CellViewFactory factory = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected boolean partial = false;
    protected boolean allAttributesLocal = false;
    protected Set localAttributes = new HashSet();
    static /* synthetic */ Class class$org$jgraph$event$GraphLayoutCacheListener;

    public GraphLayoutCache() {
        this(new DefaultGraphModel(), new DefaultCellViewFactory());
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory) {
        this(graphModel, cellViewFactory, false);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl) {
        this(graphModel, cellViewFactory, null, null, bl);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, CellView[] cellViewArray, CellView[] cellViewArray2, boolean bl) {
        int n;
        this.factory = cellViewFactory;
        this.partial = bl;
        if (cellViewArray != null) {
            this.graphModel = graphModel;
            for (n = 0; n < cellViewArray.length; ++n) {
                if (cellViewArray[n] == null) continue;
                this.putMapping(cellViewArray[n].getCell(), cellViewArray[n]);
                if (!bl) continue;
                this.visibleSet.add(cellViewArray[n].getCell());
            }
            this.insertViews(cellViewArray);
        } else {
            this.setModel(graphModel);
        }
        if (cellViewArray2 != null) {
            for (n = 0; n < cellViewArray2.length; ++n) {
                this.hiddenMapping.put(cellViewArray2[n].getCell(), cellViewArray2[n]);
            }
        }
    }

    public void addGraphLayoutCacheListener(GraphLayoutCacheListener graphLayoutCacheListener) {
        this.listenerList.add(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener, graphLayoutCacheListener);
    }

    public void removeGraphLayoutCacheListener(GraphLayoutCacheListener graphLayoutCacheListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener, graphLayoutCacheListener);
    }

    public void cellViewsChanged(final CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.fireGraphLayoutCacheChanged(this, new GraphLayoutCacheEvent.GraphLayoutCacheChange(){

                public Object[] getInserted() {
                    return null;
                }

                public Object[] getRemoved() {
                    return null;
                }

                public Map getPreviousAttributes() {
                    return null;
                }

                public Object getSource() {
                    return this;
                }

                public Object[] getChanged() {
                    return cellViewArray;
                }

                public Map getAttributes() {
                    return null;
                }

                public Object[] getContext() {
                    return null;
                }
            });
        }
    }

    protected void fireGraphLayoutCacheChanged(Object object2, GraphLayoutCacheEvent.GraphLayoutCacheChange graphLayoutCacheChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphLayoutCacheEvent graphLayoutCacheEvent = null;
        for (int j = objectArray.length - 2; j >= 0; j -= 2) {
            if (objectArray[j] != (class$org$jgraph$event$GraphLayoutCacheListener == null ? GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener") : class$org$jgraph$event$GraphLayoutCacheListener)) continue;
            if (graphLayoutCacheEvent == null) {
                graphLayoutCacheEvent = new GraphLayoutCacheEvent(object2, graphLayoutCacheChange);
            }
            ((GraphLayoutCacheListener)objectArray[j + 1]).graphLayoutCacheChanged(graphLayoutCacheEvent);
        }
    }

    public GraphLayoutCacheListener[] getGraphLayoutCacheListeners() {
        return (GraphLayoutCacheListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener);
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenMapping.clear();
        this.visibleSet.clear();
        this.graphModel = graphModel;
        if (!this.isPartial()) {
            Object[] objectArray = DefaultGraphModel.getRoots(this.getModel());
            CellView[] cellViewArray = this.getMapping(objectArray, true);
            this.insertViews(cellViewArray);
        }
        this.updatePorts();
        this.cellViewsChanged(this.getRoots());
    }

    public CellView[] getCellViews() {
        Collection collection = this.mapping.values();
        CellView[] cellViewArray = new CellView[collection.size()];
        collection.toArray(cellViewArray);
        return cellViewArray;
    }

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = cellViewArray[0].getBounds();
            Rectangle2D rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
            for (int j = 1; j < cellViewArray.length; ++j) {
                rectangle2D = cellViewArray[j].getBounds();
                if (rectangle2D == null) continue;
                if (rectangle2D2 == null) {
                    rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
                    continue;
                }
                Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
            }
            return rectangle2D2;
        }
        return null;
    }

    public Object[] getCells(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CellView[] cellViewArray = this.getCellViews();
        ArrayList<Object> arrayList = new ArrayList<Object>(cellViewArray.length);
        GraphModel graphModel = this.getModel();
        for (int j = 0; j < cellViewArray.length; ++j) {
            Object object2 = cellViewArray[j].getCell();
            boolean bl5 = graphModel.isEdge(object2);
            if (!bl3 && graphModel.isPort(object2) || ((!bl3 && !bl2 || bl5) && (!bl4 || !bl5) || !cellViewArray[j].isLeaf()) && (!bl || cellViewArray[j].isLeaf())) continue;
            arrayList.add(cellViewArray[j].getCell());
        }
        return arrayList.toArray();
    }

    public Map createNestedMap() {
        CellView[] cellViewArray = this.getCellViews();
        Hashtable hashtable = new Hashtable();
        for (int j = 0; j < cellViewArray.length; ++j) {
            hashtable.put(cellViewArray[j].getCell(), new Hashtable((Map)cellViewArray[j].getAllAttributes().clone()));
        }
        return hashtable;
    }

    public CellView[] getHiddenCellViews() {
        Collection collection = this.hiddenMapping.values();
        CellView[] cellViewArray = new CellView[collection.size()];
        collection.toArray(cellViewArray);
        return cellViewArray;
    }

    public synchronized void reload() {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Hashtable hashtable = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CellView cellView = (CellView)hashtable.get(k);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.changeAttributes(cellView.getAttributes());
            if (!this.roots.contains(cellView)) continue;
            arrayList.add(cellView2);
        }
        this.hiddenMapping.clear();
        this.roots = arrayList;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        for (int j = 0; j < cellViewArray.length; ++j) {
            if (!cellViewArray[j].getBounds().intersects(rectangle2D)) continue;
            arrayList.add(cellViewArray[j]);
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public Object[] getVisibleCells(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int j = 0; j < objectArray.length; ++j) {
                if (!this.isVisible(objectArray[j])) continue;
                arrayList.add(objectArray[j]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        List list = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (list != null) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CellView cellView;
                Object e2 = iterator.next();
                if (!this.graphModel.isPort(e2) || (cellView = this.getMapping(e2, false)) == null) continue;
                arrayList.add(cellView);
                cellView.refresh(this.getModel(), this, false);
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            for (int j = 0; j < cellViewArray.length; ++j) {
                this.refresh(cellViewArray[j], bl);
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(this.getModel(), this, bl);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int j = 0; j < cellViewArray.length; ++j) {
                this.refresh(cellViewArray[j], bl);
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            for (int j = 0; j < cellViewArray.length; ++j) {
                this.update(cellViewArray[j]);
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update();
            CellView[] cellViewArray = cellView.getChildViews();
            for (int j = 0; j < cellViewArray.length; ++j) {
                this.update(cellViewArray[j]);
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            for (int j = 0; j < cellViewArray.length; ++j) {
                if (cellViewArray[j] == null) continue;
                this.mapping.put(cellViewArray[j].getCell(), cellViewArray[j]);
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray = graphModelChange.getChanged();
        this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeCells(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        if (this.isPartial()) {
            this.showCellsForChange(graphModelChange);
            this.hideCellsForChange(graphModelChange);
        }
        if (objectArray != null && objectArray.length > 0) {
            for (int j = 0; j < objectArray.length; ++j) {
                CellView cellView = this.getMapping(objectArray[j], false);
                if (cellView == null) continue;
                cellView.refresh(this.getModel(), this, true);
                this.update(cellView);
            }
        }
        this.reloadRoots();
        this.refresh(this.getMapping(this.getContext(graphModelChange), false), false);
        this.updatePorts();
    }

    protected void reloadRoots() {
        Object[] objectArray = DefaultGraphModel.getAll(this.graphModel);
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (int j = 0; j < objectArray.length; ++j) {
            CellView cellView = this.getMapping(objectArray[j], false);
            if (cellView == null) continue;
            cellView.refresh(this.getModel(), this, true);
            if (cellView.getParentView() != null) continue;
            arrayList.add(cellView);
        }
        this.roots = arrayList;
    }

    protected Object[] getContext(GraphModelEvent.GraphModelChange graphModelChange) {
        return graphModelChange.getContext();
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = graphModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int j = 0; j < objectArray.length; ++j) {
                hashSet.add(objectArray[j]);
            }
        }
        if (this.hidesDanglingConnections || this.hidesExistingConnections) {
            Object[] objectArray2 = graphModelChange.getChanged();
            for (int j = 0; j < objectArray2.length; ++j) {
                boolean bl;
                CellView cellView = this.getMapping(objectArray2[j], false);
                if (!(cellView instanceof EdgeView)) continue;
                EdgeView edgeView = (EdgeView)cellView;
                Object object2 = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                Object object3 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                Object object4 = this.graphModel.getSource(objectArray2[j]);
                Object object5 = this.graphModel.getTarget(objectArray2[j]);
                boolean bl2 = bl = this.hidesExistingConnections && (object4 != null && !this.hasVisibleParent(object4, null) || object5 != null && !this.hasVisibleParent(object5, null));
                if ((!this.hidesDanglingConnections || !hashSet.contains(object2) && !hashSet.contains(object3)) && !bl) continue;
                this.setVisibleImpl(new Object[]{objectArray2[j]}, false);
            }
        }
    }

    protected boolean hasVisibleParent(Object object2, Set set) {
        boolean bl = false;
        do {
            bl = set == null || !set.contains(object2) ? this.isVisible(object2) : false;
        } while ((object2 = this.getModel().getParent(object2)) != null && !bl);
        return bl;
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Set set;
        Object object2;
        Object[] objectArray = graphModelChange.getInserted();
        if (objectArray != null && this.showsInsertedConnections) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (this.isVisible(objectArray[j])) continue;
                object2 = this.graphModel.getSource(objectArray[j]);
                Object object3 = this.graphModel.getTarget(objectArray[j]);
                if (object2 == null && object3 == null || !this.isVisible(object2) || !this.isVisible(object3)) continue;
                this.setVisibleImpl(new Object[]{objectArray[j]}, true);
            }
        }
        if (graphModelChange.getConnectionSet() != null && (set = graphModelChange.getConnectionSet().getChangedEdges()) != null && this.showsChangedConnections) {
            object2 = set.toArray();
            for (int j = 0; j < ((Object[])object2).length; ++j) {
                if (this.isVisible(object2[j])) continue;
                Object object4 = this.graphModel.getSource(object2[j]);
                Object object5 = this.graphModel.getTarget(object2[j]);
                if (object4 == null && object5 == null || !this.isVisible(object4) || !this.isVisible(object5) || this.isVisible(object2[j])) continue;
                this.setVisibleImpl(new Object[]{object2[j]}, true);
            }
        }
    }

    public void insertViews(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            for (int j = 0; j < cellViewArray.length; ++j) {
                Object object2;
                if (cellViewArray[j] == null || this.getMapping(cellViewArray[j].getCell(), false) == null) continue;
                CellView cellView = cellViewArray[j].getParentView();
                Object object3 = object2 = cellView != null ? cellView.getCell() : null;
                if (this.graphModel.isPort(cellViewArray[j].getCell()) || object2 != null) continue;
                this.roots.add(cellViewArray[j]);
            }
        }
    }

    public CellView[] removeCells(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                cellViewArray[j] = this.removeMapping(objectArray[j]);
                if (cellViewArray[j] == null) continue;
                cellViewArray[j].removeFromParent();
                this.roots.remove(cellViewArray[j]);
                this.visibleSet.remove(cellViewArray[j].getCell());
            }
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            for (int j = 0; j < cellViewArray.length; ++j) {
                if (cellViewArray[j] == null) continue;
                objectArray[j] = cellViewArray[j].getCell();
            }
            return objectArray;
        }
        return null;
    }

    public CellView getMapping(Object object2, boolean bl) {
        if (object2 == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object2);
        if (cellView == null && bl && this.isVisible(object2)) {
            cellView = (CellView)this.hiddenMapping.get(object2);
            if (cellView != null) {
                this.putMapping(object2, cellView);
                this.hiddenMapping.remove(object2);
            } else {
                cellView = this.factory.createView(this.graphModel, object2);
                this.putMapping(object2, cellView);
                cellView.refresh(this.getModel(), this, true);
                cellView.update();
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                cellViewArray[j] = this.getMapping(objectArray[j], bl);
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object2, CellView cellView) {
        if (object2 != null && cellView != null) {
            this.mapping.put(object2, cellView);
        }
    }

    public CellView removeMapping(Object object2) {
        if (object2 != null) {
            CellView cellView = (CellView)this.mapping.remove(object2);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object2) {
        return !this.isPartial() || this.visibleSet.contains(object2) || object2 == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object2, boolean bl) {
        this.setVisible(new Object[]{object2}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        this.setVisible(objectArray, objectArray2, null);
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2, ConnectionSet connectionSet) {
        GraphLayoutCacheEdit graphLayoutCacheEdit = new GraphLayoutCacheEdit(null, null, objectArray, objectArray2);
        graphLayoutCacheEdit.end();
        this.graphModel.edit(null, connectionSet, null, new UndoableEdit[]{graphLayoutCacheEdit});
    }

    protected Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                Object object2;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int j = 0; j < objectArray.length; ++j) {
                    hashSet.add(objectArray[j]);
                    hashSet.addAll(this.getPorts(objectArray[j]));
                    object2 = this.getParentPorts(this.graphModel.getSource(objectArray[j]));
                    if (object2 != null) {
                        hashSet.addAll((Collection<Object>)object2);
                    }
                    if ((object2 = this.getParentPorts(this.graphModel.getTarget(objectArray[j]))) == null) continue;
                    hashSet.addAll((Collection<Object>)object2);
                }
                if (this.showsExistingConnections) {
                    Set set = DefaultGraphModel.getEdges(this.getModel(), objectArray);
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        Object e2 = object2.next();
                        Object object3 = this.graphModel.getSource(e2);
                        Object object4 = this.graphModel.getTarget(e2);
                        if (!this.isVisible(object3) && !hashSet.contains(object3) || !this.isVisible(object4) && !hashSet.contains(object4)) continue;
                        hashSet.add(e2);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                hashSet.remove(null);
                return hashSet.toArray();
            }
            if (this.hidesExistingConnections) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int j = 0; j < objectArray.length; ++j) {
                    hashSet.addAll(this.getPorts(objectArray[j]));
                    hashSet.add(objectArray[j]);
                }
                Iterator iterator = DefaultGraphModel.getEdges(this.graphModel, objectArray).iterator();
                while (iterator.hasNext()) {
                    Object e3 = iterator.next();
                    Object object5 = this.graphModel.getSource(e3);
                    Object object6 = this.graphModel.getTarget(e3);
                    if ((object5 == null || this.hasVisibleParent(object5, hashSet)) && (object6 == null || this.hasVisibleParent(object6, hashSet))) continue;
                    hashSet.add(e3);
                }
                hashSet.remove(null);
                return hashSet.toArray();
            }
        }
        return objectArray;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if ((objectArray = this.addVisibleDependencies(objectArray, bl)) != null && this.isPartial()) {
            boolean bl2 = false;
            CellView[] cellViewArray = new CellView[objectArray.length];
            if (!bl) {
                cellViewArray = this.removeCells(objectArray);
            }
            for (int j = 0; j < objectArray.length; ++j) {
                if (objectArray[j] == null) continue;
                if (bl) {
                    this.visibleSet.add(objectArray[j]);
                    cellViewArray[j] = this.getMapping(objectArray[j], true);
                    continue;
                }
                if (cellViewArray[j] == null) continue;
                if (this.graphModel.contains(cellViewArray[j].getCell()) && this.remembersCellViews) {
                    this.hiddenMapping.put(cellViewArray[j].getCell(), cellViewArray[j]);
                }
                bl2 = true;
            }
            if (bl) {
                HashSet<CellView> hashSet = new HashSet<CellView>();
                for (int j = 0; j < cellViewArray.length; ++j) {
                    if (cellViewArray[j] == null) continue;
                    CellView cellView = cellViewArray[j];
                    CellView[] cellViewArray2 = AbstractCellView.getDescendantViews(new CellView[]{cellView});
                    for (int k = 0; k < cellViewArray2.length; ++k) {
                        this.roots.remove(cellViewArray2[k]);
                    }
                    cellView.refresh(this.getModel(), this, false);
                    CellView cellView2 = cellView.getParentView();
                    if (cellView2 != null) {
                        hashSet.add(cellView2);
                    }
                    bl2 = true;
                }
                CellView[] cellViewArray3 = new CellView[hashSet.size()];
                hashSet.toArray(cellViewArray3);
                this.refresh(cellViewArray3, true);
            }
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object2) {
        Object object3 = this.graphModel.getParent(object2);
        while (object3 != null) {
            if (this.isVisible(object3)) {
                return null;
            }
            object3 = this.graphModel.getParent(object3);
        }
        object3 = this.graphModel.getParent(object2);
        Collection collection = this.getPorts(object3);
        collection.add(object3);
        return collection;
    }

    protected Collection getPorts(Object object2) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int j = 0; j < this.graphModel.getChildCount(object2); ++j) {
            Object object3 = this.graphModel.getChild(object2, j);
            if (!this.graphModel.isPort(object3)) continue;
            linkedList.add(object3);
        }
        return linkedList;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void valueForCellChanged(Object object2, Object object3) {
        Map map2 = null;
        if (this.isAutoSizeOnValueChange()) {
            CellView cellView = this.getMapping(object2, false);
            if (cellView != null) {
                AttributeMap attributeMap = cellView.getAllAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
                Rectangle2D rectangle2D2 = attributeMap.createRect(rectangle2D.getX(), rectangle2D.getY(), 0.0, 0.0);
                map2 = GraphConstants.createAttributes(new Object[]{object2}, new Object[]{"resize", "bounds"}, new Object[]{Boolean.TRUE, rectangle2D2});
            }
        } else {
            map2 = new Hashtable();
            map2.put(object2, new Hashtable());
        }
        this.augmentNestedMapForValueChange(map2, object2, object3);
        this.edit(map2, null, null, null);
    }

    protected void augmentNestedMapForValueChange(Map map2, Object object2, Object object3) {
        Map map3 = (Map)map2.get(object2);
        if (map3 != null) {
            GraphConstants.setValue(map3, object3);
        }
    }

    public void insert(Object[] objectArray, Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Object object2;
        Object[] objectArray2 = null;
        if (this.isPartial() && this.showsInsertedCells) {
            object2 = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
            object2.removeAll(this.visibleSet);
            if (!object2.isEmpty()) {
                objectArray2 = object2.toArray();
            }
        }
        if ((object2 = this.createLocalEdit(objectArray, map2, objectArray2, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)object2);
        }
        this.graphModel.insert(objectArray, map2, connectionSet, parentMap, undoableEditArray);
    }

    public Object[] insertClones(Object[] objectArray, Map map2, Map map3, ConnectionSet connectionSet, ParentMap parentMap, double d2, double d3) {
        if (objectArray != null) {
            if (connectionSet != null) {
                connectionSet = connectionSet.clone(map2);
            }
            if (parentMap != null) {
                parentMap = parentMap.clone(map2);
            }
            if (map3 != null) {
                map3 = GraphConstants.replaceKeys(map2, map3);
                AttributeMap.translate(map3.values(), d2, d3);
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                objectArray2[j] = map2.get(objectArray[j]);
            }
            this.insert(objectArray2, map3, connectionSet, parentMap, null);
            return objectArray2;
        }
        return null;
    }

    public void insert(Object object2) {
        this.insert(new Object[]{object2});
    }

    public void insertEdge(Object object2, Object object3, Object object4) {
        this.insert(new Object[]{object2}, new Hashtable(), new ConnectionSet(object2, object3, object4), new ParentMap());
    }

    public void insert(Object[] objectArray) {
        this.insert(objectArray, new Hashtable(), new ConnectionSet(), new ParentMap());
    }

    public void insert(Object[] objectArray, Map hashtable, ConnectionSet connectionSet, ParentMap parentMap) {
        if (objectArray != null) {
            if (hashtable == null) {
                hashtable = new Hashtable<Object, Object>();
            }
            if (connectionSet == null) {
                connectionSet = new ConnectionSet();
            }
            if (parentMap == null) {
                parentMap = new ParentMap();
            }
            for (int j = 0; j < objectArray.length; ++j) {
                Object object2;
                Object object3;
                Object object4;
                int n = this.getModel().getChildCount(objectArray[j]);
                for (int k = 0; k < n; ++k) {
                    object4 = this.getModel().getChild(objectArray[j], k);
                    parentMap.addEntry(object4, objectArray[j]);
                    object3 = this.getModel().getAttributes(object4);
                    if (object3 == null) continue;
                    hashtable.put(object4, object3);
                }
                Map map2 = (Map)hashtable.get(objectArray[j]);
                object4 = this.getModel().getAttributes(objectArray[j]);
                if (map2 != null) {
                    object4.putAll(map2);
                }
                hashtable.put(objectArray[j], object4);
                object3 = this.getModel().getSource(objectArray[j]);
                if (object3 != null) {
                    connectionSet.connect(objectArray[j], object3, true);
                }
                if ((object2 = this.getModel().getTarget(objectArray[j])) == null) continue;
                connectionSet.connect(objectArray[j], object2, false);
            }
            objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            this.insert(objectArray, hashtable, connectionSet, parentMap, null);
        }
    }

    public void insertGroup(Object object2, Object[] objectArray) {
        if (object2 != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length + 1);
            if (!this.getModel().contains(object2)) {
                arrayList.add(object2);
            }
            ParentMap parentMap = new ParentMap();
            for (int j = 0; j < objectArray.length; ++j) {
                parentMap.addEntry(objectArray[j], object2);
                if (this.getModel().contains(objectArray[j])) continue;
                arrayList.add(objectArray[j]);
                AttributeMap attributeMap = this.getModel().getAttributes(objectArray[j]);
                if (attributeMap == null) continue;
                hashtable.put(objectArray[j], attributeMap);
            }
            if (arrayList.isEmpty()) {
                this.edit(hashtable, null, parentMap, null);
            } else {
                this.insert(arrayList.toArray(), hashtable, null, parentMap);
            }
        }
    }

    public void remove(Object[] objectArray) {
        this.graphModel.remove(objectArray);
    }

    public void remove(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl2) {
                Object[] objectArray2 = DefaultGraphModel.getEdges(this.getModel(), objectArray).toArray();
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                objectArray = objectArray3;
            }
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.remove(objectArray);
        }
    }

    public void hideCells(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.setVisible(objectArray, false);
        }
    }

    public void showCells(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.setVisible(objectArray, true);
        }
    }

    public Object[] ungroup(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            boolean bl = false;
            for (int j = 0; j < objectArray.length; ++j) {
                boolean bl2 = false;
                for (int k = 0; k < this.getModel().getChildCount(objectArray[j]); ++k) {
                    Object object2 = this.getModel().getChild(objectArray[j], k);
                    if (!this.getModel().isPort(object2)) {
                        arrayList2.add(object2);
                        bl2 = true;
                        continue;
                    }
                    arrayList.add(object2);
                }
                if (!bl2) continue;
                arrayList.add(objectArray[j]);
                bl = true;
            }
            if (bl) {
                this.remove(arrayList.toArray());
            }
            return arrayList2.toArray();
        }
        return null;
    }

    public void toggleCollapsedState(Object[] objectArray, boolean bl, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int j = 0; j < objectArray.length; ++j) {
            Object object2 = objectArray[j];
            CellView cellView = this.getMapping(object2, false);
            if (cellView == null) continue;
            if (cellView.isLeaf() && !bl) {
                arrayList.add(cellView.getCell());
                continue;
            }
            if (cellView.isLeaf() || bl2) continue;
            arrayList2.add(cellView.getCell());
        }
        if (!arrayList2.isEmpty() || !arrayList.isEmpty()) {
            this.setCollapsedState(arrayList2.toArray(), arrayList.toArray());
        }
    }

    public void collapse(Object[] objectArray) {
        this.setCollapsedState(objectArray, null);
    }

    public void expand(Object[] objectArray) {
        this.setCollapsedState(null, objectArray);
    }

    public void setCollapsedState(Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2;
        ConnectionSet connectionSet = new ConnectionSet();
        List list = DefaultGraphModel.getDescendants(this.getModel(), objectArray);
        if (objectArray != null) {
            int n3;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                list.remove(objectArray[n3]);
                this.cellWillCollapse(objectArray[n3]);
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                n2 = this.getModel().getChildCount(objectArray[n3]);
                if (n2 <= 0) continue;
                for (n = 0; n < n2; ++n) {
                    Object object2 = this.getModel().getChild(objectArray[n3], n);
                    if (!this.getModel().isPort(object2)) continue;
                    list.remove(object2);
                }
            }
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray2 != null) {
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                n = this.getModel().getChildCount(objectArray2[n2]);
                for (int j = 0; j < n; ++j) {
                    hashSet.add(this.getModel().getChild(objectArray2[n2], j));
                }
            }
        }
        this.setVisible(hashSet.toArray(), list != null ? list.toArray() : null, connectionSet);
    }

    protected Object getParentPort(Object object2, boolean bl) {
        int n;
        Object object3 = this.getModel().getParent(bl ? DefaultGraphModel.getSourceVertex(this.getModel(), object2) : DefaultGraphModel.getTargetVertex(this.getModel(), object2));
        int n2 = this.getModel().getChildCount(object3);
        int n3 = n = bl ? n2 - 1 : 0;
        while (n < this.getModel().getChildCount(object3) && n >= 0) {
            Object object4 = this.getModel().getChild(object3, n);
            if (this.getModel().isPort(object4)) {
                return object4;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    protected Object getChildPort(Object object2, boolean bl) {
        int n;
        GraphModel graphModel = this.getModel();
        Object object3 = bl ? DefaultGraphModel.getSourceVertex(graphModel, object2) : DefaultGraphModel.getTargetVertex(graphModel, object2);
        int n2 = graphModel.getChildCount(object3);
        int n3 = n = bl ? n2 - 1 : 0;
        while (n < n2 && n >= 0) {
            Object object4 = graphModel.getChild(object3, n);
            if (!graphModel.isEdge(object4) && !graphModel.isPort(object4)) {
                for (int j = 0; j < graphModel.getChildCount(object4); ++j) {
                    Object object5 = graphModel.getChild(object4, j);
                    if (!graphModel.isPort(object5)) continue;
                    return object5;
                }
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    public void edit(Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (map2 != null || connectionSet != null || parentMap != null || undoableEditArray != null) {
            Serializable serializable;
            Object[] objectArray = null;
            if (this.isPartial() && this.showsInvisibleEditedCells) {
                serializable = new HashSet();
                if (map2 != null) {
                    serializable.addAll(map2.keySet());
                }
                if (connectionSet != null) {
                    serializable.addAll(connectionSet.getChangedEdges());
                }
                if (parentMap != null) {
                    serializable.addAll(parentMap.getChangedNodes());
                }
                serializable.removeAll(this.visibleSet);
                if (!serializable.isEmpty()) {
                    objectArray = serializable.toArray();
                }
            }
            if ((serializable = this.createLocalEdit(null, map2, objectArray, null)) != null) {
                undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
            }
            this.graphModel.edit(map2, connectionSet, parentMap, undoableEditArray);
        }
    }

    public void edit(Map map2) {
        this.edit(map2, null, null, null);
    }

    public void edit(Object[] objectArray, Map map2) {
        if (map2 != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            for (int j = 0; j < objectArray.length; ++j) {
                hashtable.put(objectArray[j], map2);
            }
            this.edit(hashtable, null, null, null);
        }
    }

    public void editCell(Object object2, Map map2) {
        if (map2 != null && object2 != null) {
            this.edit(new Object[]{object2}, map2);
        }
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toBack(objectArray);
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toFront(objectArray);
        }
    }

    protected GraphLayoutCacheEdit createLocalEdit(Object[] objectArray, Map map2, Object[] objectArray2, Object[] objectArray3) {
        if (!(map2 == null || map2.isEmpty() || this.localAttributes.isEmpty() && !this.isAllAttributesLocal())) {
            Object object2;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Hashtable hashtable3 = new Hashtable();
                object2 = iterator.next();
                Object k = object2.getKey();
                Map map3 = (Map)object2.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    map3 = cellView.getAllAttributes().diff(map3);
                }
                Iterator iterator2 = map3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isAllAttributesLocal() && !bl && !this.isLocalAttribute(k, k2, v)) continue;
                    hashtable3.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!hashtable3.isEmpty()) {
                    hashtable2.put(k, hashtable3);
                }
                if (map3.isEmpty()) continue;
                hashtable.put(k, map3);
            }
            map2.clear();
            map2.putAll(hashtable);
            if (objectArray2 != null || objectArray3 != null || !hashtable2.isEmpty()) {
                object2 = new GraphLayoutCacheEdit(objectArray, new Hashtable(hashtable2), objectArray2, objectArray3);
                ((CompoundEdit)object2).end();
                return object2;
            }
        } else if (objectArray2 != null || objectArray3 != null) {
            GraphLayoutCacheEdit graphLayoutCacheEdit = new GraphLayoutCacheEdit(objectArray, null, objectArray2, objectArray3);
            graphLayoutCacheEdit.end();
            return graphLayoutCacheEdit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object object2, Object object3, Object object4) {
        return this.localAttributes.contains(object3);
    }

    protected boolean isControlAttribute(Object object2, Object object3, Object object4) {
        return "removeAll".equals(object3) || "removeAttributes".equals(object3);
    }

    protected void cellExpanded(Object object2) {
        CellView cellView;
        CellView cellView2;
        GraphModel graphModel = this.getModel();
        if (this.movesChildrenOnExpand && !graphModel.isPort(object2) && (cellView2 = this.getMapping(object2, false)) != null && (cellView = this.getMapping(graphModel.getParent(object2), false)) != null && cellView instanceof VertexView) {
            VertexView vertexView = (VertexView)cellView;
            Rectangle2D rectangle2D = GraphConstants.getBounds(cellView.getAllAttributes());
            Rectangle2D rectangle2D2 = vertexView.getBounds();
            double d2 = rectangle2D.getX() - rectangle2D2.getX();
            double d3 = rectangle2D.getY() - rectangle2D2.getY();
            AttributeMap attributeMap = cellView2.getAttributes();
            if (!attributeMap.contains("bounds")) {
                attributeMap = graphModel.getAttributes(cellView2.getCell());
            }
            attributeMap.translate(d2, d3);
        }
    }

    protected void cellWillCollapse(Object object2) {
        CellView cellView;
        GraphModel graphModel = this.getModel();
        if (this.movesParentsOnCollapse && (cellView = this.getMapping(object2, false)) != null && !cellView.isLeaf()) {
            AttributeMap attributeMap = cellView.getAttributes();
            if (!attributeMap.contains("bounds") && !this.localAttributes.contains("bounds")) {
                attributeMap = graphModel.getAttributes(object2);
            }
            Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
            Rectangle2D rectangle2D2 = cellView.getBounds();
            if (this.resizesParentsOnCollapse || rectangle2D == null || rectangle2D.equals(VertexView.defaultBounds)) {
                rectangle2D = attributeMap.createRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() * this.collapseXScale, rectangle2D2.getHeight() * this.collapseYScale);
                attributeMap.applyValue("bounds", rectangle2D);
            } else {
                rectangle2D.setFrame(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
    }

    protected Map handleAttributes(Map map2) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        CellView[] cellViewArray = new CellView[map2.size()];
        Iterator iterator = map2.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null || cellView.getAttributes() == null) continue;
            Map map3 = (Map)entry.getValue();
            AttributeMap attributeMap = cellView.getAttributes().applyMap(map3);
            cellView.refresh(this.getModel(), this, false);
            hashtable.put(cellView.getCell(), attributeMap);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d2, double d3) {
        for (int j = 0; j < cellViewArray.length; ++j) {
            if (!(cellViewArray[j] instanceof AbstractCellView)) continue;
            ((AbstractCellView)cellViewArray[j]).translate(d2, d3);
        }
    }

    public List getNeighbours(Object object2, Set set, boolean bl, boolean bl2) {
        GraphModel graphModel = this.getModel();
        Object[] objectArray = bl ? DefaultGraphModel.getOutgoingEdges(graphModel, object2) : DefaultGraphModel.getEdges(graphModel, new Object[]{object2}).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length + 8, 0.75f);
        for (int j = 0; j < objectArray.length; ++j) {
            Object object3 = DefaultGraphModel.getOpposite(graphModel, objectArray[j], object2);
            if (object3 == null || set != null && set.contains(object3) || hashSet.contains(object3) || bl2 && !this.isVisible(object3)) continue;
            hashSet.add(object3);
            arrayList.add(object3);
        }
        return arrayList;
    }

    public List getOutgoingEdges(Object object2, Set set, boolean bl, boolean bl2) {
        return this.getEdges(object2, set, bl, bl2, false);
    }

    public List getIncomingEdges(Object object2, Set set, boolean bl, boolean bl2) {
        return this.getEdges(object2, set, bl, bl2, true);
    }

    protected List getEdges(Object object2, Set set, boolean bl, boolean bl2, boolean bl3) {
        GraphModel graphModel = this.getModel();
        Object[] objectArray = DefaultGraphModel.getEdges(graphModel, object2, bl3);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
        for (int j = 0; j < objectArray.length; ++j) {
            if (set != null && set.contains(objectArray[j]) || hashSet.contains(objectArray[j]) || bl && !this.isVisible(objectArray[j])) continue;
            if (bl2 || graphModel.getSource(objectArray[j]) != graphModel.getTarget(objectArray[j])) {
                arrayList.add(objectArray[j]);
            }
            hashSet.add(objectArray[j]);
        }
        return arrayList;
    }

    public CellView[] getAllViews() {
        return this.getAllDescendants(this.getRoots());
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int j = 0; j < cellViewArray.length; ++j) {
            if (cellViewArray[j] == null) continue;
            stack.add(cellViewArray[j]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            int n;
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (n = 0; n < cellViewArray3.length; ++n) {
                stack.add(cellViewArray3[n]);
            }
            arrayList.add(cellViewArray2);
            for (n = 0; n < this.graphModel.getChildCount(cellViewArray2.getCell()); ++n) {
                CellView cellView;
                Object object2 = this.graphModel.getChild(cellViewArray2.getCell(), n);
                if (!this.graphModel.isPort(object2) || (cellView = this.getMapping(object2, false)) == null) continue;
                stack.add(cellView);
            }
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public Map getHiddenMapping() {
        return this.hiddenMapping;
    }

    public void setShowsExistingConnections(boolean bl) {
        this.showsExistingConnections = bl;
    }

    public boolean isShowsExistingConnections() {
        return this.showsExistingConnections;
    }

    public void setShowsInsertedConnections(boolean bl) {
        this.showsInsertedConnections = bl;
    }

    public boolean isShowsInsertedConnections() {
        return this.showsInsertedConnections;
    }

    public void setHidesExistingConnections(boolean bl) {
        this.hidesExistingConnections = bl;
    }

    public boolean isHidesExistingConnections() {
        return this.hidesExistingConnections;
    }

    public void setHidesDanglingConnections(boolean bl) {
        this.hidesDanglingConnections = bl;
    }

    public boolean isHidesDanglingConnections() {
        return this.hidesDanglingConnections;
    }

    public void setRemembersCellViews(boolean bl) {
        this.remembersCellViews = bl;
    }

    public boolean isRemembersCellViews() {
        return this.remembersCellViews;
    }

    public void setHiddenSet(Map map2) {
        this.hiddenMapping = map2;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAllAttributesLocal() {
        return this.allAttributesLocal;
    }

    public void setAllAttributesLocal(boolean bl) {
        this.allAttributesLocal = bl;
    }

    public boolean isAutoSizeOnValueChange() {
        return this.autoSizeOnValueChange;
    }

    public void setAutoSizeOnValueChange(boolean bl) {
        this.autoSizeOnValueChange = bl;
    }

    public boolean isSelectsAllInsertedCells() {
        return this.selectsAllInsertedCells;
    }

    public void setSelectsAllInsertedCells(boolean bl) {
        this.selectsAllInsertedCells = bl;
    }

    public boolean isSelectsLocalInsertedCells() {
        return this.selectsLocalInsertedCells;
    }

    public void setSelectsLocalInsertedCells(boolean bl) {
        this.selectsLocalInsertedCells = bl;
    }

    public boolean isReconnectsEdgesToVisibleParent() {
        return this.reconnectsEdgesToVisibleParent;
    }

    public void setReconnectsEdgesToVisibleParent(boolean bl) {
        this.reconnectsEdgesToVisibleParent = bl;
    }

    public boolean isShowsChangedConnections() {
        return this.showsChangedConnections;
    }

    public void setShowsChangedConnections(boolean bl) {
        this.showsChangedConnections = bl;
    }

    public boolean isMovesChildrenOnExpand() {
        return this.movesChildrenOnExpand;
    }

    public void setMovesChildrenOnExpand(boolean bl) {
        this.movesChildrenOnExpand = bl;
    }

    public double getCollapseXScale() {
        return this.collapseXScale;
    }

    public void setCollapseXScale(double d2) {
        this.collapseXScale = d2;
    }

    public double getCollapseYScale() {
        return this.collapseYScale;
    }

    public void setCollapseYScale(double d2) {
        this.collapseYScale = d2;
    }

    public boolean isMovesParentsOnCollapse() {
        return this.movesParentsOnCollapse;
    }

    public void setMovesParentsOnCollapse(boolean bl) {
        this.movesParentsOnCollapse = bl;
    }

    public boolean isResizesParentsOnCollapse() {
        return this.resizesParentsOnCollapse;
    }

    public void setResizesParentsOnCollapse(boolean bl) {
        this.resizesParentsOnCollapse = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class GraphLayoutCacheEdit
    extends CompoundEdit
    implements GraphLayoutCacheEvent.GraphLayoutCacheChange {
        protected Object[] cells;
        protected Object[] previousCells = null;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Map previousAttributes;
        protected Object[] visible;
        protected Object[] invisible;
        protected Set changedCells = new HashSet();

        public GraphLayoutCacheEdit(Map map2) {
            this(null, map2, null, null);
            this.attributes = map2;
        }

        public GraphLayoutCacheEdit(Object[] objectArray, Map map2, Object[] objectArray2, Object[] objectArray3) {
            this.attributes = map2;
            this.previousAttributes = map2;
            this.cells = objectArray;
            this.visible = objectArray2;
            this.invisible = objectArray3;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object[] getChanged() {
            return this.changedCells.toArray();
        }

        public Object[] getInserted() {
            return this.invisible;
        }

        public Object[] getRemoved() {
            return this.visible;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            Object object2;
            int n;
            int n2;
            GraphModel graphModel = GraphLayoutCache.this.getModel();
            this.changedCells.clear();
            if (this.hidden != null) {
                for (n2 = 0; n2 < this.hidden.length; ++n2) {
                    if (this.hidden[n2] == null) continue;
                    GraphLayoutCache.this.mapping.put(this.hidden[n2].getCell(), this.hidden[n2]);
                }
            }
            if (!GraphLayoutCache.this.remembersCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            n2 = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            if (this.visible != null) {
                for (n = 0; n < this.visible.length; ++n) {
                    this.changedCells.add(this.visible[n]);
                    if (this.cells != null) continue;
                    GraphLayoutCache.this.cellExpanded(this.visible[n]);
                }
            }
            if (this.invisible != null) {
                for (n = 0; n < this.invisible.length; ++n) {
                    this.changedCells.add(this.invisible[n]);
                }
            }
            Object[] objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.attributes != null) {
                this.previousAttributes = this.attributes;
                this.changedCells.addAll(this.attributes.keySet());
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
            }
            if (n2 != 0) {
                GraphLayoutCache.this.updatePorts();
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = this.changedCells.iterator();
            while (iterator.hasNext()) {
                object2 = graphModel.getParent(iterator.next());
                while (object2 != null) {
                    hashSet.add(object2);
                    object2 = graphModel.getParent(object2);
                }
            }
            this.changedCells.addAll(hashSet);
            GraphLayoutCache.this.refresh(GraphLayoutCache.this.getMapping(this.changedCells.toArray(), false), false);
            object2 = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.changedCells.toArray());
            this.context = GraphLayoutCache.this.getMapping(object2.toArray());
            GraphLayoutCache.this.refresh(this.context, false);
            objectArray = this.cells;
            this.cells = this.previousCells;
            this.previousCells = objectArray;
            GraphLayoutCache.this.reloadRoots();
            GraphLayoutCache.this.fireGraphLayoutCacheChanged(GraphLayoutCache.this, this);
        }
    }
}

