/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphModel;

public class GraphConstants {
    public static Font DEFAULTFONT = null;
    public static int DEFAULTDECORATIONSIZE;
    public static int DEFAULTINSET;
    public static final int PERMILLE = 1000;
    protected static float[] dash;
    public static Stroke SELECTION_STROKE;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static Edge.Routing ROUTING_DEFAULT;
    public static final Edge.Routing ROUTING_SIMPLE;
    public static final String SIZEABLEAXIS = "sizeableAxis";
    public static final String MOVEABLEAXIS = "moveableAxis";
    public static final String REPLACEATTRIBUTES = "replaceAttributes";
    public static final String REMOVEATTRIBUTES = "removeAttributes";
    public static final String REMOVEALL = "removeAll";
    public static final String ICON = "icon";
    public static final String FONT = "font";
    public static final String OPAQUE = "opaque";
    public static final String GROUPOPAQUE = "groupOpaque";
    public static final String BORDER = "border";
    public static final String LINECOLOR = "linecolor";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String LINEWIDTH = "linewidth";
    public static final String FOREGROUND = "foregroundColor";
    public static final String BACKGROUND = "backgroundColor";
    public static final String GRADIENTCOLOR = "gradientColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String DASHPATTERN = "dashPattern";
    public static final String DASHOFFSET = "dashOffset";
    public static final String LINESTYLE = "lineStyle";
    public static final String LINEBEGIN = "lineBegin";
    public static final String LINEEND = "lineEnd";
    public static final String BEGINSIZE = "beginSize";
    public static final String ENDSIZE = "endSize";
    public static final String BEGINFILL = "beginFill";
    public static final String ENDFILL = "endFill";
    public static final String VALUE = "value";
    public static final String EDITABLE = "editable";
    public static final String MOVEABLE = "moveable";
    public static final String SIZEABLE = "sizeable";
    public static final String AUTOSIZE = "autosize";
    public static final String RESIZE = "resize";
    public static final String INSET = "inset";
    public static final String CONSTRAINED = "constrained";
    public static final String SELECTABLE = "selectable";
    public static final String CHILDRENSELECTABLE = "childrenSelectable";
    public static final String MOVEHIDDENCHILDREN = "childrenSelectable";
    public static final String BENDABLE = "bendable";
    public static final String CONNECTABLE = "connectable";
    public static final String DISCONNECTABLE = "disconnectable";
    public static final String BOUNDS = "bounds";
    public static final String POINTS = "points";
    public static final String ROUTING = "routing";
    public static final String LABELPOSITION = "labelposition";
    public static final String EXTRALABELS = "extraLabels";
    public static final String EXTRALABELPOSITIONS = "extraLabelPositions";
    public static final String LABELALONGEDGE = "labelAlongEdge";
    public static final String ABSOLUTEX = "absoluteX";
    public static final String ABSOLUTEY = "absoluteY";
    public static final String OFFSET = "offset";
    public static final String SIZE = "size";

    public static Map createAttributes(Object object2, Object object3, Object object4) {
        return GraphConstants.createAttributes(new Object[]{object2}, new Object[]{object3}, new Object[]{object4});
    }

    public static Map createAttributes(Object[] objectArray, Object object2, Object object3) {
        return GraphConstants.createAttributes(objectArray, new Object[]{object2}, new Object[]{object3});
    }

    public static Map createAttributes(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        if (objectArray2 != null && objectArray3 != null && objectArray2.length != objectArray3.length) {
            throw new IllegalArgumentException("Keys and values must have same length");
        }
        Hashtable hashtable = new Hashtable();
        for (int j = 0; j < objectArray.length; ++j) {
            if (objectArray[j] == null) continue;
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            for (int k = 0; k < objectArray2.length; ++k) {
                if (objectArray2[k] == null || objectArray3[k] == null) continue;
                hashtable2.put(objectArray2[k], objectArray3[k]);
            }
            hashtable.put(objectArray[j], hashtable2);
        }
        return hashtable;
    }

    public static Map createAttributes(Object[] objectArray, CellMapper cellMapper) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        for (int j = 0; j < objectArray.length; ++j) {
            CellView cellView = null;
            Object object2 = objectArray[j];
            if (object2 instanceof CellView) {
                cellView = (CellView)object2;
                object2 = cellView.getCell();
            } else if (cellMapper != null) {
                cellView = cellMapper.getMapping(object2, false);
            }
            if (cellView == null) continue;
            hashtable.put(object2, cellView.getAllAttributes().clone());
        }
        return hashtable;
    }

    public static Map createAttributesFromModel(Object[] objectArray, GraphModel graphModel) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        for (int j = 0; j < objectArray.length; ++j) {
            AttributeMap attributeMap = graphModel.getAttributes(objectArray[j]);
            if (attributeMap == null || attributeMap.size() <= 0) continue;
            hashtable.put(objectArray[j], (AttributeMap)attributeMap.clone());
        }
        return hashtable;
    }

    public static Map replaceKeys(Map map2, Map map3) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof Map) || (v = map2.get(entry.getKey())) == null) continue;
            AttributeMap attributeMap = (AttributeMap)((AttributeMap)entry.getValue()).clone();
            hashtable.put(v, attributeMap);
        }
        return hashtable;
    }

    public static Map merge(Map hashtable, Map map2) {
        if (hashtable != null && map2 != null) {
            hashtable = new Hashtable(hashtable);
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map3 = (Map)entry.getValue();
                Map map4 = (Map)hashtable.remove(entry.getKey());
                if (map4 == null) continue;
                map3.putAll(map4);
            }
            map2.putAll(hashtable);
        }
        return map2;
    }

    public static void setFont(Map map2, Font font2) {
        map2.put(FONT, font2);
    }

    public static Font getFont(Map map2) {
        Font font2 = (Font)map2.get(FONT);
        if (font2 == null) {
            font2 = DEFAULTFONT;
        }
        return font2;
    }

    public static final void setRemoveAttributes(Map map2, Object[] objectArray) {
        map2.put(REMOVEATTRIBUTES, objectArray);
    }

    public static final Object[] getRemoveAttributes(Map map2) {
        return (Object[])map2.get(REMOVEATTRIBUTES);
    }

    public static final void setMoveableAxis(Map map2, int n) {
        map2.put(MOVEABLEAXIS, new Integer(n));
    }

    public static final int getMoveableAxis(Map map2) {
        Integer n = (Integer)map2.get(MOVEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setSizeableAxis(Map map2, int n) {
        map2.put(SIZEABLEAXIS, new Integer(n));
    }

    public static final int getSizeableAxis(Map map2) {
        Integer n = (Integer)map2.get(SIZEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setIcon(Map map2, Icon icon) {
        map2.put(ICON, icon);
    }

    public static final Icon getIcon(Map map2) {
        return (Icon)map2.get(ICON);
    }

    public static final void setOpaque(Map map2, boolean bl) {
        map2.put(OPAQUE, new Boolean(bl));
    }

    public static final boolean isOpaque(Map map2) {
        Boolean bl = (Boolean)map2.get(OPAQUE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setGroupOpaque(Map map2, boolean bl) {
        map2.put(GROUPOPAQUE, new Boolean(bl));
    }

    public static final boolean isGroupOpaque(Map map2) {
        Boolean bl = (Boolean)map2.get(GROUPOPAQUE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setBorder(Map map2, Border border) {
        map2.put(BORDER, border);
    }

    public static final Border getBorder(Map map2) {
        return (Border)map2.get(BORDER);
    }

    public static final void setLineColor(Map map2, Color color) {
        map2.put(LINECOLOR, color);
    }

    public static final Color getLineColor(Map map2) {
        return (Color)map2.get(LINECOLOR);
    }

    public static final void setBorderColor(Map map2, Color color) {
        map2.put(BORDERCOLOR, color);
    }

    public static final Color getBorderColor(Map map2) {
        return (Color)map2.get(BORDERCOLOR);
    }

    public static final void setLineWidth(Map map2, float f2) {
        map2.put(LINEWIDTH, new Float(f2));
    }

    public static final float getLineWidth(Map map2) {
        Float f2 = (Float)map2.get(LINEWIDTH);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 1.0f;
    }

    public static final void setForeground(Map map2, Color color) {
        map2.put(FOREGROUND, color);
    }

    public static final Color getForeground(Map map2) {
        return (Color)map2.get(FOREGROUND);
    }

    public static final void setBackground(Map map2, Color color) {
        map2.put(BACKGROUND, color);
    }

    public static final Color getBackground(Map map2) {
        return (Color)map2.get(BACKGROUND);
    }

    public static final void setGradientColor(Map map2, Color color) {
        map2.put(GRADIENTCOLOR, color);
    }

    public static final Color getGradientColor(Map map2) {
        return (Color)map2.get(GRADIENTCOLOR);
    }

    public static final void setVerticalAlignment(Map map2, int n) {
        map2.put(VERTICAL_ALIGNMENT, new Integer(n));
    }

    public static final int getVerticalAlignment(Map map2) {
        Integer n = (Integer)map2.get(VERTICAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setHorizontalAlignment(Map map2, int n) {
        map2.put(HORIZONTAL_ALIGNMENT, new Integer(n));
    }

    public static final int getHorizontalAlignment(Map map2) {
        Integer n = (Integer)map2.get(HORIZONTAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setVerticalTextPosition(Map map2, int n) {
        map2.put(VERTICAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getVerticalTextPosition(Map map2) {
        Integer n = (Integer)map2.get(VERTICAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 3;
    }

    public static final void setHorizontalTextPosition(Map map2, int n) {
        map2.put(HORIZONTAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getHorizontalTextPosition(Map map2) {
        Integer n = (Integer)map2.get(HORIZONTAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setDashPattern(Map map2, float[] fArray) {
        map2.put(DASHPATTERN, fArray);
    }

    public static final float[] getDashPattern(Map map2) {
        return (float[])map2.get(DASHPATTERN);
    }

    public static final void setDashOffset(Map map2, float f2) {
        map2.put(DASHOFFSET, new Float(f2));
    }

    public static final float getDashOffset(Map map2) {
        Float f2 = (Float)map2.get(DASHOFFSET);
        if (f2 != null) {
            return f2.floatValue();
        }
        return 1.0f;
    }

    public static final void setLineStyle(Map map2, int n) {
        map2.put(LINESTYLE, new Integer(n));
    }

    public static final int getLineStyle(Map map2) {
        Integer n = (Integer)map2.get(LINESTYLE);
        if (n != null) {
            return n;
        }
        return 11;
    }

    public static final void setBeginSize(Map map2, int n) {
        map2.put(BEGINSIZE, new Integer(n));
    }

    public static final int getBeginSize(Map map2) {
        Integer n = (Integer)map2.get(BEGINSIZE);
        if (n != null) {
            return n;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setEndSize(Map map2, int n) {
        map2.put(ENDSIZE, new Integer(n));
    }

    public static final int getEndSize(Map map2) {
        Integer n = (Integer)map2.get(ENDSIZE);
        if (n != null) {
            return n;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setLineBegin(Map map2, int n) {
        map2.put(LINEBEGIN, new Integer(n));
    }

    public static final int getLineBegin(Map map2) {
        Integer n = (Integer)map2.get(LINEBEGIN);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setLineEnd(Map map2, int n) {
        map2.put(LINEEND, new Integer(n));
    }

    public static final int getLineEnd(Map map2) {
        Integer n = (Integer)map2.get(LINEEND);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setValue(Map map2, Object object2) {
        map2.put(VALUE, object2);
    }

    public static final Object getValue(Map map2) {
        return map2.get(VALUE);
    }

    public static final void setLabelPosition(Map map2, Point2D point2D) {
        map2.put(LABELPOSITION, point2D);
    }

    public static final Point2D getLabelPosition(Map map2) {
        return (Point2D)map2.get(LABELPOSITION);
    }

    public static final void setExtraLabels(Map map2, Object[] objectArray) {
        map2.put(EXTRALABELS, objectArray);
    }

    public static final Object[] getExtraLabels(Map map2) {
        return (Object[])map2.get(EXTRALABELS);
    }

    public static final void setExtraLabelPositions(Map map2, Point2D[] point2DArray) {
        map2.put(EXTRALABELPOSITIONS, point2DArray);
    }

    public static final Point2D[] getExtraLabelPositions(Map map2) {
        return (Point2D[])map2.get(EXTRALABELPOSITIONS);
    }

    public static final void setLabelAlongEdge(Map map2, boolean bl) {
        map2.put(LABELALONGEDGE, new Boolean(bl));
    }

    public static final boolean isLabelAlongEdge(Map map2) {
        Boolean bl = (Boolean)map2.get(LABELALONGEDGE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEditable(Map map2, boolean bl) {
        map2.put(EDITABLE, new Boolean(bl));
    }

    public static final boolean isEditable(Map map2) {
        Boolean bl = (Boolean)map2.get(EDITABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setMoveable(Map map2, boolean bl) {
        map2.put(MOVEABLE, new Boolean(bl));
    }

    public static final boolean isMoveable(Map map2) {
        Boolean bl = (Boolean)map2.get(MOVEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setSizeable(Map map2, boolean bl) {
        map2.put(SIZEABLE, new Boolean(bl));
    }

    public static final boolean isSizeable(Map map2) {
        Boolean bl = (Boolean)map2.get(SIZEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setAutoSize(Map map2, boolean bl) {
        map2.put(AUTOSIZE, new Boolean(bl));
    }

    public static final boolean isAutoSize(Map map2) {
        Boolean bl = (Boolean)map2.get(AUTOSIZE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setResize(Map map2, boolean bl) {
        map2.put(RESIZE, new Boolean(bl));
    }

    public static final boolean isResize(Map map2) {
        Boolean bl = (Boolean)map2.get(RESIZE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setConstrained(Map map2, boolean bl) {
        map2.put(CONSTRAINED, new Boolean(bl));
    }

    public static final boolean isConstrained(Map map2) {
        Boolean bl = (Boolean)map2.get(CONSTRAINED);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setSelectable(Map map2, boolean bl) {
        map2.put(SELECTABLE, new Boolean(bl));
    }

    public static final boolean isSelectable(Map map2) {
        Boolean bl = (Boolean)map2.get(SELECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setChildrenSelectable(Map map2, boolean bl) {
        map2.put("childrenSelectable", new Boolean(bl));
    }

    public static final boolean isChildrenSelectable(Map map2) {
        Boolean bl = (Boolean)map2.get("childrenSelectable");
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setBendable(Map map2, boolean bl) {
        map2.put(BENDABLE, new Boolean(bl));
    }

    public static final boolean isBendable(Map map2) {
        Boolean bl = (Boolean)map2.get(BENDABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setConnectable(Map map2, boolean bl) {
        map2.put(CONNECTABLE, new Boolean(bl));
    }

    public static final boolean isConnectable(Map map2) {
        Boolean bl = (Boolean)map2.get(CONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setDisconnectable(Map map2, boolean bl) {
        map2.put(DISCONNECTABLE, new Boolean(bl));
    }

    public static final boolean isDisconnectable(Map map2) {
        Boolean bl = (Boolean)map2.get(DISCONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setPoints(Map map2, List list) {
        map2.put(POINTS, list);
    }

    public static final List getPoints(Map map2) {
        return (List)map2.get(POINTS);
    }

    public static final void setRouting(Map map2, Edge.Routing routing) {
        map2.put(ROUTING, routing);
    }

    public static final Edge.Routing getRouting(Map map2) {
        Edge.Routing routing = (Edge.Routing)map2.get(ROUTING);
        if (routing == null) {
            routing = ROUTING_DEFAULT;
        }
        return routing;
    }

    public static final void setBounds(Map map2, Rectangle2D rectangle2D) {
        map2.put(BOUNDS, rectangle2D);
    }

    public static final Rectangle2D getBounds(Map map2) {
        return (Rectangle2D)map2.get(BOUNDS);
    }

    public static final void setInset(Map map2, int n) {
        map2.put(INSET, new Integer(n));
    }

    public static final int getInset(Map map2) {
        Integer n = (Integer)map2.get(INSET);
        if (n != null) {
            return n;
        }
        return DEFAULTINSET;
    }

    public static final void setSize(Map map2, Dimension dimension) {
        map2.put(SIZE, dimension);
    }

    public static final Dimension getSize(Map map2) {
        return (Dimension)map2.get(SIZE);
    }

    public static final void setOffset(Map map2, Point2D point2D) {
        map2.put(OFFSET, point2D);
    }

    public static final Point2D getOffset(Map map2) {
        return (Point2D)map2.get(OFFSET);
    }

    public static final void setBeginFill(Map map2, boolean bl) {
        map2.put(BEGINFILL, new Boolean(bl));
    }

    public static final boolean isBeginFill(Map map2) {
        Boolean bl = (Boolean)map2.get(BEGINFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEndFill(Map map2, boolean bl) {
        map2.put(ENDFILL, new Boolean(bl));
    }

    public static final boolean isEndFill(Map map2) {
        Boolean bl = (Boolean)map2.get(ENDFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setAbsolute(Map map2, boolean bl) {
        GraphConstants.setAbsoluteX(map2, bl);
        GraphConstants.setAbsoluteY(map2, bl);
    }

    public static final void setAbsoluteY(Map map2, boolean bl) {
        map2.put(ABSOLUTEY, new Boolean(bl));
    }

    public static final boolean isAbsoluteY(Map map2) {
        Boolean bl = (Boolean)map2.get(ABSOLUTEY);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setAbsoluteX(Map map2, boolean bl) {
        map2.put(ABSOLUTEX, new Boolean(bl));
    }

    public static final boolean isAbsoluteX(Map map2) {
        Boolean bl = (Boolean)map2.get(ABSOLUTEX);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setRemoveAll(Map map2, boolean bl) {
        map2.put(REMOVEALL, new Boolean(bl));
    }

    public static final boolean isRemoveAll(Map map2) {
        Boolean bl = (Boolean)map2.get(REMOVEALL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static Edge.Routing getROUTING_SIMPLE() {
        return ROUTING_SIMPLE;
    }

    public static Edge.Routing getROUTING_DEFAULT() {
        return ROUTING_DEFAULT;
    }

    static {
        try {
            DEFAULTFONT = UIManager.getDefaults().getFont("Label.font");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        DEFAULTDECORATIONSIZE = 10;
        DEFAULTINSET = 0;
        dash = new float[]{5.0f, 5.0f};
        SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        ROUTING_DEFAULT = new DefaultEdge.LoopRouting();
        ROUTING_SIMPLE = new DefaultEdge.DefaultRouting();
    }
}

