/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;

public class DefaultGraphSelectionModel
implements GraphSelectionModel,
Cloneable,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    public static final int SELECTED = -1;
    public static final Integer UNSELECTED = new Integer(0);
    protected JGraph graph;
    protected SwingPropertyChangeSupport changeSupport;
    protected EventListenerList listenerList = new EventListenerList();
    protected int selectionMode;
    protected boolean childrenSelectable = true;
    protected Map cellStates = new Hashtable();
    protected List selection = new ArrayList();
    static /* synthetic */ Class class$org$jgraph$event$GraphSelectionListener;

    public DefaultGraphSelectionModel(JGraph jGraph) {
        this.graph = jGraph;
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 4 && this.selectionMode != 1) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n2), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setChildrenSelectable(boolean bl) {
        this.childrenSelectable = bl;
    }

    public boolean isChildrenSelectable() {
        return this.childrenSelectable;
    }

    protected boolean isChildrenSelectable(Object object2) {
        AttributeMap attributeMap = this.graph.getModel().getAttributes(object2);
        if (attributeMap != null && this.childrenSelectable) {
            return GraphConstants.isChildrenSelectable(attributeMap);
        }
        return this.childrenSelectable;
    }

    public void setSelectionCell(Object object2) {
        if (object2 == null) {
            this.setSelectionCells(null);
        } else {
            this.setSelectionCells(new Object[]{object2});
        }
    }

    public void setSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            Object object2;
            if (this.selectionMode == 1 && objectArray.length > 0) {
                objectArray = new Object[]{objectArray[objectArray.length - 1]};
            }
            this.cellStates.clear();
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < objectArray.length; ++j) {
                if (objectArray[j] == null) continue;
                this.selection.remove(objectArray[j]);
                vector.addElement(new CellPlaceHolder(objectArray[j], !this.selection.remove(objectArray[j])));
                this.select(arrayList, objectArray[j]);
                object2 = this.graph.getModel().getParent(objectArray[j]);
                if (object2 == null) continue;
                vector.addElement(new CellPlaceHolder(object2, false));
            }
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                while (object2 != null) {
                    vector.addElement(new CellPlaceHolder(object2, false));
                    object2 = this.graph.getModel().getParent(object2);
                }
            }
            this.selection = arrayList;
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public void addSelectionCell(Object object2) {
        if (object2 != null) {
            this.addSelectionCells(new Object[]{object2});
        }
    }

    public void addSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            if (this.selectionMode == 1) {
                this.setSelectionCells(objectArray);
            } else {
                Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
                for (int j = 0; j < objectArray.length; ++j) {
                    boolean bl;
                    if (objectArray[j] == null || !(bl = this.select(this.selection, objectArray[j]))) continue;
                    vector.addElement(new CellPlaceHolder(objectArray[j], true));
                    Object object2 = this.graph.getModel().getParent(objectArray[j]);
                    if (object2 == null) continue;
                    vector.addElement(new CellPlaceHolder(object2, false));
                }
                if (vector.size() > 0) {
                    this.notifyCellChange(vector);
                }
            }
        }
    }

    public void removeSelectionCell(Object object2) {
        if (object2 != null) {
            this.removeSelectionCells(new Object[]{object2});
        }
    }

    public void removeSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            for (int j = 0; j < objectArray.length; ++j) {
                boolean bl;
                if (objectArray[j] == null || !(bl = this.deselect(objectArray[j]))) continue;
                vector.addElement(new CellPlaceHolder(objectArray[j], false));
                Object object2 = this.graph.getModel().getParent(objectArray[j]);
                if (object2 == null) continue;
                vector.addElement(new CellPlaceHolder(object2, false));
            }
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public Object[] getSelectables() {
        if (this.isChildrenSelectable()) {
            ArrayList arrayList = new ArrayList();
            Stack<Object> stack = new Stack<Object>();
            GraphModel graphModel = this.graph.getModel();
            for (int j = 0; j < graphModel.getRootCount(); ++j) {
                stack.add(graphModel.getRootAt(j));
            }
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                AttributeMap attributeMap = this.graph.getAttributes(e2);
                if (!graphModel.isPort(e2) && (attributeMap == null || GraphConstants.isSelectable(attributeMap))) {
                    arrayList.add(e2);
                }
                if (!this.isChildrenSelectable(e2)) continue;
                for (int j = 0; j < graphModel.getChildCount(e2); ++j) {
                    stack.add(graphModel.getChild(e2, j));
                }
            }
            return arrayList.toArray();
        }
        return this.graph.getRoots();
    }

    public Object getSelectionCell() {
        if (this.selection != null && this.selection.size() > 0) {
            return this.selection.toArray()[0];
        }
        return null;
    }

    public Object[] getSelectionCells() {
        if (this.selection != null) {
            return this.selection.toArray();
        }
        return null;
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.size();
    }

    public boolean isCellSelected(Object object2) {
        int n = this.getSelectedChildCount(object2);
        return n == -1;
    }

    public boolean isChildrenSelected(Object object2) {
        int n = this.getSelectedChildCount(object2);
        return n > 0;
    }

    public boolean isSelectionEmpty() {
        return this.selection.isEmpty();
    }

    public void clearSelection() {
        if (this.selection != null) {
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            Iterator iterator = this.cellStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object object2 = entry.getKey();
                while (object2 != null) {
                    vector.addElement(new CellPlaceHolder(object2, false));
                    object2 = this.graph.getModel().getParent(object2);
                }
            }
            this.selection.clear();
            this.cellStates.clear();
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    protected int getSelectedChildCount(Object object2) {
        if (object2 != null) {
            Integer n = (Integer)this.cellStates.get(object2);
            if (n == null) {
                n = UNSELECTED;
                this.cellStates.put(object2, n);
            }
            return n;
        }
        return 0;
    }

    protected void setSelectedChildCount(Object object2, int n) {
        Integer n2 = new Integer(n);
        this.cellStates.put(object2, n2);
    }

    protected boolean select(List list, Object object2) {
        AttributeMap attributeMap = this.graph.getAttributes(object2);
        if (!this.isCellSelected(object2) && this.graph.getGraphLayoutCache().isVisible(object2) && (attributeMap == null || GraphConstants.isSelectable(attributeMap))) {
            GraphModel graphModel = this.graph.getModel();
            Object object3 = graphModel.getParent(object2);
            while (object3 != null) {
                int n = this.getSelectedChildCount(object3);
                if (n == -1) {
                    n = 0;
                }
                this.setSelectedChildCount(object3, ++n);
                this.selection.remove(object3);
                object3 = graphModel.getParent(object3);
            }
            Object[] objectArray = new Object[]{object2};
            List list2 = DefaultGraphModel.getDescendants(graphModel, objectArray);
            list2.remove(object2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 == null || graphModel.isPort(e2)) continue;
                this.selection.remove(e2);
                this.cellStates.remove(e2);
            }
            this.setSelectedChildCount(object2, -1);
            return list.add(object2);
        }
        return false;
    }

    protected boolean deselect(Object object2) {
        if (this.isCellSelected(object2)) {
            Object object3 = this.graph.getModel().getParent(object2);
            boolean bl = true;
            int n = -1;
            while (object3 != null && n != 0) {
                int n2 = this.getSelectedChildCount(object3);
                if ((n2 += n) == 0 && bl) {
                    n = 0;
                    n2 = -1;
                    this.selection.add(object3);
                }
                this.setSelectedChildCount(object3, n2);
                object3 = this.graph.getModel().getParent(object3);
                bl = false;
            }
            this.cellStates.remove(object2);
            return this.selection.remove(object2);
        }
        return false;
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    protected void fireValueChanged(GraphSelectionEvent graphSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int j = objectArray.length - 2; j >= 0; j -= 2) {
            if (objectArray[j] != (class$org$jgraph$event$GraphSelectionListener == null ? DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener") : class$org$jgraph$event$GraphSelectionListener)) continue;
            ((GraphSelectionListener)objectArray[j + 1]).valueChanged(graphSelectionEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void notifyCellChange(Vector vector) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        Object[] objectArray = new Object[n];
        for (int j = 0; j < n; ++j) {
            CellPlaceHolder cellPlaceHolder = (CellPlaceHolder)vector.elementAt(j);
            blArray[j] = cellPlaceHolder.isNew;
            objectArray[j] = cellPlaceHolder.cell;
        }
        GraphSelectionEvent graphSelectionEvent = new GraphSelectionEvent(this, objectArray, blArray);
        this.fireValueChanged(graphSelectionEvent);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultGraphSelectionModel defaultGraphSelectionModel = (DefaultGraphSelectionModel)super.clone();
        defaultGraphSelectionModel.changeSupport = null;
        if (this.selection != null) {
            defaultGraphSelectionModel.selection = new ArrayList(this.selection);
        }
        defaultGraphSelectionModel.listenerList = new EventListenerList();
        return defaultGraphSelectionModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class CellPlaceHolder {
        protected boolean isNew;
        protected Object cell;

        protected CellPlaceHolder(Object object2, boolean bl) {
            this.cell = object2;
            this.isNew = bl;
        }

        public Object getCell() {
            return this.cell;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setCell(Object object2) {
            this.cell = object2;
        }

        public void setNew(boolean bl) {
            this.isNew = bl;
        }
    }
}

