/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = null;
    protected boolean asksAllowsChildren = false;
    protected AttributeMap attributes = null;
    static /* synthetic */ Class class$org$jgraph$event$GraphModelListener;

    public DefaultGraphModel() {
        this(null, null);
    }

    public DefaultGraphModel(List list, AttributeMap attributeMap) {
        this.roots = list != null ? list : new ArrayList();
        this.attributes = attributeMap != null ? attributeMap : new AttributeMap();
    }

    public DefaultGraphModel(List list, AttributeMap attributeMap, ConnectionSet connectionSet) {
        this(list, attributeMap);
        this.handleConnectionSet(connectionSet);
    }

    public List getRoots() {
        return this.roots;
    }

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    public int getIndexOfRoot(Object object2) {
        return this.roots.indexOf(object2);
    }

    public boolean contains(Object object2) {
        Object object3 = null;
        while ((object3 = this.getParent(object2)) != null) {
            object2 = object3;
        }
        return this.roots.contains(object2);
    }

    public AttributeMap getAttributes(Object object2) {
        if (object2 instanceof GraphCell) {
            return ((GraphCell)object2).getAttributes();
        }
        if (object2 == null) {
            return this.attributes;
        }
        return null;
    }

    public Object getValue(Object object2) {
        if (object2 instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object2).getUserObject();
        }
        return null;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    public Object getSource(Object object2) {
        if (object2 instanceof Edge) {
            return ((Edge)object2).getSource();
        }
        return null;
    }

    public Object getTarget(Object object2) {
        if (object2 instanceof Edge) {
            return ((Edge)object2).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object object2, Object object3) {
        return true;
    }

    public boolean acceptsTarget(Object object2, Object object3) {
        return true;
    }

    public Iterator edges(Object object2) {
        if (object2 instanceof Port) {
            return ((Port)object2).edges();
        }
        return this.emptyIterator;
    }

    public boolean isEdge(Object object2) {
        return object2 instanceof Edge;
    }

    public boolean isPort(Object object2) {
        return object2 instanceof Port;
    }

    public ConnectionSet getConnectionSet() {
        return ConnectionSet.create(this, DefaultGraphModel.getAll(this), false);
    }

    public Map cloneCells(Object[] objectArray) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        ArrayList arrayList = new ArrayList();
        for (int j = 0; j < objectArray.length; ++j) {
            hashtable.put(objectArray[j], this.cloneCell(objectArray[j]));
        }
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Port port;
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            Object k = entry.getKey();
            Object object2 = this.getParent(k);
            if (object2 != null) {
                object2 = hashtable.get(object2);
            }
            if (object2 != null) {
                ((DefaultMutableTreeNode)object2).add((DefaultMutableTreeNode)v);
            }
            if (!(v instanceof Port) || (port = ((Port)v).getAnchor()) == null) continue;
            ((Port)v).setAnchor((Port)hashtable.get(port));
        }
        return hashtable;
    }

    protected void setParent(Object object2, Object object3) {
        if (object2 instanceof DefaultMutableTreeNode && object3 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object3;
            defaultMutableTreeNode.add((DefaultMutableTreeNode)object2);
        }
    }

    protected Object cloneCell(Object object2) {
        if (object2 instanceof DefaultGraphCell) {
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object2;
            DefaultGraphCell defaultGraphCell2 = (DefaultGraphCell)defaultGraphCell.clone();
            defaultGraphCell2.setUserObject(this.cloneUserObject(defaultGraphCell.getUserObject()));
            return defaultGraphCell2;
        }
        return object2;
    }

    protected Object cloneUserObject(Object object2) {
        return object2;
    }

    public Object getParent(Object object2) {
        if (object2 != null && object2 instanceof TreeNode) {
            return ((TreeNode)object2).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object object2, Object object3) {
        if (object2 == null || object3 == null) {
            return -1;
        }
        return ((TreeNode)object2).getIndex((TreeNode)object3);
    }

    public Object getChild(Object object2, int n) {
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getChildAt(n);
        }
        return null;
    }

    public int getChildCount(Object object2) {
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object2) {
        if (this.asksAllowsChildren && object2 instanceof TreeNode) {
            return !((TreeNode)object2).getAllowsChildren();
        }
        return ((TreeNode)object2).isLeaf();
    }

    public void insert(Object[] objectArray, Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createEdit(objectArray, null, map2, connectionSet, parentMap, undoableEditArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            if (undoableEditArray != null) {
                for (int j = 0; j < undoableEditArray.length; ++j) {
                    if (!(undoableEditArray[j] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                    ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[j]).execute();
                }
            }
            this.postEdit(graphModelEdit);
        }
    }

    public void remove(Object[] objectArray) {
        GraphModelEdit graphModelEdit = this.createRemoveEdit(objectArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            this.postEdit(graphModelEdit);
        }
    }

    public void edit(Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        this.edit(null, null, map2, connectionSet, parentMap, undoableEditArray);
    }

    public void edit(Object[] objectArray, Object[] objectArray2, Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (!(objectArray != null && objectArray.length != 0 || objectArray2 != null && objectArray2.length != 0 || map2 != null && !map2.isEmpty() || connectionSet != null && !connectionSet.isEmpty() || parentMap != null || undoableEditArray == null || undoableEditArray.length != 1)) {
            if (undoableEditArray[0] instanceof GraphLayoutCache.GraphLayoutCacheEdit) {
                ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[0]).execute();
            }
            this.postEdit(undoableEditArray[0]);
        } else {
            GraphModelEdit graphModelEdit = this.createEdit(objectArray, objectArray2, map2, connectionSet, parentMap, undoableEditArray);
            if (graphModelEdit != null) {
                graphModelEdit.execute();
                if (undoableEditArray != null) {
                    for (int j = 0; j < undoableEditArray.length; ++j) {
                        if (!(undoableEditArray[j] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                        ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[j]).execute();
                    }
                }
                this.postEdit(graphModelEdit);
            }
        }
    }

    public void toBack(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -2);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    public void toFront(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -1);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] objectArray, int n) {
        return new GraphModelLayerEdit(objectArray, n);
    }

    protected GraphModelEdit createRemoveEdit(Object[] objectArray) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create(this, objectArray, true);
        GraphModelEdit graphModelEdit = this.createEdit(null, objectArray, null, connectionSet, parentMap = ParentMap.create(this, objectArray, true, false), null);
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map2, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = new GraphModelEdit(objectArray, objectArray2, map2, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                for (int j = 0; j < undoableEditArray.length; ++j) {
                    graphModelEdit.addEdit(undoableEditArray[j]);
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected Object[] handleInsert(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (this.getParent(objectArray[j]) != null) continue;
                this.roots.add(objectArray[j]);
            }
            objectArray2 = DefaultGraphModel.getDescendants(this, objectArray).toArray();
        }
        return objectArray2;
    }

    protected Object[] handleRemove(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (this.getParent(objectArray[j]) != null || !this.roots.remove(objectArray[j])) continue;
                arrayList.add(objectArray[j]);
            }
        }
        return arrayList.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap parentMap2 = new ParentMap();
            Iterator iterator = parentMap.entries();
            while (iterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                Object object2 = entry.getChild();
                Object object3 = entry.getParent();
                parentMap2.addEntry(object2, this.getParent(object2));
                if (object3 == null) {
                    if (object2 instanceof MutableTreeNode) {
                        ((MutableTreeNode)object2).removeFromParent();
                    }
                } else if (object3 instanceof DefaultMutableTreeNode && object2 instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)object3).add((MutableTreeNode)object2);
                }
                boolean bl = this.roots.contains(object2);
                if (object3 == null && !bl) {
                    this.roots.add(object2);
                    continue;
                }
                if (object3 == null || !bl) continue;
                this.roots.remove(object2);
            }
            return parentMap2;
        }
        return null;
    }

    protected Map handleAttributes(Map map2) {
        if (map2 != null) {
            Hashtable hashtable = new Hashtable(map2.size());
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Map map3 = (Map)entry.getValue();
                Hashtable hashtable2 = null;
                AttributeMap attributeMap = this.getAttributes(k);
                if (attributeMap != null) {
                    hashtable2 = attributeMap.applyMap(map3);
                    hashtable.put(k, (AttributeMap)hashtable2);
                } else {
                    hashtable2 = new Hashtable(2);
                }
                if ((v = map3.get("value")) == null) continue;
                Object object2 = this.valueForCellChanged(k, v);
                if (object2 != null) {
                    GraphConstants.setValue(hashtable2, object2);
                    continue;
                }
                GraphConstants.setRemoveAttributes(hashtable2, new Object[]{"value"});
            }
            return hashtable;
        }
        return null;
    }

    public Object valueForCellChanged(Object object2, Object object3) {
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            Object object4 = defaultMutableTreeNode.getUserObject();
            defaultMutableTreeNode.setUserObject(object3);
            return object4;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet connectionSet) {
        if (connectionSet != null) {
            ConnectionSet connectionSet2 = new ConnectionSet();
            Iterator iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                ConnectionSet.Connection connection = (ConnectionSet.Connection)iterator.next();
                Object object2 = connection.getEdge();
                if (connection.isSource()) {
                    connectionSet2.connect(object2, this.getSource(object2), true);
                } else {
                    connectionSet2.connect(object2, this.getTarget(object2), false);
                }
                this.handleConnection(connection, false);
            }
            iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                this.handleConnection((ConnectionSet.Connection)iterator.next(), true);
            }
            return connectionSet2;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection connection, boolean bl) {
        Object object2 = connection.getEdge();
        Object object3 = bl ? connection.getPort() : (connection.isSource() ? this.getSource(object2) : this.getTarget(object2));
        this.connect(object2, object3, connection.isSource(), bl);
    }

    protected void connect(Object object2, Object object3, boolean bl, boolean bl2) {
        if (object3 instanceof Port) {
            if (bl2) {
                ((Port)object3).addEdge(object2);
            } else if (bl ? this.getTarget(object2) != object3 : this.getSource(object2) != object3) {
                ((Port)object3).removeEdge(object2);
            }
        }
        if (!bl2) {
            object3 = null;
        }
        if (object2 instanceof Edge) {
            if (bl) {
                ((Edge)object2).setSource(object3);
            } else {
                ((Edge)object2).setTarget(object3);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.add(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void removeGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void cellsChanged(final Object[] objectArray) {
        if (objectArray != null) {
            this.fireGraphChanged(this, new GraphModelEvent.GraphModelChange(){

                public Object[] getInserted() {
                    return null;
                }

                public Object[] getRemoved() {
                    return null;
                }

                public Map getPreviousAttributes() {
                    return null;
                }

                public ConnectionSet getConnectionSet() {
                    return null;
                }

                public ConnectionSet getPreviousConnectionSet() {
                    return null;
                }

                public ParentMap getParentMap() {
                    return null;
                }

                public ParentMap getPreviousParentMap() {
                    return null;
                }

                public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
                }

                public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
                    return null;
                }

                public Object getSource() {
                    return this;
                }

                public Object[] getChanged() {
                    return objectArray;
                }

                public Map getAttributes() {
                    return null;
                }

                public Object[] getContext() {
                    return null;
                }
            });
        }
    }

    protected void fireGraphChanged(Object object2, GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphModelEvent graphModelEvent = null;
        for (int j = objectArray.length - 2; j >= 0; j -= 2) {
            if (objectArray[j] != (class$org$jgraph$event$GraphModelListener == null ? DefaultGraphModel.class$("org.jgraph.event.GraphModelListener") : class$org$jgraph$event$GraphModelListener)) continue;
            if (graphModelEvent == null) {
                graphModelEvent = new GraphModelEvent(object2, graphModelChange);
            }
            ((GraphModelListener)objectArray[j + 1]).graphChanged(graphModelEvent);
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener);
    }

    public static Object cloneCell(GraphModel graphModel, Object object2) {
        Map map2 = graphModel.cloneCells(DefaultGraphModel.getDescendants(graphModel, new Object[]{object2}).toArray());
        return map2.get(object2);
    }

    public static Object[] cloneCell(GraphModel graphModel, Object[] objectArray) {
        Map map2 = graphModel.cloneCells(DefaultGraphModel.getDescendants(graphModel, objectArray).toArray());
        for (int j = 0; j < objectArray.length; ++j) {
            objectArray[j] = map2.get(objectArray[j]);
        }
        return objectArray;
    }

    public static void setSourcePort(GraphModel graphModel, Object object2, Object object3) {
        graphModel.edit(null, new ConnectionSet(object2, object3, true), null, null);
    }

    public static void setTargetPort(GraphModel graphModel, Object object2, Object object3) {
        graphModel.edit(null, new ConnectionSet(object2, object3, false), null, null);
    }

    public static Object getSourceVertex(GraphModel graphModel, Object object2) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getSource(object2));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel graphModel, Object object2) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getTarget(object2));
        }
        return null;
    }

    public static Object getUserObject(Object object2) {
        if (object2 instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object2).getUserObject();
        }
        return null;
    }

    public static boolean isGroup(GraphModel graphModel, Object object2) {
        for (int j = 0; j < graphModel.getChildCount(object2); ++j) {
            if (graphModel.isPort(graphModel.getChild(object2, j))) continue;
            return true;
        }
        return false;
    }

    public static Object[] getAll(GraphModel graphModel) {
        return DefaultGraphModel.getDescendants(graphModel, DefaultGraphModel.getRoots(graphModel)).toArray();
    }

    public static Object[] getRoots(GraphModel graphModel) {
        Object[] objectArray = null;
        if (graphModel != null) {
            if (graphModel instanceof DefaultGraphModel) {
                objectArray = ((DefaultGraphModel)graphModel).getRoots().toArray();
            } else {
                objectArray = new Object[graphModel.getRootCount()];
                for (int j = 0; j < objectArray.length; ++j) {
                    objectArray[j] = graphModel.getRootAt(j);
                }
            }
        }
        return objectArray;
    }

    public static Object[] getRoots(GraphModel graphModel, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (graphModel.getParent(objectArray[j]) != null) continue;
                arrayList.add(objectArray[j]);
            }
        }
        return arrayList.toArray();
    }

    public static Object[] getTopmostCells(GraphModel graphModel, Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int j = 0; j < objectArray.length; ++j) {
            hashSet.add(objectArray[j]);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int j = 0; j < objectArray.length; ++j) {
            if (DefaultGraphModel.hasAncestorIn(graphModel, hashSet, objectArray[j])) continue;
            arrayList.add(objectArray[j]);
        }
        return arrayList.toArray();
    }

    public static boolean hasAncestorIn(GraphModel graphModel, Set set, Object object2) {
        Object object3 = graphModel.getParent(object2);
        while (object3 != null) {
            if (set.contains(object3)) {
                return true;
            }
            object3 = graphModel.getParent(object3);
        }
        return false;
    }

    public static List getDescendants(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int j = objectArray.length - 1; j >= 0; --j) {
                stack.add(objectArray[j]);
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                for (int j = graphModel.getChildCount(e2) - 1; j >= 0; --j) {
                    stack.add(graphModel.getChild(e2, j));
                }
                if (e2 == null) continue;
                linkedList.add(e2);
            }
            return linkedList;
        }
        return null;
    }

    public static Object[] order(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int j = 0; j < objectArray.length; ++j) {
                hashSet.add(objectArray[j]);
            }
            Stack<Object> stack = new Stack<Object>();
            for (int j = graphModel.getRootCount() - 1; j >= 0; --j) {
                stack.add(graphModel.getRootAt(j));
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                for (int j = graphModel.getChildCount(e2) - 1; j >= 0; --j) {
                    stack.add(graphModel.getChild(e2, j));
                }
                if (!hashSet.remove(e2)) continue;
                linkedList.add(e2);
            }
            return linkedList.toArray();
        }
        return null;
    }

    public static Set getEdges(GraphModel graphModel, Object[] objectArray) {
        HashSet hashSet = new HashSet();
        if (objectArray != null) {
            HashSet<Object> hashSet2 = new HashSet<Object>(objectArray.length * 2 + 8, 0.75f);
            for (int j = 0; j < objectArray.length; ++j) {
                hashSet2.add(objectArray[j]);
            }
            hashSet2.addAll(DefaultGraphModel.getDescendants(graphModel, objectArray));
            if (hashSet2 != null) {
                Iterator iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2 = graphModel.edges(iterator.next());
                    while (iterator2.hasNext()) {
                        hashSet.add(iterator2.next());
                    }
                }
                for (int j = 0; j < objectArray.length; ++j) {
                    hashSet.remove(objectArray[j]);
                }
            }
        }
        return hashSet;
    }

    public static Object getOpposite(GraphModel graphModel, Object object2, Object object3) {
        Object object4;
        boolean bl = graphModel.isPort(object3);
        Object object5 = object4 = bl ? graphModel.getSource(object2) : DefaultGraphModel.getSourceVertex(graphModel, object2);
        if (object3 == object4) {
            return bl ? graphModel.getTarget(object2) : DefaultGraphModel.getTargetVertex(graphModel, object2);
        }
        return object4;
    }

    public static boolean containsEdgeBetween(GraphModel graphModel, Object object2, Object object3) {
        Object[] objectArray = DefaultGraphModel.getEdgesBetween(graphModel, object2, object3, false);
        return objectArray != null && objectArray.length > 0;
    }

    public static Object[] getEdgesBetween(GraphModel graphModel, Object object2, Object object3, boolean bl) {
        boolean bl2 = graphModel.isPort(object2);
        boolean bl3 = graphModel.isPort(object3);
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges(graphModel, new Object[]{object2});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object4;
            Object e2 = iterator.next();
            Object object5 = bl2 ? graphModel.getSource(e2) : DefaultGraphModel.getSourceVertex(graphModel, e2);
            Object object6 = object4 = bl3 ? graphModel.getTarget(e2) : DefaultGraphModel.getTargetVertex(graphModel, e2);
            if ((object5 != object2 || object4 != object3) && (bl || object5 != object3 || object4 != object2)) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    public static Object[] getOutgoingEdges(GraphModel graphModel, Object object2) {
        return DefaultGraphModel.getEdges(graphModel, object2, false);
    }

    public static Object[] getIncomingEdges(GraphModel graphModel, Object object2) {
        return DefaultGraphModel.getEdges(graphModel, object2, true);
    }

    public static Object[] getEdges(GraphModel graphModel, Object object2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges(graphModel, new Object[]{object2});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object3 = bl ? graphModel.getTarget(e2) : graphModel.getSource(e2);
            Object object4 = graphModel.getParent(object3);
            if (object3 != object2 && object4 != object2) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphModelChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;
        protected Object[] changed;

        public GraphModelLayerEdit(Object[] objectArray, int n) {
            this.cells = objectArray;
            this.layer = n;
            this.next = new int[objectArray.length];
            this.prev = new int[objectArray.length];
            this.updateNext();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int j = 0; j < objectArray.length; ++j) {
                Object object2 = DefaultGraphModel.this.getParent(objectArray[j]);
                if (object2 == null) {
                    object2 = objectArray[j];
                }
                hashSet.add(object2);
            }
            this.changed = hashSet.toArray();
        }

        protected void updateNext() {
            for (int j = 0; j < this.next.length; ++j) {
                this.next[j] = this.layer;
            }
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public Object[] getContext() {
            return null;
        }

        public Map getAttributes() {
            return null;
        }

        public Map getPreviousAttributes() {
            return null;
        }

        public ConnectionSet getConnectionSet() {
            return null;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        public ParentMap getParentMap() {
            return null;
        }

        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit undoableEdit) {
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return null;
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            for (int j = 0; j < this.cells.length; ++j) {
                List list = this.getParentList(this.cells[j]);
                if (list == null) continue;
                this.prev[j] = list.indexOf(this.cells[j]);
                if (this.prev[j] < 0) continue;
                list.remove(this.prev[j]);
                int n = this.next[j];
                if (n == -1) {
                    n = list.size();
                } else if (n == -2) {
                    n = 0;
                }
                list.add(n, this.cells[j]);
                this.next[j] = this.prev[j];
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object object2) {
            List list = null;
            if (object2 instanceof DefaultMutableTreeNode) {
                TreeNode treeNode = ((DefaultMutableTreeNode)object2).getParent();
                list = treeNode instanceof DefaultGraphCell ? ((DefaultGraphCell)treeNode).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] objectArray, Object[] objectArray2, Map map2, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = objectArray;
            this.remove = objectArray2;
            this.connectionSet = connectionSet;
            this.attributes = map2;
            this.parentMap = parentMap;
            this.previousAttributes = null;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable hashtable = new Hashtable();
                Iterator iterator = parentMap.entries();
                while (iterator.hasNext()) {
                    Object object2;
                    Object object3;
                    ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                    Object object4 = entry.getChild();
                    if (DefaultGraphModel.this.isPort(object4) || (object3 = DefaultGraphModel.this.getParent(object4)) == (object2 = entry.getParent())) continue;
                    this.changeChildCount(hashtable, object3, -1);
                    this.changeChildCount(hashtable, object2, 1);
                }
                this.handleEmptyGroups(this.filterParents(hashtable, 0));
            }
        }

        public Object[] filterParents(Map map2, int n) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != n) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList.toArray();
        }

        protected void changeChildCount(Map map2, Object object2, int n) {
            if (object2 != null) {
                Integer n2 = (Integer)map2.get(object2);
                if (n2 == null) {
                    n2 = new Integer(DefaultGraphModel.this.getChildCount(object2));
                }
                int n3 = n2 + n;
                map2.put(object2, new Integer(n3));
            }
        }

        protected void handleEmptyGroups(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] objectArray2 = new Object[this.remove.length + objectArray.length];
                System.arraycopy(this.remove, 0, objectArray2, 0, this.remove.length);
                System.arraycopy(objectArray, 0, objectArray2, this.remove.length, objectArray.length);
                this.remove = objectArray2;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet hashSet = new HashSet();
            if (this.attributes != null) {
                hashSet.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                hashSet.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int j = 0; j < this.remove.length; ++j) {
                    hashSet.remove(this.remove[j]);
                }
            }
            this.changed = hashSet.toArray();
            Set set = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = set.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultGraphModel.this.handleAttributes(this.attributes);
            this.changed = hashSet.toArray();
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
            if (graphLayoutCache != null && cellViewArray != null) {
                this.cellViews.put(graphLayoutCache, cellViewArray);
            }
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return (CellView[])this.cellViews.get(graphLayoutCache);
        }

        public String toString() {
            int n;
            String string = new String();
            if (this.inserted != null) {
                string = string + "Inserted:\n";
                for (n = 0; n < this.inserted.length; ++n) {
                    string = string + "  " + this.inserted[n] + "\n";
                }
            } else {
                string = string + "None inserted\n";
            }
            if (this.removed != null) {
                string = string + "Removed:\n";
                for (n = 0; n < this.removed.length; ++n) {
                    string = string + "  " + this.removed[n] + "\n";
                }
            } else {
                string = string + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                string = string + "Changed:\n";
                for (n = 0; n < this.changed.length; ++n) {
                    string = string + "  " + this.changed[n] + "\n";
                }
            } else {
                string = string + "None changed\n";
            }
            string = this.parentMap != null ? string + this.parentMap.toString() : string + "No parent map\n";
            return string;
        }
    }
}

