/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.FontUIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultRealEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCellEditor
implements ActionListener,
GraphCellEditor,
GraphSelectionListener,
Serializable {
    protected GraphCellEditor realEditor;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offsetX;
    protected transient int offsetY;
    protected transient JGraph graph;
    protected transient Object lastCell;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultGraphCellEditor() {
        this(null);
    }

    public DefaultGraphCellEditor(GraphCellEditor graphCellEditor) {
        this.realEditor = graphCellEditor;
        if (this.realEditor == null) {
            this.realEditor = this.createGraphCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font2) {
        this.font = font2;
    }

    public Font getFont() {
        return this.font;
    }

    public Component getGraphCellEditorComponent(JGraph jGraph, Object object2, boolean bl) {
        this.setGraph(jGraph);
        this.editingComponent = this.realEditor.getGraphCellEditorComponent(jGraph, object2, bl);
        this.determineOffset(jGraph, object2, bl);
        this.canEdit = this.lastCell != null && object2 != null && this.lastCell.equals(object2);
        CellView cellView = jGraph.getGraphLayoutCache().getMapping(object2, false);
        if (cellView != null) {
            this.setFont(GraphConstants.getFont(cellView.getAllAttributes()));
        }
        this.editingContainer.setFont(this.font);
        return this.editingContainer;
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (!this.realEditor.isCellEditable(eventObject)) {
            return false;
        }
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        }
        if (bl) {
            this.prepareForEditing();
        }
        return bl;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.realEditor.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editingComponent != null) {
                this.editingContainer.remove(this.editingComponent);
            }
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        if (this.graph != null) {
            this.lastCell = this.graph.getSelectionCount() == 1 ? this.graph.getSelectionCell() : null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.graph != null) {
            this.graph.startEditingAtCell(this.lastCell);
        }
    }

    protected void setGraph(JGraph jGraph) {
        if (this.graph != jGraph) {
            if (this.graph != null) {
                this.graph.removeGraphSelectionListener(this);
            }
            this.graph = jGraph;
            if (this.graph != null) {
                this.graph.addGraphSelectionListener(this);
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(double d2, double d3) {
        return true;
    }

    protected void determineOffset(JGraph jGraph, Object object2, boolean bl) {
        this.editingIcon = null;
        this.offsetX = jGraph.getHandleSize();
        this.offsetY = jGraph.getHandleSize();
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected GraphCellEditor createGraphCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultRealEditor defaultRealEditor = new DefaultRealEditor(new DefaultTextField(border)){

            public boolean shouldSelectCell(EventObject eventObject) {
                boolean bl = super.shouldSelectCell(eventObject);
                this.getComponent().requestFocus();
                return bl;
            }
        };
        defaultRealEditor.setClickCountToStart(1);
        return defaultRealEditor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.realEditor instanceof Serializable) {
            vector.addElement("realEditor");
            vector.addElement(this.realEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("realEditor")) {
            this.realEditor = (GraphCellEditor)vector.elementAt(++n);
            ++n;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        public void paint(Graphics graphics) {
            Color color;
            Dimension dimension = this.getSize();
            if (DefaultGraphCellEditor.this.editingIcon != null) {
                int n = 0;
                int n2 = 0;
                DefaultGraphCellEditor.this.editingIcon.paintIcon(this, graphics, n2, n);
            }
            if ((color = DefaultGraphCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            super.paint(graphics);
        }

        public void doLayout() {
            if (DefaultGraphCellEditor.this.editingComponent != null) {
                Dimension dimension = this.getSize();
                int n = (int)DefaultGraphCellEditor.this.editingComponent.getPreferredSize().getHeight();
                int n2 = 45;
                int n3 = (int)DefaultGraphCellEditor.this.editingComponent.getPreferredSize().getWidth() + 5;
                int n4 = (int)DefaultGraphCellEditor.this.editingComponent.getMaximumSize().getWidth();
                n3 = DefaultGraphCellEditor.this.editingContainer.getParent() != null && n4 > DefaultGraphCellEditor.this.editingContainer.getParent().getWidth() ? dimension.width - DefaultGraphCellEditor.this.offsetX : Math.max(n2, Math.min(n3, n4));
                DefaultGraphCellEditor.this.editingComponent.setBounds(DefaultGraphCellEditor.this.offsetX, DefaultGraphCellEditor.this.offsetY, n3, n);
            }
        }

        public Dimension getPreferredSize() {
            if (DefaultGraphCellEditor.this.editingComponent != null) {
                Dimension dimension = DefaultGraphCellEditor.this.editingComponent.getPreferredSize();
                dimension.width += DefaultGraphCellEditor.this.offsetX + 2;
                dimension.height += DefaultGraphCellEditor.this.offsetY + 2;
                int n = 50;
                if (DefaultGraphCellEditor.this.editingIcon != null) {
                    n = Math.max(DefaultGraphCellEditor.this.editingIcon.getIconWidth(), n);
                }
                dimension.height = Math.max(dimension.height, 24);
                dimension.width = Math.max(dimension.width + 5, n);
                return dimension;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public Font getFont() {
            Container container;
            Font font2 = super.getFont();
            if (font2 instanceof FontUIResource && (container = this.getParent()) != null && container.getFont() != null) {
                font2 = container.getFont();
            }
            return font2;
        }
    }
}

