/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;

public class ConnectionSet
implements Serializable {
    protected Set connections = new HashSet();
    protected Set edges = new HashSet();

    public static ConnectionSet create(GraphModel graphModel, Object[] objectArray, boolean bl) {
        ConnectionSet connectionSet = new ConnectionSet();
        for (int j = 0; j < objectArray.length; ++j) {
            Object object2 = objectArray[j];
            if (graphModel.isEdge(object2)) {
                if (bl) {
                    connectionSet.disconnect(object2);
                } else {
                    connectionSet.connect(object2, graphModel.getSource(object2), graphModel.getTarget(object2));
                }
            }
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (graphModel.getSource(e2) == object2) {
                    ConnectionSet.connect(connectionSet, e2, object2, true, bl);
                    continue;
                }
                if (graphModel.getTarget(e2) != object2) continue;
                ConnectionSet.connect(connectionSet, e2, object2, false, bl);
            }
        }
        return connectionSet;
    }

    public ConnectionSet() {
    }

    public ConnectionSet(Object object2, Object object3, boolean bl) {
        this.connect(object2, object3, bl);
    }

    public ConnectionSet(Set set) {
        this.setConnections(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            this.edges.add(connection.getEdge());
        }
    }

    public ConnectionSet(Object object2, Object object3, Object object4) {
        this.connect(object2, object3, object4);
    }

    protected static void connect(ConnectionSet connectionSet, Object object2, Object object3, boolean bl, boolean bl2) {
        if (bl2) {
            connectionSet.disconnect(object2, bl);
        } else {
            connectionSet.connect(object2, object3, bl);
        }
    }

    public void addConnections(CellView[] cellViewArray) {
        for (int j = 0; j < cellViewArray.length; ++j) {
            if (!(cellViewArray[j] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)cellViewArray[j];
            Object object2 = edgeView.getCell();
            CellView cellView = edgeView.getSource();
            CellView cellView2 = edgeView.getTarget();
            Object object3 = null;
            if (cellView != null) {
                object3 = cellView.getCell();
            }
            Object object4 = null;
            if (cellView2 != null) {
                object4 = cellView2.getCell();
            }
            this.connect(object2, object3, object4);
        }
    }

    public void connect(Object object2, Object object3, Object object4) {
        this.connect(object2, object3, true);
        this.connect(object2, object4, false);
    }

    public void connect(Object object2, Object object3, boolean bl) {
        Connection connection = new Connection(object2, object3, bl);
        this.connections.remove(connection);
        this.connections.add(connection);
        this.edges.add(object2);
    }

    public void disconnect(Object object2) {
        this.disconnect(object2, true);
        this.disconnect(object2, false);
    }

    public void disconnect(Object object2, boolean bl) {
        this.connections.add(new Connection(object2, null, bl));
        this.edges.add(object2);
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public int size() {
        return this.connections.size();
    }

    public Iterator connections() {
        return this.connections.iterator();
    }

    public Set getChangedEdges() {
        return this.edges;
    }

    public Object getPort(Object object2, boolean bl) {
        if (this.edges.contains(object2)) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                if (connection.getEdge() != object2 || connection.isSource() != bl) continue;
                return connection.getPort();
            }
        }
        return null;
    }

    public ConnectionSet clone(Map map2) {
        ConnectionSet connectionSet = new ConnectionSet();
        Iterator iterator = this.connections();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            Object v = map2.get(connection.getEdge());
            Object object2 = connection.getPort();
            if (object2 != null) {
                object2 = map2.get(object2);
            }
            if (v != null && object2 != null) {
                connectionSet.connect(v, object2, connection.isSource());
                continue;
            }
            if (v == null) continue;
            connectionSet.connect(v, connection.getPort(), connection.isSource());
        }
        return connectionSet;
    }

    public Set getConnections() {
        return this.connections;
    }

    public Set getEdges() {
        return this.edges;
    }

    public void setConnections(Set set) {
        this.connections = set;
    }

    public void setEdges(Set set) {
        this.edges = set;
    }

    public static class Connection
    implements Serializable {
        protected Object edge;
        protected Object port;
        protected boolean isSource;

        public Connection() {
        }

        public Connection(Object object2, Object object3, boolean bl) {
            this.edge = object2;
            this.port = object3;
            this.isSource = bl;
        }

        public Object getEdge() {
            return this.edge;
        }

        public Object getPort() {
            return this.port;
        }

        public boolean isSource() {
            return this.isSource;
        }

        public boolean equals(Object object2) {
            if (object2 instanceof Connection) {
                Connection connection = (Connection)object2;
                return connection.getEdge().equals(this.edge) && connection.isSource() == this.isSource;
            }
            return false;
        }

        public int hashCode() {
            return this.edge.hashCode();
        }

        public void setEdge(Object object2) {
            this.edge = object2;
        }

        public void setSource(boolean bl) {
            this.isSource = bl;
        }

        public void setPort(Object object2) {
            this.port = object2;
        }
    }
}

