/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class AttributeMap
extends Hashtable
implements Cloneable {
    public static transient AttributeMap emptyAttributeMap = new AttributeMap(0){

        public Object clone() {
            return this;
        }
    };

    public AttributeMap() {
        super(8);
    }

    public AttributeMap(int n) {
        super(n);
    }

    public AttributeMap(int n, float f2) {
        super(n, f2);
    }

    public AttributeMap(Map map2) {
        super(map2);
    }

    public Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public Point2D createPoint(Point2D point2D) {
        if (point2D != null) {
            return this.createPoint(point2D.getX(), point2D.getY());
        }
        return null;
    }

    public Point2D createPoint(double d2, double d3) {
        return new SerializablePoint2D(d2, d3);
    }

    public Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public Rectangle2D createRect(double d2, double d3, double d4, double d5) {
        return new SerializableRectangle2D(d2, d3, d4, d5);
    }

    public Rectangle2D createRect(Point2D point2D) {
        return this.createRect(point2D, 0.0);
    }

    public Rectangle2D createRect(Point2D point2D, double d2) {
        if (point2D != null) {
            return this.createRect(point2D.getX(), point2D.getY(), d2, d2);
        }
        return null;
    }

    public Rectangle2D createRect(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            return this.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return null;
    }

    public Rectangle2D createRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.createRect(d2 - d6, d3 - d6, d4 + d6 + d7, d5 + d6 + d7);
    }

    public Rectangle2D createRect(Rectangle2D rectangle2D, double d2, double d3) {
        if (rectangle2D != null) {
            return this.createRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d2, d3);
        }
        return null;
    }

    public AttributeMap applyMap(Map map2) {
        AttributeMap attributeMap = new AttributeMap();
        if (map2 != null) {
            Iterator iterator;
            Object[] objectArray;
            if (GraphConstants.isRemoveAll(map2)) {
                attributeMap.putAll(this);
                this.clear();
            }
            if ((objectArray = GraphConstants.getRemoveAttributes(map2)) != null) {
                for (int j = 0; j < objectArray.length; ++j) {
                    iterator = this.remove(objectArray[j]);
                    if (iterator == null) continue;
                    attributeMap.put(objectArray[j], iterator);
                }
            }
            HashSet hashSet = new HashSet();
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (k.equals("removeAll") || k.equals("removeAttributes") || k.equals("value")) continue;
                Object object2 = this.applyValue(k, entry.getValue());
                if (object2 == null) {
                    hashSet.add(k);
                    continue;
                }
                attributeMap.put(k, object2);
            }
            if (!hashSet.isEmpty()) {
                GraphConstants.setRemoveAttributes(attributeMap, hashSet.toArray());
            }
        }
        return attributeMap;
    }

    public Object applyValue(Object object2, Object object3) {
        if (object3 instanceof Rectangle2D) {
            object3 = this.createRect((Rectangle2D)object3);
        }
        if (object3 instanceof Point2D) {
            object3 = this.createPoint((Point2D)object3);
        }
        if (object3 instanceof Point2D[]) {
            object3 = this.clonePoints((Point2D[])object3);
        }
        if (object3 instanceof List) {
            object3 = this.clonePoints((List)object3);
        }
        return this.put(object2, object3);
    }

    public Point2D[] clonePoints(Point2D[] point2DArray) {
        List list = this.clonePoints(point2DArray, true);
        Point2D[] point2DArray2 = new Point2D[list.size()];
        list.toArray(point2DArray2);
        return point2DArray2;
    }

    public List clonePoints(List list) {
        return this.clonePoints(list.toArray(), true);
    }

    public List clonePoints(Object[] objectArray, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int j = 0; j < objectArray.length; ++j) {
            Object object2 = objectArray[j];
            if (object2 instanceof PortView && bl) {
                object2 = this.createPoint(((PortView)object2).getLocation());
            } else if (object2 instanceof Point2D) {
                object2 = this.createPoint((Point2D)object2);
            }
            arrayList.add(object2);
        }
        return arrayList;
    }

    public static void translate(Collection collection, double d2, double d3) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof AttributeMap)) continue;
            ((AttributeMap)e2).translate(d2, d3);
        }
    }

    public void translate(double d2, double d3) {
        if (GraphConstants.isMoveable(this)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds(this);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis(this);
                if (n == 1) {
                    d3 = 0.0;
                } else if (n == 2) {
                    d2 = 0.0;
                }
                rectangle2D.setFrame(rectangle2D.getX() + d2, rectangle2D.getY() + d3, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            if ((list = GraphConstants.getPoints(this)) != null) {
                for (int j = 0; j < list.size(); ++j) {
                    Object e2 = list.get(j);
                    if (!(e2 instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e2;
                    point2D.setLocation(point2D.getX() + d2, point2D.getY() + d3);
                }
            }
        }
    }

    public void scale(double d2, double d3, Point2D point2D) {
        Object object2;
        Object object3;
        Rectangle2D rectangle2D = GraphConstants.getBounds(this);
        if (rectangle2D != null) {
            int n;
            object3 = this.createPoint(rectangle2D.getX(), rectangle2D.getY());
            object2 = (Point2D)((Point2D)object3).clone();
            ((Point2D)object3).setLocation(point2D.getX() + (double)Math.round((((Point2D)object3).getX() - point2D.getX()) * d2), point2D.getY() + (double)Math.round((((Point2D)object3).getY() - point2D.getY()) * d3));
            if (!((Point2D)object3).equals(object2)) {
                this.translate(((Point2D)object3).getX() - ((Point2D)object2).getX(), ((Point2D)object3).getY() - ((Point2D)object2).getY());
            }
            if ((n = GraphConstants.getSizeableAxis(this)) == 1) {
                d3 = 1.0;
            } else if (n == 2) {
                d2 = 1.0;
            }
            double d4 = Math.max(1L, Math.round(rectangle2D.getWidth() * d2));
            double d5 = Math.max(1L, Math.round(rectangle2D.getHeight() * d3));
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), d4, d5);
        }
        if ((object3 = GraphConstants.getPoints(this)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Object e2 = object2.next();
                if (!(e2 instanceof Point2D)) continue;
                Point2D point2D2 = (Point2D)e2;
                Point2D point2D3 = (Point2D)point2D2.clone();
                point2D3.setLocation(point2D.getX() + (double)Math.round((point2D3.getX() - point2D.getX()) * d2), point2D.getY() + (double)Math.round((point2D3.getY() - point2D.getY()) * d3));
                point2D2.setLocation(point2D3);
            }
        }
    }

    public Map diff(Map map2) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = this.get(k);
            if (v2 != null && v2.equals(v)) continue;
            hashtable.put(k, v);
        }
        return hashtable;
    }

    public Object clone() {
        return this.cloneEntries((AttributeMap)super.clone());
    }

    public AttributeMap cloneEntries(AttributeMap attributeMap) {
        Point2D point2D;
        Point2D[] point2DArray;
        List list;
        Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
        if (rectangle2D != null) {
            GraphConstants.setBounds(attributeMap, (Rectangle2D)rectangle2D.clone());
        }
        if ((list = GraphConstants.getPoints(attributeMap)) != null) {
            GraphConstants.setPoints(attributeMap, this.clonePoints(list));
        }
        if ((point2DArray = GraphConstants.getExtraLabelPositions(attributeMap)) != null) {
            GraphConstants.setExtraLabelPositions(attributeMap, this.clonePoints(point2DArray));
        }
        if ((point2D = GraphConstants.getLabelPosition(attributeMap)) != null) {
            GraphConstants.setLabelPosition(attributeMap, (Point2D)point2D.clone());
        }
        return attributeMap;
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double d2, double d3, double d4, double d5) {
            super(d2, d3, d4, d5);
        }

        public void setX(double d2) {
            this.setFrame(d2, this.getY(), this.getWidth(), this.getHeight());
        }

        public void setY(double d2) {
            this.setFrame(this.getX(), d2, this.getWidth(), this.getHeight());
        }

        public void setWidth(double d2) {
            this.setFrame(this.getX(), this.getY(), d2, this.getHeight());
        }

        public void setHeight(double d2) {
            this.setFrame(this.getX(), this.getY(), this.getWidth(), d2);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
            objectOutputStream.writeObject(new Double(this.getWidth()));
            objectOutputStream.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d2 = (Double)objectInputStream.readObject();
            Double d3 = (Double)objectInputStream.readObject();
            Double d4 = (Double)objectInputStream.readObject();
            Double d5 = (Double)objectInputStream.readObject();
            this.setFrame(d2, d3, d4, d5);
        }
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double d2, double d3) {
            super(d2, d3);
        }

        public void setX(double d2) {
            this.setLocation(d2, this.getY());
        }

        public void setY(double d2) {
            this.setLocation(this.getX(), d2);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new Double(this.getX()));
            objectOutputStream.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Double d2 = (Double)objectInputStream.readObject();
            Double d3 = (Double)objectInputStream.readObject();
            this.setLocation(d2, d3);
        }
    }
}

