/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static transient GraphCellEditor cellEditor = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList(0);
    protected AttributeMap allAttributes;
    protected AttributeMap attributes = this.allAttributes = this.createAttributeMap();
    protected transient Rectangle2D groupBounds = VertexView.defaultBounds;

    public AbstractCellView() {
    }

    public AbstractCellView(Object object2) {
        this.setCell(object2);
    }

    protected AttributeMap createAttributeMap() {
        return new AttributeMap();
    }

    public Object getCell() {
        return this.cell;
    }

    public void setCell(Object object2) {
        this.cell = object2;
    }

    public void refresh(GraphModel graphModel, CellMapper cellMapper, boolean bl) {
        Object object2;
        this.allAttributes = this.getCellAttributes(graphModel);
        if (cellMapper != null && graphModel != null) {
            Object object3 = graphModel.getParent(this.cell);
            object2 = cellMapper.getMapping(object3, bl);
            if (object2 != this.parent) {
                this.removeFromParent();
            }
            this.parent = object2;
        }
        this.update();
        this.childViews.clear();
        for (int j = 0; j < graphModel.getChildCount(this.cell); ++j) {
            object2 = graphModel.getChild(this.cell, j);
            CellView cellView = cellMapper.getMapping(object2, bl);
            if (graphModel.isPort(object2) || cellView == null) continue;
            this.childViews.add(cellView);
        }
    }

    protected AttributeMap getCellAttributes(GraphModel graphModel) {
        return (AttributeMap)graphModel.getAttributes(this.cell).clone();
    }

    public void update() {
        this.mergeAttributes();
        this.groupBounds = null;
        this.childUpdated();
    }

    protected void mergeAttributes() {
        this.allAttributes.putAll(this.attributes);
    }

    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
        this.groupBounds = null;
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int j = 0; j < cellViewArray.length; ++j) {
            stack.add(cellViewArray[j]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (int j = 0; j < cellViewArray3.length; ++j) {
                stack.add(cellViewArray3[j]);
            }
            arrayList.add(cellViewArray2);
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeMap attributeMap) {
        this.attributes = attributeMap;
    }

    public AttributeMap getAllAttributes() {
        return this.allAttributes;
    }

    public Map changeAttributes(Map map2) {
        if (map2 != null) {
            AttributeMap attributeMap = this.attributes.applyMap(map2);
            this.update();
            return attributeMap;
        }
        return null;
    }

    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return null;
    }

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D.Double double_ = null;
            for (int j = 0; j < cellViewArray.length; ++j) {
                Rectangle2D rectangle2D;
                if (cellViewArray[j] == null || (rectangle2D = cellViewArray[j].getBounds()) == null) continue;
                if (double_ == null) {
                    double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    continue;
                }
                Rectangle2D.union(double_, rectangle2D, double_);
            }
            return double_;
        }
        return null;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Double();
        }
        Point2D.Double double_ = new Point2D.Double(rectangle2D2.getX(), rectangle2D2.getY());
        Point2D.Double double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (GraphConstants.isMoveable(this.getAllAttributes()) && !double_2.equals(double_)) {
            this.translate(((Point2D)double_2).getX() - ((Point2D)double_).getX(), ((Point2D)double_2).getY() - ((Point2D)double_).getY());
        } else {
            double_3.setFrame(((RectangularShape)double_3).getX(), ((RectangularShape)double_3).getY(), rectangle2D.getWidth() - ((Point2D)double_2).getX() + ((Point2D)double_).getX(), rectangle2D.getHeight() - ((Point2D)double_2).getY() + ((Point2D)double_).getY());
        }
        double d2 = ((RectangularShape)double_3).getWidth();
        double d3 = ((RectangularShape)double_3).getHeight();
        double d4 = rectangle2D2.getWidth();
        double d5 = rectangle2D2.getHeight();
        if ((d2 != d4 || d3 != d5) && d4 > 0.0 && d5 > 0.0) {
            this.scale(d2 / d4, d3 / d5, double_2);
        }
    }

    protected void updateGroupBounds() {
        CellView[] cellViewArray = this.getChildViews();
        LinkedList<CellView> linkedList = new LinkedList<CellView>();
        for (int j = 0; j < cellViewArray.length; ++j) {
            if (!this.includeInGroupBounds(cellViewArray[j])) continue;
            linkedList.add(cellViewArray[j]);
        }
        cellViewArray = new CellView[linkedList.size()];
        linkedList.toArray(cellViewArray);
        Rectangle2D rectangle2D = AbstractCellView.getBounds(cellViewArray);
        int n = GraphConstants.getInset(this.getAllAttributes());
        if (rectangle2D != null) {
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
        }
        this.groupBounds = rectangle2D;
    }

    protected boolean includeInGroupBounds(CellView cellView) {
        if (cellView instanceof EdgeView && this.getCell() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getCell();
            EdgeView edgeView = (EdgeView)cellView;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                Object object2;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)edgeView.getCell();
                Object object3 = null;
                if (edgeView.getSource() != null && edgeView.getSource().getParentView() != null) {
                    object3 = edgeView.getSource().getParentView().getCell();
                } else if (edgeView.getSourceParentView() != null) {
                    object3 = edgeView.getSourceParentView().getCell();
                }
                if (object3 instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)object3)).isNodeDescendant(defaultMutableTreeNode3)) {
                    return false;
                }
                object2 = null;
                if (edgeView.getTarget() != null && edgeView.getTarget().getParentView() != null) {
                    object2 = edgeView.getTarget().getParentView().getCell();
                } else if (edgeView.getTargetParentView() != null) {
                    object2 = edgeView.getTargetParentView().getCell();
                }
                if (object2 instanceof DefaultMutableTreeNode && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)object2).isNodeDescendant(defaultMutableTreeNode3)) {
                    return false;
                }
            }
        }
        return true;
    }

    protected void translate(double d2, double d3) {
        if (this.isLeaf()) {
            this.getAllAttributes().translate(d2, d3);
        } else {
            int n = GraphConstants.getMoveableAxis(this.getAllAttributes());
            if (n == 1) {
                d3 = 0.0;
            } else if (n == 2) {
                d2 = 0.0;
            }
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof AbstractCellView)) continue;
                AbstractCellView abstractCellView = (AbstractCellView)e2;
                abstractCellView.translate(d2, d3);
            }
        }
    }

    protected void scale(double d2, double d3, Point2D point2D) {
        if (this.isLeaf()) {
            this.getAttributes().scale(d2, d3, point2D);
        } else {
            int n = GraphConstants.getSizeableAxis(this.getAllAttributes());
            if (n == 1) {
                d3 = 1.0;
            } else if (n == 2) {
                d2 = 1.0;
            }
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                AbstractCellView abstractCellView;
                AttributeMap attributeMap;
                Object e2 = iterator.next();
                if (!(e2 instanceof AbstractCellView) || !GraphConstants.isSizeable(attributeMap = (abstractCellView = (AbstractCellView)e2).getAttributes()) && !GraphConstants.isAutoSize(attributeMap)) continue;
                abstractCellView.scale(d2, d3, point2D);
            }
        }
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        if (this.isLeaf() || GraphConstants.isGroupOpaque(this.getAllAttributes())) {
            Rectangle2D rectangle2D2 = this.getBounds();
            if (rectangle2D2 != null) {
                return rectangle2D2.intersects(rectangle2D);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(jGraph, rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph jGraph, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(jGraph, this, bl, bl2, bl3);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }

    public static Point2D getCenterPoint(CellView cellView) {
        Rectangle2D rectangle2D = cellView.getBounds();
        if (rectangle2D != null) {
            return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        return null;
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        return AbstractCellView.getCenterPoint(this);
    }

    static {
        try {
            cellEditor = new DefaultGraphCellEditor();
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

