/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AbstractObjectList;
import org.jfree.util.PaintUtilities;

public class PaintList
extends AbstractObjectList {
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof PaintList) {
            PaintList that = (PaintList)obj;
            int listSize = this.size();
            int i2 = 0;
            while (i2 < listSize) {
                if (!PaintUtilities.equal(this.getPaint(i2), that.getPaint(i2))) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    public Paint getPaint(int index) {
        return (Paint)this.get(index);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int count = stream.readInt();
        int i2 = 0;
        while (i2 < count) {
            int index = stream.readInt();
            if (index != -1) {
                this.setPaint(index, SerialUtilities.readPaint(stream));
            }
            ++i2;
        }
    }

    public void setPaint(int index, Paint paint) {
        this.set(index, paint);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int count = this.size();
        stream.writeInt(count);
        int i2 = 0;
        while (i2 < count) {
            Paint paint = this.getPaint(i2);
            if (paint != null) {
                stream.writeInt(i2);
                SerialUtilities.writePaint(paint, stream);
            } else {
                stream.writeInt(-1);
            }
            ++i2;
        }
    }
}

