/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] array) {
        if (array == null) {
            return null;
        }
        float[][] result = new float[array.length][];
        System.arraycopy(array, 0, result, 0, array.length);
        int i2 = 0;
        while (i2 < array.length) {
            float[] child = array[i2];
            float[] copychild = new float[child.length];
            System.arraycopy(child, 0, copychild, 0, child.length);
            result[i2] = copychild;
            ++i2;
        }
        return result;
    }

    public static boolean equal(float[][] array1, float[][] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < array1.length) {
            if (!Arrays.equals(array1[i2], array2[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean equalReferencesInArrays(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < array1.length) {
            if (array1[i2] == null && array2[i2] != null) {
                return false;
            }
            if (array2[i2] == null && array1[i2] != null) {
                return false;
            }
            if (array1[i2] != array2[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] array) {
        int i2 = 0;
        while (i2 < array.length) {
            int j = 0;
            while (j < i2) {
                Object o1 = array[i2];
                Object o2 = array[j];
                if (o1 != null && o2 != null && o1.equals(o2)) {
                    return true;
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }
}

