/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.tabbedui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class VerticalLayout
implements LayoutManager {
    private final boolean useSizeFromParent;

    public VerticalLayout() {
        this(true);
    }

    public VerticalLayout(boolean useParent) {
        this.useSizeFromParent = useParent;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public boolean isUseSizeFromParent() {
        return this.useSizeFromParent;
    }

    public void layoutContainer(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            int width;
            Insets ins2 = parent.getInsets();
            int insHorizontal = ins2.left + ins2.right;
            if (this.isUseSizeFromParent()) {
                Rectangle bounds = parent.getBounds();
                width = bounds.width - insHorizontal;
            } else {
                width = this.preferredLayoutSize((Container)parent).width - insHorizontal;
            }
            Component[] comps = parent.getComponents();
            int y = ins2.top;
            int i2 = 0;
            while (i2 < comps.length) {
                Component c2 = comps[i2];
                if (c2.isVisible()) {
                    Dimension dim = c2.getPreferredSize();
                    c2.setBounds(ins2.left, y, width, dim.height);
                    y += dim.height;
                }
                ++i2;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets ins2 = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = ins2.top + ins2.bottom;
            int width = ins2.left + ins2.right;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible()) {
                    Dimension min = comps[i2].getMinimumSize();
                    height += min.height;
                    if (min.width > width) {
                        width = min.width;
                    }
                }
                ++i2;
            }
            Dimension dimension = new Dimension(width + ins2.left + ins2.right, height + ins2.top + ins2.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets ins2 = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = ins2.top + ins2.bottom;
            int width = ins2.left + ins2.right;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible()) {
                    Dimension pref = comps[i2].getPreferredSize();
                    height += pref.height;
                    if (pref.width > width) {
                        width = pref.width;
                    }
                }
                ++i2;
            }
            Dimension dimension = new Dimension(width + ins2.left + ins2.right, height + ins2.top + ins2.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public void removeLayoutComponent(Component comp) {
    }
}

