/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public abstract class RefineryUtilities {
    protected static final LogContext logger = Log.createContext(class$org$jfree$ui$RefineryUtilities != null ? class$org$jfree$ui$RefineryUtilities : (class$org$jfree$ui$RefineryUtilities = RefineryUtilities.class$("org.jfree.ui.RefineryUtilities")));
    static /* synthetic */ Class class$org$jfree$ui$RefineryUtilities;
    static /* synthetic */ Class class$java$lang$Number;

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void centerFrameOnScreen(Window frame2) {
        RefineryUtilities.positionFrameOnScreen(frame2, 0.5, 0.5);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static JButton createJButton(String label2, Font font2) {
        JButton result = new JButton(label2);
        result.setFont(font2);
        return result;
    }

    public static JLabel createJLabel(String text, Font font2) {
        JLabel result = new JLabel(text);
        result.setFont(font2);
        return result;
    }

    public static JLabel createJLabel(String text, Font font2, Color color) {
        JLabel result = new JLabel(text);
        result.setFont(font2);
        result.setForeground(color);
        return result;
    }

    public static JPanel createTablePanel(TableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table2 = new JTable(model);
        int columnIndex = 0;
        while (columnIndex < model.getColumnCount()) {
            TableColumn column = table2.getColumnModel().getColumn(columnIndex);
            Class<?> c2 = model.getColumnClass(columnIndex);
            if (c2.equals(class$java$lang$Number != null ? class$java$lang$Number : RefineryUtilities.class$("java.lang.Number"))) {
                column.setCellRenderer(new NumberCellRenderer());
            }
            ++columnIndex;
        }
        panel.add(new JScrollPane(table2));
        return panel;
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Dimension d2 = dialog.getSize();
        Container parent = dialog.getParent();
        Dimension p2 = parent.getSize();
        int baseX = parent.getX() - d2.width;
        int baseY = parent.getY() - d2.height;
        int w = d2.width + p2.width;
        int h7 = d2.height + p2.height;
        int x = baseX + (int)(horizontalPercent * (double)w);
        int y = baseY + (int)(verticalPercent * (double)h7);
        Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
        x = Math.min(x, s2.width - d2.width);
        x = Math.max(x, 0);
        y = Math.min(y, s2.height - d2.height);
        y = Math.max(y, 0);
        ((Component)dialog).setBounds(x, y, d2.width, d2.height);
    }

    public static void positionFrameOnScreen(Window frame2, double horizontalPercent, double verticalPercent) {
        Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension f2 = frame2.getSize();
        int w = Math.max(s2.width - f2.width, 0);
        int h7 = Math.max(s2.height - f2.height, 0);
        int x = (int)(horizontalPercent * (double)w);
        int y = (int)(verticalPercent * (double)h7);
        ((Component)frame2).setBounds(x, y, f2.width, f2.height);
    }

    public static void positionFrameRandomly(Window frame2) {
        RefineryUtilities.positionFrameOnScreen(frame2, Math.random(), Math.random());
    }
}

