/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public final class OverlayLayout
implements LayoutManager {
    private boolean ignoreInvisible;

    public OverlayLayout() {
    }

    public OverlayLayout(boolean ignoreInvisible) {
        this.ignoreInvisible = ignoreInvisible;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets ins2 = parent.getInsets();
            Rectangle bounds = parent.getBounds();
            int width = bounds.width - ins2.left - ins2.right;
            int height = bounds.height - ins2.top - ins2.bottom;
            Component[] comps = parent.getComponents();
            int i2 = 0;
            while (i2 < comps.length) {
                Component c2 = comps[i2];
                if (comps[i2].isVisible() || !this.ignoreInvisible) {
                    c2.setBounds(ins2.left, ins2.top, width, height);
                }
                ++i2;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets ins2 = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = 0;
            int width = 0;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible() || !this.ignoreInvisible) {
                    Dimension pref = comps[i2].getMinimumSize();
                    if (pref.height > height) {
                        height = pref.height;
                    }
                    if (pref.width > width) {
                        width = pref.width;
                    }
                }
                ++i2;
            }
            Dimension dimension = new Dimension(width + ins2.left + ins2.right, height + ins2.top + ins2.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets ins2 = parent.getInsets();
            Component[] comps = parent.getComponents();
            int height = 0;
            int width = 0;
            int i2 = 0;
            while (i2 < comps.length) {
                if (comps[i2].isVisible() || !this.ignoreInvisible) {
                    Dimension pref = comps[i2].getPreferredSize();
                    if (pref.height > height) {
                        height = pref.height;
                    }
                    if (pref.width > width) {
                        width = pref.width;
                    }
                }
                ++i2;
            }
            Dimension dimension = new Dimension(width + ins2.left + ins2.right, height + ins2.top + ins2.bottom);
            Object var4_10 = null;
            return dimension;
        }
    }

    public void removeLayoutComponent(Component comp) {
    }
}

