/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;

public class TextBox
implements Serializable {
    private static final long serialVersionUID = 3360220213180203706L;
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(1.0f);
    private RectangleInsets interiorGap = new RectangleInsets(1.0, 3.0, 1.0, 3.0);
    private transient Paint backgroundPaint = new Color(255, 255, 192);
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 2.0;
    private double shadowYOffset = 2.0;
    private TextBlock textBlock;

    public TextBox() {
        this((TextBlock)null);
    }

    public TextBox(String text) {
        this((TextBlock)null);
        if (text != null) {
            this.textBlock = new TextBlock();
            this.textBlock.addLine(text, new Font("SansSerif", 0, 10), Color.black);
        }
    }

    public TextBox(TextBlock block) {
        this.textBlock = block;
    }

    public void draw(Graphics2D g2, float x, float y, RectangleAnchor anchor) {
        Size2D d1 = this.textBlock.calculateDimensions(g2);
        double w = this.interiorGap.extendWidth(d1.getWidth());
        double h7 = this.interiorGap.extendHeight(d1.getHeight());
        Size2D d2 = new Size2D(w, h7);
        Rectangle2D bounds = RectangleAnchor.createRectangle(d2, x, y, anchor);
        if (this.shadowPaint != null) {
            Rectangle2D.Double shadow = new Rectangle2D.Double(bounds.getX() + this.shadowXOffset, bounds.getY() + this.shadowYOffset, bounds.getWidth(), bounds.getHeight());
            g2.setPaint(this.shadowPaint);
            g2.fill(shadow);
        }
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(bounds);
        }
        if (this.outlinePaint != null && this.outlineStroke != null) {
            g2.setPaint(this.outlinePaint);
            g2.setStroke(this.outlineStroke);
            g2.draw(bounds);
        }
        this.textBlock.draw(g2, (float)bounds.getCenterX(), (float)bounds.getCenterY(), TextBlockAnchor.CENTER);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextBox)) {
            return false;
        }
        TextBox that = (TextBox)obj;
        if (!ObjectUtilities.equal(this.outlinePaint, that.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, that.outlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.interiorGap, that.interiorGap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundPaint, that.backgroundPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowPaint, that.shadowPaint)) {
            return false;
        }
        if (this.shadowXOffset != that.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != that.shadowYOffset) {
            return false;
        }
        return ObjectUtilities.equal(this.textBlock, that.textBlock);
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public double getHeight(Graphics2D g2) {
        Size2D d2 = this.textBlock.calculateDimensions(g2);
        return this.interiorGap.extendHeight(d2.getHeight());
    }

    public RectangleInsets getInteriorGap() {
        return this.interiorGap;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public TextBlock getTextBlock() {
        return this.textBlock;
    }

    public int hashCode() {
        int result = this.outlinePaint != null ? this.outlinePaint.hashCode() : 0;
        result = 29 * result + (this.outlineStroke != null ? this.outlineStroke.hashCode() : 0);
        result = 29 * result + (this.interiorGap != null ? this.interiorGap.hashCode() : 0);
        result = 29 * result + (this.backgroundPaint != null ? this.backgroundPaint.hashCode() : 0);
        result = 29 * result + (this.shadowPaint != null ? this.shadowPaint.hashCode() : 0);
        long temp = this.shadowXOffset != 0.0 ? Double.doubleToLongBits(this.shadowXOffset) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.shadowYOffset != 0.0 ? Double.doubleToLongBits(this.shadowYOffset) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + (this.textBlock != null ? this.textBlock.hashCode() : 0);
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.outlinePaint = SerialUtilities.readPaint(stream);
        this.outlineStroke = SerialUtilities.readStroke(stream);
        this.backgroundPaint = SerialUtilities.readPaint(stream);
        this.shadowPaint = SerialUtilities.readPaint(stream);
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public void setInteriorGap(RectangleInsets gap) {
        this.interiorGap = gap;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public void setTextBlock(TextBlock block) {
        this.textBlock = block;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.outlinePaint, stream);
        SerialUtilities.writeStroke(this.outlineStroke, stream);
        SerialUtilities.writePaint(this.backgroundPaint, stream);
        SerialUtilities.writePaint(this.shadowPaint, stream);
    }
}

