/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LCBLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2531780832406163833L;
    private static final int COLUMNS = 3;
    private int[] colWidth = new int[3];
    private int[] rowHeight;
    private int labelGap = 10;
    private int buttonGap = 6;
    private int vGap = 2;

    public LCBLayout(int maxrows) {
        this.rowHeight = new int[maxrows];
    }

    public void addLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c2 = 0;
            while (c2 < 3) {
                int r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getPreferredSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] < d2.height) {
                        this.rowHeight[r] = d2.height;
                    }
                    ++r;
                }
                ++c2;
            }
            int totalHeight = this.vGap * (nrows - 1);
            int r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.colWidth[1] + this.colWidth[2];
            int available = parent.getWidth() - insets.left - insets.right - this.labelGap - this.buttonGap;
            this.colWidth[1] = this.colWidth[1] + (available - totalWidth);
            int x = insets.left;
            int c3 = 0;
            while (c3 < 3) {
                int y = insets.top;
                int r2 = 0;
                while (r2 < nrows) {
                    int i2 = r2 * 3 + c3;
                    if (i2 < ncomponents) {
                        Component component = parent.getComponent(i2);
                        Dimension d3 = component.getPreferredSize();
                        int h7 = d3.height;
                        int adjust = (this.rowHeight[r2] - h7) / 2;
                        parent.getComponent(i2).setBounds(x, y + adjust, this.colWidth[c3], h7);
                    }
                    y = y + this.rowHeight[r2] + this.vGap;
                    ++r2;
                }
                x += this.colWidth[c3];
                if (c3 == 0) {
                    x += this.labelGap;
                }
                if (c3 == 1) {
                    x += this.buttonGap;
                }
                ++c3;
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c2 = 0;
            while (c2 < 3) {
                int r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getMinimumSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] < d2.height) {
                        this.rowHeight[r] = d2.height;
                    }
                    ++r;
                }
                ++c2;
            }
            int totalHeight = this.vGap * (nrows - 1);
            int r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            Dimension dimension = new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
            Object var4_13 = null;
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object2 = parent.getTreeLock();
        synchronized (object2) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            int c2 = 0;
            while (c2 < 3) {
                int r = 0;
                while (r < nrows) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getPreferredSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] < d2.height) {
                        this.rowHeight[r] = d2.height;
                    }
                    ++r;
                }
                ++c2;
            }
            int totalHeight = this.vGap * (nrows - 1);
            int r = 0;
            while (r < nrows) {
                totalHeight += this.rowHeight[r];
                ++r;
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            Dimension dimension = new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
            Object var4_13 = null;
            return dimension;
        }
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void removeLayoutComponent(String name, Component comp) {
    }
}

