/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;

public class CustomPieURLGenerator
implements PieURLGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7100607670144900503L;
    private ArrayList urls = new ArrayList();

    public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
        return this.getURL(key, pieIndex);
    }

    public int getListCount() {
        return this.urls.size();
    }

    public int getURLCount(int list) {
        int result = 0;
        Map urlMap = (Map)this.urls.get(list);
        if (urlMap != null) {
            result = urlMap.size();
        }
        return result;
    }

    public String getURL(Comparable key, int pieItem) {
        Map urlMap;
        String result = null;
        if (pieItem < this.getListCount() && (urlMap = (Map)this.urls.get(pieItem)) != null) {
            result = (String)urlMap.get(key);
        }
        return result;
    }

    public void addURLs(Map urlMap) {
        this.urls.add(urlMap);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomPieURLGenerator) {
            CustomPieURLGenerator generator = (CustomPieURLGenerator)o;
            if (this.getListCount() != generator.getListCount()) {
                return false;
            }
            for (int pieItem = 0; pieItem < this.getListCount(); ++pieItem) {
                if (this.getURLCount(pieItem) != generator.getURLCount(pieItem)) {
                    return false;
                }
                Set keySet = ((HashMap)this.urls.get(pieItem)).keySet();
                Iterator i2 = keySet.iterator();
                while (i2.hasNext()) {
                    String key = (String)i2.next();
                    if (this.getURL((Comparable)((Object)key), pieItem).equals(generator.getURL((Comparable)((Object)key), pieItem))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPieURLGenerator urlGen = new CustomPieURLGenerator();
        Iterator i2 = this.urls.iterator();
        while (i2.hasNext()) {
            Map map2 = (Map)i2.next();
            HashMap newMap = new HashMap();
            Iterator j = map2.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                newMap.put(key, map2.get(key));
            }
            urlGen.addURLs(newMap);
            newMap = null;
        }
        return urlGen;
    }
}

