/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.TableOrder;

public class MultiplePiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -355377800470807389L;
    private JFreeChart pieChart;
    private CategoryDataset dataset;
    private TableOrder dataExtractOrder;
    private double limit = 0.0;
    private Comparable aggregatedItemsKey;
    private transient Paint aggregatedItemsPaint;
    private transient Map sectionPaints;

    public MultiplePiePlot() {
        this(null);
    }

    public MultiplePiePlot(CategoryDataset dataset) {
        this.dataset = dataset;
        PiePlot piePlot = new PiePlot(null);
        this.pieChart = new JFreeChart(piePlot);
        this.pieChart.removeLegend();
        this.dataExtractOrder = TableOrder.BY_COLUMN;
        this.pieChart.setBackgroundPaint(null);
        TextTitle seriesTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        seriesTitle.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.setTitle(seriesTitle);
        this.aggregatedItemsKey = "Other";
        this.aggregatedItemsPaint = Color.lightGray;
        this.sectionPaints = new HashMap();
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset dataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        this.datasetChanged(new DatasetChangeEvent(this, dataset));
    }

    public JFreeChart getPieChart() {
        return this.pieChart;
    }

    public void setPieChart(JFreeChart pieChart) {
        this.pieChart = pieChart;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Null 'order' argument");
        }
        this.dataExtractOrder = order;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double limit) {
        this.limit = limit;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Comparable getAggregatedItemsKey() {
        return this.aggregatedItemsKey;
    }

    public void setAggregatedItemsKey(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        this.aggregatedItemsKey = key;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAggregatedItemsPaint() {
        return this.aggregatedItemsPaint;
    }

    public void setAggregatedItemsPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.aggregatedItemsPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public String getPlotType() {
        return "Multiple Pie Plot";
    }

    public void draw(Graphics2D g2, Rectangle2D area2, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        int displayRows;
        RectangleInsets insets = this.getInsets();
        insets.trim(area2);
        this.drawBackground(g2, area2);
        this.drawOutline(g2, area2);
        if (DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawNoDataMessage(g2, area2);
            return;
        }
        int pieCount = 0;
        pieCount = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowCount() : this.dataset.getColumnCount();
        int displayCols = (int)Math.ceil(Math.sqrt(pieCount));
        if (displayCols > (displayRows = (int)Math.ceil((double)pieCount / (double)displayCols)) && area2.getWidth() < area2.getHeight()) {
            int temp = displayCols;
            displayCols = displayRows;
            displayRows = temp;
        }
        this.prefetchSectionPaints();
        int x = (int)area2.getX();
        int y = (int)area2.getY();
        int width = (int)area2.getWidth() / displayCols;
        int height = (int)area2.getHeight() / displayRows;
        int row = 0;
        int column = 0;
        int diff = displayRows * displayCols - pieCount;
        int xoffset = 0;
        Rectangle rect = new Rectangle();
        for (int pieIndex = 0; pieIndex < pieCount; ++pieIndex) {
            rect.setBounds(x + xoffset + width * column, y + height * row, width, height);
            String title2 = null;
            title2 = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowKey(pieIndex).toString() : this.dataset.getColumnKey(pieIndex).toString();
            this.pieChart.setTitle(title2);
            PieDataset piedataset = null;
            CategoryToPieDataset dd2 = new CategoryToPieDataset(this.dataset, this.dataExtractOrder, pieIndex);
            piedataset = this.limit > 0.0 ? DatasetUtilities.createConsolidatedPieDataset(dd2, this.aggregatedItemsKey, this.limit) : dd2;
            PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
            piePlot.setDataset(piedataset);
            piePlot.setPieIndex(pieIndex);
            for (int i2 = 0; i2 < piedataset.getItemCount(); ++i2) {
                Comparable key = piedataset.getKey(i2);
                Paint p2 = key.equals(this.aggregatedItemsKey) ? this.aggregatedItemsPaint : (Paint)this.sectionPaints.get(key);
                piePlot.setSectionPaint(i2, p2);
            }
            ChartRenderingInfo subinfo = null;
            if (info != null) {
                subinfo = new ChartRenderingInfo();
            }
            this.pieChart.draw(g2, rect, subinfo);
            if (info != null) {
                info.getOwner().getEntityCollection().addAll(subinfo.getEntityCollection());
                info.addSubplotInfo(subinfo.getPlotInfo());
            }
            if (++column != displayCols) continue;
            column = 0;
            if (++row != displayRows - 1 || diff == 0) continue;
            xoffset = diff * width / 2;
        }
    }

    private void prefetchSectionPaints() {
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            for (int c2 = 0; c2 < this.dataset.getColumnCount(); ++c2) {
                Comparable key = this.dataset.getColumnKey(c2);
                Paint p2 = (Paint)this.sectionPaints.get(key);
                if (p2 != null) continue;
                this.sectionPaints.put(key, this.getDrawingSupplier().getNextPaint());
            }
        } else {
            for (int r = 0; r < this.dataset.getRowCount(); ++r) {
                Comparable key = this.dataset.getRowKey(r);
                Paint p3 = (Paint)this.sectionPaints.get(key);
                if (p3 != null) continue;
                this.sectionPaints.put(key, this.getDrawingSupplier().getNextPaint());
            }
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.dataset != null) {
            List keys = null;
            this.prefetchSectionPaints();
            if (this.dataExtractOrder == TableOrder.BY_ROW) {
                keys = this.dataset.getColumnKeys();
            } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
                keys = this.dataset.getRowKeys();
            }
            if (keys != null) {
                int section = 0;
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String label2;
                    Comparable key = (Comparable)iterator.next();
                    String description = label2 = key.toString();
                    Paint paint = (Paint)this.sectionPaints.get(key);
                    LegendItem item = new LegendItem(label2, description, null, null, Plot.DEFAULT_LEGEND_ITEM_CIRCLE, paint, Plot.DEFAULT_OUTLINE_STROKE, paint);
                    result.add(item);
                    ++section;
                }
            }
            if (this.limit > 0.0) {
                result.add(new LegendItem(this.aggregatedItemsKey.toString(), this.aggregatedItemsKey.toString(), null, null, Plot.DEFAULT_LEGEND_ITEM_CIRCLE, this.aggregatedItemsPaint, Plot.DEFAULT_OUTLINE_STROKE, this.aggregatedItemsPaint));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MultiplePiePlot)) {
            return false;
        }
        MultiplePiePlot that = (MultiplePiePlot)obj;
        if (this.dataExtractOrder != that.dataExtractOrder) {
            return false;
        }
        if (this.limit != that.limit) {
            return false;
        }
        if (!this.aggregatedItemsKey.equals(that.aggregatedItemsKey)) {
            return false;
        }
        if (!PaintUtilities.equal(this.aggregatedItemsPaint, that.aggregatedItemsPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.pieChart, that.pieChart)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.aggregatedItemsPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.aggregatedItemsPaint = SerialUtilities.readPaint(stream);
        this.sectionPaints = new HashMap();
    }
}

