/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class GridArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = -2563758090144655938L;
    private int rows;
    private int columns;

    public GridArrangement(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    public void add(Block block, Object key) {
    }

    public Size2D arrange(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        LengthConstraintType w = constraint.getWidthConstraintType();
        LengthConstraintType h7 = constraint.getHeightConstraintType();
        if (w == LengthConstraintType.NONE) {
            if (h7 == LengthConstraintType.NONE) {
                return this.arrangeNN(container, g2);
            }
            if (h7 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h7 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h7 == LengthConstraintType.NONE) {
                return this.arrangeFN(container, g2, constraint);
            }
            if (h7 == LengthConstraintType.FIXED) {
                return this.arrangeFF(container, g2, constraint);
            }
            if (h7 == LengthConstraintType.RANGE) {
                return this.arrangeFR(container, g2, constraint);
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h7 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h7 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h7 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
        }
        return new Size2D();
    }

    protected Size2D arrangeNN(BlockContainer container, Graphics2D g2) {
        double maxW = 0.0;
        double maxH = 0.0;
        List blocks = container.getBlocks();
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            Block b2 = (Block)iterator.next();
            Size2D s2 = b2.arrange(g2, RectangleConstraint.NONE);
            maxW = Math.max(maxW, s2.width);
            maxH = Math.max(maxH, s2.height);
        }
        double width = (double)this.columns * maxW;
        double height = (double)this.rows * maxH;
        RectangleConstraint c2 = new RectangleConstraint(width, height);
        return this.arrangeFF(container, g2, c2);
    }

    protected Size2D arrangeFF(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        double width = constraint.getWidth() / (double)this.columns;
        double height = constraint.getHeight() / (double)this.rows;
        List blocks = container.getBlocks();
        for (int c2 = 0; c2 < this.columns; ++c2) {
            int index;
            for (int r = 0; r < this.rows && (index = r * this.columns + c2) != blocks.size(); ++r) {
                Block b2 = (Block)blocks.get(index);
                b2.setBounds(new Rectangle2D.Double((double)c2 * width, (double)r * height, width, height));
            }
        }
        return new Size2D((double)this.columns * width, (double)this.rows * height);
    }

    protected Size2D arrangeFR(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint c1 = constraint.toUnconstrainedHeight();
        Size2D size1 = this.arrange(container, g2, c1);
        if (constraint.getHeightRange().contains(size1.getHeight())) {
            return size1;
        }
        double h7 = constraint.getHeightRange().constrain(size1.getHeight());
        RectangleConstraint c2 = constraint.toFixedHeight(h7);
        return this.arrange(container, g2, c2);
    }

    protected Size2D arrangeFN(BlockContainer container, Graphics2D g2, RectangleConstraint constraint) {
        double width = constraint.getWidth() / (double)this.columns;
        RectangleConstraint constraint2 = constraint.toFixedWidth(width);
        List blocks = container.getBlocks();
        double maxH = 0.0;
        for (int r = 0; r < this.rows; ++r) {
            int index;
            for (int c2 = 0; c2 < this.columns && (index = r * this.columns + c2) != blocks.size(); ++c2) {
                Block b2 = (Block)blocks.get(index);
                Size2D s2 = b2.arrange(g2, constraint2);
                maxH = Math.max(maxH, s2.getHeight());
            }
        }
        RectangleConstraint constraint3 = constraint.toFixedHeight(maxH * (double)this.rows);
        return this.arrange(container, g2, constraint3);
    }

    public void clear() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridArrangement)) {
            return false;
        }
        GridArrangement that = (GridArrangement)obj;
        if (this.columns != that.columns) {
            return false;
        }
        return this.rows == that.rows;
    }
}

