/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Log;

public final class PackageSorter {
    private PackageSorter() {
    }

    private static ArrayList collectSubsystemModules(Module childMod, HashMap moduleMap) {
        ArrayList<String> collector = new ArrayList<String>();
        ModuleInfo[] info = childMod.getRequiredModules();
        int i2 = 0;
        while (i2 < info.length) {
            SortModule dependentModule = (SortModule)moduleMap.get(info[i2].getModuleClass());
            if (dependentModule == null) {
                Log.warn(new Log.SimpleMessage("A dependent module was not found in the list of known modules.", info[i2].getModuleClass()));
            } else {
                collector.add(dependentModule.getState().getModule().getSubSystem());
            }
            ++i2;
        }
        info = childMod.getOptionalModules();
        int i3 = 0;
        while (i3 < info.length) {
            Module dependentModule = (Module)moduleMap.get(info[i3].getModuleClass());
            if (dependentModule == null) {
                Log.warn("A dependent module was not found in the list of known modules.");
            } else {
                collector.add(dependentModule.getSubSystem());
            }
            ++i3;
        }
        return collector;
    }

    private static boolean isBaseModule(Module mod, ModuleInfo mi) {
        ModuleInfo[] info = mod.getRequiredModules();
        int i2 = 0;
        while (i2 < info.length) {
            if (info[i2].getModuleClass().equals(mi.getModuleClass())) {
                return true;
            }
            ++i2;
        }
        info = mod.getOptionalModules();
        int i3 = 0;
        while (i3 < info.length) {
            if (info[i3].getModuleClass().equals(mi.getModuleClass())) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    private static int searchModulePosition(SortModule smodule, HashMap moduleMap) {
        Module module = smodule.getState().getModule();
        int position = 0;
        ModuleInfo[] modInfo = module.getOptionalModules();
        int modPos = 0;
        while (modPos < modInfo.length) {
            String moduleName = modInfo[modPos].getModuleClass();
            SortModule reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod != null && reqMod.getPosition() >= position) {
                position = reqMod.getPosition() + 1;
            }
            ++modPos;
        }
        modInfo = module.getRequiredModules();
        int modPos2 = 0;
        while (modPos2 < modInfo.length) {
            String moduleName = modInfo[modPos2].getModuleClass();
            SortModule reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod.getPosition() >= position) {
                position = reqMod.getPosition() + 1;
            }
            ++modPos2;
        }
        String subSystem = module.getSubSystem();
        Iterator it = moduleMap.values().iterator();
        while (it.hasNext()) {
            Module subSysMod;
            SortModule mod = (SortModule)it.next();
            if (mod.getState().getModule() == module || subSystem.equals((subSysMod = mod.getState().getModule()).getSubSystem()) || !smodule.getDependSubsystems().contains(subSysMod.getSubSystem()) || PackageSorter.isBaseModule(subSysMod, module) || mod.getPosition() < position) continue;
            position = mod.getPosition() + 1;
        }
        return position;
    }

    public static void sort(List modules) {
        int i2;
        HashMap<String, SortModule> moduleMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> errorModules = new ArrayList<PackageState>();
        ArrayList<SortModule> weightModules = new ArrayList<SortModule>();
        int i3 = 0;
        while (i3 < modules.size()) {
            PackageState state = (PackageState)modules.get(i3);
            if (state.getState() == -2) {
                errorModules.add(state);
            } else {
                SortModule mod = new SortModule(state);
                weightModules.add(mod);
                moduleMap.put(state.getModule().getModuleClass(), mod);
            }
            ++i3;
        }
        Object[] weigths = weightModules.toArray(new SortModule[weightModules.size()]);
        int i4 = 0;
        while (i4 < weigths.length) {
            SortModule sortMod = weigths[i4];
            sortMod.setDependSubsystems(PackageSorter.collectSubsystemModules(sortMod.getState().getModule(), moduleMap));
            ++i4;
        }
        boolean doneWork = true;
        while (doneWork) {
            doneWork = false;
            i2 = 0;
            while (i2 < weigths.length) {
                Object mod = weigths[i2];
                int position = PackageSorter.searchModulePosition((SortModule)mod, moduleMap);
                if (position != ((SortModule)mod).getPosition()) {
                    ((SortModule)mod).setPosition(position);
                    doneWork = true;
                }
                ++i2;
            }
        }
        Arrays.sort(weigths);
        modules.clear();
        i2 = 0;
        while (i2 < weigths.length) {
            modules.add(((SortModule)weigths[i2]).getState());
            ++i2;
        }
        int i5 = 0;
        while (i5 < errorModules.size()) {
            modules.add(errorModules.get(i5));
            ++i5;
        }
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        public SortModule(PackageState state) {
            this.state = state;
        }

        public int compareTo(Object o) {
            SortModule otherModule = (SortModule)o;
            if (this.position > otherModule.position) {
                return 1;
            }
            if (this.position < otherModule.position) {
                return -1;
            }
            return 0;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public int getPosition() {
            return this.position;
        }

        public PackageState getState() {
            return this.state;
        }

        public void setDependSubsystems(ArrayList dependSubsystems) {
            this.dependSubsystems = dependSubsystems;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SortModule: ");
            buffer.append(this.position);
            buffer.append(" ");
            buffer.append(this.state.getModule().getName());
            buffer.append(" ");
            buffer.append(this.state.getModule().getModuleClass());
            return buffer.toString();
        }
    }
}

