/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.util.ArrayList;
import org.jfree.base.BasicProjectInfo;
import org.jfree.base.Library;

public class BootableProjectInfo
extends BasicProjectInfo {
    private String bootClass;
    private boolean autoBoot = true;

    public BootableProjectInfo() {
    }

    public BootableProjectInfo(String name, String version, String licence, String info) {
        this();
        this.setName(name);
        this.setVersion(version);
        this.setLicenceName(licence);
        this.setInfo(info);
    }

    public BootableProjectInfo(String name, String version, String info, String copyright, String licenceName) {
        this();
        this.setName(name);
        this.setVersion(version);
        this.setLicenceName(licenceName);
        this.setInfo(info);
        this.setCopyright(copyright);
    }

    public void addDependency(BootableProjectInfo projectInfo) {
        if (projectInfo == null) {
            throw new NullPointerException();
        }
        this.addLibrary(projectInfo);
    }

    public String getBootClass() {
        return this.bootClass;
    }

    public BootableProjectInfo[] getDependencies() {
        ArrayList<Library> dependencies = new ArrayList<Library>();
        Library[] libraries = this.getLibraries();
        int i2 = 0;
        while (i2 < libraries.length) {
            Library lib = libraries[i2];
            if (lib instanceof BootableProjectInfo) {
                dependencies.add(lib);
            }
            ++i2;
        }
        Library[] optionalLibraries = this.getOptionalLibraries();
        int i3 = 0;
        while (i3 < optionalLibraries.length) {
            Library lib = optionalLibraries[i3];
            if (lib instanceof BootableProjectInfo) {
                dependencies.add(lib);
            }
            ++i3;
        }
        return dependencies.toArray(new BootableProjectInfo[dependencies.size()]);
    }

    public boolean isAutoBoot() {
        return this.autoBoot;
    }

    public void setAutoBoot(boolean autoBoot) {
        this.autoBoot = autoBoot;
    }

    public void setBootClass(String bootClass) {
        this.bootClass = bootClass;
    }
}

