/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPUtils {
    private PlasticXPUtils() {
    }

    static void drawPlainButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticXPUtils.drawButtonBorder(g2, x, y, w, h7, PlasticLookAndFeel.getControl(), PlasticLookAndFeel.getControlDarkShadow(), LookUtils.getSlightlyBrighter(PlasticLookAndFeel.getControlDarkShadow(), 1.25f));
    }

    static void drawPressedButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x, y, w, h7);
        Color darkColor = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlDarkShadow(), 128);
        Color lightColor = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlHighlight(), 80);
        g2.translate(x, y);
        g2.setColor(darkColor);
        g2.fillRect(2, 1, w - 4, 1);
        g2.setColor(lightColor);
        g2.fillRect(2, h7 - 2, w - 4, 1);
        g2.translate(-x, -y);
    }

    static void drawDefaultButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x, y, w, h7);
        PlasticXPUtils.drawInnerButtonDecoration(g2, x, y, w, h7, PlasticLookAndFeel.getPrimaryControlDarkShadow());
    }

    static void drawFocusedButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x, y, w, h7);
        PlasticXPUtils.drawInnerButtonDecoration(g2, x, y, w, h7, PlasticLookAndFeel.getFocusColor());
    }

    static void drawDisabledButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticXPUtils.drawButtonBorder(g2, x, y, w, h7, PlasticLookAndFeel.getControl(), MetalLookAndFeel.getControlShadow(), LookUtils.getSlightlyBrighter(MetalLookAndFeel.getControlShadow()));
    }

    public static void drawButtonBorder(Graphics g2, int x, int y, int w, int h7, Color backgroundColor, Color edgeColor, Color cornerColor) {
        g2.translate(x, y);
        g2.setColor(edgeColor);
        PlasticXPUtils.drawRect(g2, 0, 0, w - 1, h7 - 1);
        g2.setColor(cornerColor);
        g2.fillRect(0, 0, 2, 2);
        g2.fillRect(0, h7 - 2, 2, 2);
        g2.fillRect(w - 2, 0, 2, 2);
        g2.fillRect(w - 2, h7 - 2, 2, 2);
        g2.setColor(backgroundColor);
        g2.fillRect(0, 0, 1, 1);
        g2.fillRect(0, h7 - 1, 1, 1);
        g2.fillRect(w - 1, 0, 1, 1);
        g2.fillRect(w - 1, h7 - 1, 1, 1);
        g2.translate(-x, -y);
    }

    private static void drawInnerButtonDecoration(Graphics g2, int x, int y, int w, int h7, Color baseColor) {
        Color lightColor = PlasticXPUtils.translucentColor(baseColor, 90);
        Color mediumColor = PlasticXPUtils.translucentColor(baseColor, 120);
        Color darkColor = PlasticXPUtils.translucentColor(baseColor, 200);
        g2.translate(x, y);
        g2.setColor(lightColor);
        g2.fillRect(2, 1, w - 4, 1);
        g2.setColor(mediumColor);
        g2.fillRect(1, 2, 1, h7 - 4);
        g2.fillRect(w - 2, 2, 1, h7 - 4);
        PlasticXPUtils.drawRect(g2, 2, 2, w - 5, h7 - 5);
        g2.setColor(darkColor);
        g2.fillRect(2, h7 - 2, w - 4, 1);
        g2.translate(-x, -y);
    }

    static void drawRect(Graphics g2, int x, int y, int w, int h7) {
        g2.fillRect(x, y, w + 1, 1);
        g2.fillRect(x, y + 1, 1, h7);
        g2.fillRect(x + 1, y + h7, w, 1);
        g2.fillRect(x + w, y + 1, 1, h7);
    }

    private static Color translucentColor(Color baseColor, int alpha) {
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }
}

