/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class PlasticUtils {
    private static final float FRACTION_3D = 0.5f;

    private PlasticUtils() {
    }

    static void drawDark3DBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
        g2.setColor(PlasticLookAndFeel.getControl());
        g2.drawLine(x + 1, y + 1, 1, h7 - 3);
        g2.drawLine(y + 1, y + 1, w - 3, 1);
    }

    static void drawDisabledBorder(Graphics g2, int x, int y, int w, int h7) {
        g2.setColor(PlasticLookAndFeel.getControlShadow());
        PlasticUtils.drawRect(g2, x, y, w - 1, h7 - 1);
    }

    static void drawFlush3DBorder(Graphics g2, int x, int y, int w, int h7) {
        g2.translate(x, y);
        g2.setColor(PlasticLookAndFeel.getControlHighlight());
        PlasticUtils.drawRect(g2, 1, 1, w - 2, h7 - 2);
        g2.drawLine(0, h7 - 1, 0, h7 - 1);
        g2.drawLine(w - 1, 0, w - 1, 0);
        g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(g2, 0, 0, w - 2, h7 - 2);
        g2.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g2, int x, int y, int w, int h7) {
        g2.translate(x, y);
        PlasticUtils.drawFlush3DBorder(g2, 0, 0, w, h7);
        g2.setColor(PlasticLookAndFeel.getControlShadow());
        g2.drawLine(1, 1, 1, h7 - 3);
        g2.drawLine(1, 1, w - 3, 1);
        g2.translate(-x, -y);
    }

    static void drawButtonBorder(Graphics g2, int x, int y, int w, int h7, boolean active) {
        if (active) {
            PlasticUtils.drawActiveButtonBorder(g2, x, y, w, h7);
        } else {
            PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
        }
    }

    static void drawActiveButtonBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
        g2.setColor(PlasticLookAndFeel.getPrimaryControl());
        g2.drawLine(x + 1, y + 1, x + 1, h7 - 3);
        g2.drawLine(x + 1, y + 1, w - 3, x + 1);
        g2.setColor(PlasticLookAndFeel.getPrimaryControlDarkShadow());
        g2.drawLine(x + 2, h7 - 2, w - 2, h7 - 2);
        g2.drawLine(w - 2, y + 2, w - 2, h7 - 2);
    }

    static void drawDefaultButtonBorder(Graphics g2, int x, int y, int w, int h7, boolean active) {
        PlasticUtils.drawButtonBorder(g2, x + 1, y + 1, w - 1, h7 - 1, active);
        g2.translate(x, y);
        g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(g2, 0, 0, w - 3, h7 - 3);
        g2.drawLine(w - 2, 0, w - 2, 0);
        g2.drawLine(0, h7 - 2, 0, h7 - 2);
        g2.setColor(PlasticLookAndFeel.getControl());
        g2.drawLine(w - 1, 0, w - 1, 0);
        g2.drawLine(0, h7 - 1, 0, h7 - 1);
        g2.translate(-x, -y);
    }

    static void drawDefaultButtonPressedBorder(Graphics g2, int x, int y, int w, int h7) {
        PlasticUtils.drawPressed3DBorder(g2, x + 1, y + 1, w - 1, h7 - 1);
        g2.translate(x, y);
        g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
        PlasticUtils.drawRect(g2, 0, 0, w - 3, h7 - 3);
        g2.drawLine(w - 2, 0, w - 2, 0);
        g2.drawLine(0, h7 - 2, 0, h7 - 2);
        g2.setColor(PlasticLookAndFeel.getControl());
        g2.drawLine(w - 1, 0, w - 1, 0);
        g2.drawLine(0, h7 - 1, 0, h7 - 1);
        g2.translate(-x, -y);
    }

    static void drawThinFlush3DBorder(Graphics g2, int x, int y, int w, int h7) {
        g2.translate(x, y);
        g2.setColor(PlasticLookAndFeel.getControlHighlight());
        g2.drawLine(0, 0, w - 2, 0);
        g2.drawLine(0, 0, 0, h7 - 2);
        g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
        g2.drawLine(w - 1, 0, w - 1, h7 - 1);
        g2.drawLine(0, h7 - 1, w - 1, h7 - 1);
        g2.translate(-x, -y);
    }

    static void drawThinPressed3DBorder(Graphics g2, int x, int y, int w, int h7) {
        g2.translate(x, y);
        g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
        g2.drawLine(0, 0, w - 2, 0);
        g2.drawLine(0, 0, 0, h7 - 2);
        g2.setColor(PlasticLookAndFeel.getControlHighlight());
        g2.drawLine(w - 1, 0, w - 1, h7 - 1);
        g2.drawLine(0, h7 - 1, w - 1, h7 - 1);
        g2.translate(-x, -y);
    }

    static boolean isLeftToRight(Component c2) {
        return c2.getComponentOrientation().isLeftToRight();
    }

    static boolean is3D(String keyPrefix) {
        Object value = UIManager.get(keyPrefix + "is3DEnabled");
        return Boolean.TRUE.equals(value);
    }

    static boolean force3D(JComponent c2) {
        Object value = c2.getClientProperty("Plastic.is3D");
        return Boolean.TRUE.equals(value);
    }

    static boolean forceFlat(JComponent c2) {
        Object value = c2.getClientProperty("Plastic.is3D");
        return Boolean.FALSE.equals(value);
    }

    private static void add3DEffekt(Graphics g2, Rectangle r, boolean isHorizontal, Color startC0, Color stopC0, Color startC1, Color stopC1) {
        int yd1;
        int xd1;
        int yd0;
        int xd0;
        int yb1;
        int xb1;
        int yb0;
        int xb0;
        int height;
        int width;
        Graphics2D g22 = (Graphics2D)g2;
        if (isHorizontal) {
            width = r.width;
            height = (int)((float)r.height * 0.5f);
            xb0 = r.x;
            yb0 = r.y;
            xb1 = xb0;
            yb1 = yb0 + height;
            xd0 = xb1;
            yd0 = yb1;
            xd1 = xd0;
            yd1 = r.y + r.height;
        } else {
            width = (int)((float)r.width * 0.5f);
            height = r.height;
            xb0 = r.x;
            yb0 = r.y;
            xb1 = xb0 + width;
            yb1 = yb0;
            xd0 = xb1;
            yd0 = yb0;
            xd1 = r.x + r.width;
            yd1 = yd0;
        }
        g22.setPaint(new GradientPaint(xb0, yb0, stopC0, xb1, yb1, startC0));
        g22.fillRect(r.x, r.y, width, height);
        g22.setPaint(new GradientPaint(xd0, yd0, startC1, xd1, yd1, stopC1));
        g22.fillRect(xd0, yd0, width, height);
    }

    static void add3DEffekt(Graphics g2, Rectangle r) {
        Color brightenStop = UIManager.getColor("Plastic.brightenStop");
        if (null == brightenStop) {
            brightenStop = PlasticTheme.BRIGHTEN_STOP;
        }
        Graphics2D g22 = (Graphics2D)g2;
        int border = 10;
        g22.setPaint(new GradientPaint(r.x, r.y, brightenStop, r.x + border, r.y, PlasticTheme.BRIGHTEN_START));
        g22.fillRect(r.x, r.y, border, r.height);
        int x = r.x + r.width - border;
        int y = r.y;
        g22.setPaint(new GradientPaint(x, y, PlasticTheme.DARKEN_START, x + border, y, PlasticTheme.LT_DARKEN_STOP));
        g22.fillRect(x, y, border, r.height);
        PlasticUtils.add3DEffekt(g2, r, true, PlasticTheme.BRIGHTEN_START, brightenStop, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    static void addLight3DEffekt(Graphics g2, Rectangle r, boolean isHorizontal) {
        Color ltBrightenStop = UIManager.getColor("Plastic.ltBrightenStop");
        if (null == ltBrightenStop) {
            ltBrightenStop = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(g2, r, isHorizontal, PlasticTheme.BRIGHTEN_START, ltBrightenStop, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP);
    }

    public static void addLight3DEffekt(Graphics g2, Rectangle r) {
        Color ltBrightenStop = UIManager.getColor("Plastic.ltBrightenStop");
        if (null == ltBrightenStop) {
            ltBrightenStop = PlasticTheme.LT_BRIGHTEN_STOP;
        }
        PlasticUtils.add3DEffekt(g2, r, true, PlasticTheme.DARKEN_START, PlasticTheme.LT_DARKEN_STOP, PlasticTheme.BRIGHTEN_START, ltBrightenStop);
    }

    private static void drawRect(Graphics g2, int x, int y, int w, int h7) {
        g2.fillRect(x, y, w + 1, 1);
        g2.fillRect(x, y + 1, 1, h7);
        g2.fillRect(x + 1, y + h7, w, 1);
        g2.fillRect(x + w, y + 1, 1, h7);
    }
}

