/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.text.JTextComponent;

final class PlasticBorders {
    private static Border buttonBorder;
    private static Border comboBoxEditorBorder;
    private static Border comboBoxArrowButtonBorder;
    private static Border etchedBorder;
    private static Border flush3DBorder;
    private static Border menuBarHeaderBorder;
    private static Border menuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border noMarginPopupMenuBorder;
    private static Border rolloverButtonBorder;
    private static Border scrollPaneBorder;
    private static Border separatorBorder;
    private static Border textFieldBorder;
    private static Border thinLoweredBorder;
    private static Border thinRaisedBorder;
    private static Border toggleButtonBorder;
    private static Border toolBarHeaderBorder;

    private PlasticBorders() {
    }

    static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new ComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new ComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getEtchedBorder() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    static Border getFlush3DBorder() {
        if (flush3DBorder == null) {
            flush3DBorder = new Flush3DBorder();
        }
        return flush3DBorder;
    }

    static Border getInternalFrameBorder() {
        return new InternalFrameBorder();
    }

    static Border getMenuBarHeaderBorder() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return menuItemBorder;
    }

    static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    static Border getNoMarginPopupMenuBorder() {
        if (noMarginPopupMenuBorder == null) {
            noMarginPopupMenuBorder = new NoMarginPopupMenuBorder();
        }
        return noMarginPopupMenuBorder;
    }

    static Border getPaletteBorder() {
        return new PaletteBorder();
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(), new RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getSeparatorBorder() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getThinLoweredBorder() {
        if (thinLoweredBorder == null) {
            thinLoweredBorder = new ThinLoweredBorder();
        }
        return thinLoweredBorder;
    }

    static Border getThinRaisedBorder() {
        if (thinRaisedBorder == null) {
            thinRaisedBorder = new ThinRaisedBorder();
        }
        return thinRaisedBorder;
    }

    static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    static Border getToolBarHeaderBorder() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    private static final class ToggleButtonBorder
    extends ButtonBorder {
        private ToggleButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            if (!c2.isEnabled()) {
                PlasticUtils.drawDisabledBorder(g2, x, y, w - 1, h7 - 1);
            } else {
                AbstractButton button2 = (AbstractButton)c2;
                ButtonModel model = button2.getModel();
                if (model.isPressed() && model.isArmed()) {
                    PlasticUtils.drawPressed3DBorder(g2, x, y, w, h7);
                } else if (model.isSelected()) {
                    PlasticUtils.drawDark3DBorder(g2, x, y, w, h7);
                } else {
                    PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
                }
            }
        }
    }

    private static final class TextFieldBorder
    extends Flush3DBorder {
        private TextFieldBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            if (!(c2 instanceof JTextComponent)) {
                if (c2.isEnabled()) {
                    PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
                } else {
                    PlasticUtils.drawDisabledBorder(g2, x, y, w, h7);
                }
                return;
            }
            if (c2.isEnabled() && ((JTextComponent)c2).isEditable()) {
                PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
            } else {
                PlasticUtils.drawDisabledBorder(g2, x, y, w, h7);
            }
        }
    }

    private static final class ScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private ScrollPaneBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
            g2.drawRect(0, 0, w - 2, h7 - 2);
            g2.setColor(PlasticLookAndFeel.getControlHighlight());
            g2.drawLine(w - 1, 0, w - 1, h7 - 1);
            g2.drawLine(0, h7 - 1, w - 1, h7 - 1);
            g2.translate(-x, -y);
        }
    }

    private static final class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c2) {
            return this.getBorderInsets(c2, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c2, Insets insets) {
            Insets margin = null;
            if (c2 instanceof AbstractButton) {
                margin = ((AbstractButton)c2).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    private static class RolloverButtonBorder
    extends ButtonBorder {
        private static final Insets INSETS_3 = new Insets(3, 3, 3, 3);

        private RolloverButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (!(c2 instanceof JToggleButton)) {
                if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                    super.paintBorder(c2, g2, x, y, w, h7);
                }
                return;
            }
            if (model.isRollover()) {
                if (model.isPressed() && model.isArmed()) {
                    PlasticUtils.drawPressed3DBorder(g2, x, y, w, h7);
                } else {
                    PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
                }
            } else if (model.isSelected()) {
                PlasticUtils.drawDark3DBorder(g2, x, y, w, h7);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS_3;
        }
    }

    private static final class NoMarginPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private NoMarginPopupMenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
            g2.drawRect(0, 0, w - 1, h7 - 1);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
            g2.drawRect(0, 0, w - 1, h7 - 1);
            g2.setColor(PlasticLookAndFeel.getMenuItemBackground());
            g2.drawRect(1, 1, w - 3, h7 - 3);
            g2.drawRect(2, 2, w - 5, h7 - 5);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private MenuBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            JMenuItem b2 = (JMenuItem)c2;
            ButtonModel model = b2.getModel();
            if (model.isArmed() || model.isSelected()) {
                g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
                g2.drawLine(0, 0, w - 2, 0);
                g2.drawLine(0, 0, 0, h7 - 1);
                g2.setColor(PlasticLookAndFeel.getPrimaryControlHighlight());
                g2.drawLine(w - 1, 0, w - 1, h7 - 1);
            } else if (model.isRollover()) {
                g2.translate(x, y);
                PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
                g2.translate(-x, -y);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }

        public Insets getBorderInsets(Component c2, Insets newInsets) {
            newInsets.top = MenuBorder.INSETS.top;
            newInsets.left = MenuBorder.INSETS.left;
            newInsets.bottom = MenuBorder.INSETS.bottom;
            newInsets.right = MenuBorder.INSETS.right;
            return newInsets;
        }
    }

    private static final class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            PlasticUtils.drawThinPressed3DBorder(g2, x, y - 1, w, h7 + 1);
            PlasticUtils.drawThinFlush3DBorder(g2, x + 1, y, w - 2, h7 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            PlasticUtils.drawThinPressed3DBorder(g2, x, y, w, h7 + 1);
            PlasticUtils.drawThinFlush3DBorder(g2, x + 1, y + 1, w - 2, h7 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            PlasticUtils.drawThinPressed3DBorder(g2, x, y, w, h7);
            PlasticUtils.drawThinFlush3DBorder(g2, x + 1, y + 1, w - 2, h7 - 2);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinLoweredBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            PlasticUtils.drawThinPressed3DBorder(g2, x, y, w, h7);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinRaisedBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            PlasticUtils.drawThinFlush3DBorder(g2, x, y, w, h7);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 0, 2, 1);

        private SeparatorBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(UIManager.getColor("Separator.foreground"));
            g2.drawLine(0, h7 - 2, w - 1, h7 - 2);
            g2.setColor(UIManager.getColor("Separator.background"));
            g2.drawLine(0, h7 - 1, w - 1, h7 - 1);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private PaletteBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(PlasticLookAndFeel.getControlDarkShadow());
            g2.drawRect(0, 0, w - 1, h7 - 1);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets NORMAL_INSETS = new Insets(1, 1, 1, 1);
        private static final Insets MAXIMIZED_INSETS = new Insets(1, 1, 0, 0);

        private InternalFrameBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            JInternalFrame frame2 = (JInternalFrame)c2;
            if (frame2.isMaximum()) {
                this.paintMaximizedBorder(g2, x, y, w, h7);
            } else {
                PlasticUtils.drawThinFlush3DBorder(g2, x, y, w, h7);
            }
        }

        private void paintMaximizedBorder(Graphics g2, int x, int y, int w, int h7) {
            g2.translate(x, y);
            g2.setColor(PlasticLookAndFeel.getControlHighlight());
            g2.drawLine(0, 0, w - 2, 0);
            g2.drawLine(0, 0, 0, h7 - 2);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return ((JInternalFrame)c2).isMaximum() ? MAXIMIZED_INSETS : NORMAL_INSETS;
        }
    }

    private static final class ComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(2, 2, 2, 0);

        private ComboBoxEditorBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            if (c2.isEnabled()) {
                PlasticUtils.drawFlush3DBorder(g2, x, y, w + 2, h7);
            } else {
                PlasticUtils.drawDisabledBorder(g2, x, y, w + 2, h7 - 1);
                g2.setColor(UIManager.getColor("control"));
                g2.drawLine(x, y + h7 - 1, x + w, y + h7 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static final class ComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ComboBoxArrowButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            AbstractButton button2 = (AbstractButton)c2;
            ButtonModel model = button2.getModel();
            if (model.isEnabled()) {
                boolean isPressed;
                boolean bl = isPressed = model.isPressed() && model.isArmed();
                if (isPressed) {
                    PlasticUtils.drawPressed3DBorder(g2, x, y, w, h7);
                } else {
                    PlasticUtils.drawButtonBorder(g2, x, y, w, h7, false);
                }
            } else {
                PlasticUtils.drawDisabledBorder(g2, x, y, w - 1, h7 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = LookUtils.IS_OS_WINDOWS_VISTA ? (!LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? new Insets(3, 3, 3, 3) : new Insets(2, 3, 3, 3)) : (LookUtils.IS_LOW_RESOLUTION ? new Insets(2, 3, 3, 3) : new Insets(1, 3, 1, 3));

        private ButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            AbstractButton button2 = (AbstractButton)c2;
            ButtonModel model = button2.getModel();
            if (model.isEnabled()) {
                boolean isDefault;
                boolean isPressed = model.isPressed() && model.isArmed();
                boolean bl = isDefault = button2 instanceof JButton && ((JButton)button2).isDefaultButton();
                if (isPressed && isDefault) {
                    PlasticUtils.drawDefaultButtonPressedBorder(g2, x, y, w, h7);
                } else if (isPressed) {
                    PlasticUtils.drawPressed3DBorder(g2, x, y, w, h7);
                } else if (isDefault) {
                    PlasticUtils.drawDefaultButtonBorder(g2, x, y, w, h7, false);
                } else {
                    PlasticUtils.drawButtonBorder(g2, x, y, w, h7, false);
                }
            } else {
                PlasticUtils.drawDisabledBorder(g2, x, y, w - 1, h7 - 1);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }

        public Insets getBorderInsets(Component c2, Insets newInsets) {
            newInsets.top = ButtonBorder.INSETS.top;
            newInsets.left = ButtonBorder.INSETS.left;
            newInsets.bottom = ButtonBorder.INSETS.bottom;
            newInsets.right = ButtonBorder.INSETS.right;
            return newInsets;
        }
    }

    private static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private Flush3DBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h7) {
            if (c2.isEnabled()) {
                PlasticUtils.drawFlush3DBorder(g2, x, y, w, h7);
            } else {
                PlasticUtils.drawDisabledBorder(g2, x, y, w, h7);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return INSETS;
        }

        public Insets getBorderInsets(Component c2, Insets newInsets) {
            newInsets.top = Flush3DBorder.INSETS.top;
            newInsets.left = Flush3DBorder.INSETS.left;
            newInsets.bottom = Flush3DBorder.INSETS.bottom;
            newInsets.right = Flush3DBorder.INSETS.right;
            return newInsets;
        }
    }
}

