/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_WF_Responsible;
import org.compiere.util.CCache;
import org.compiere.util.Msg;

public class MWFResponsible
extends X_AD_WF_Responsible {
    private static CCache<Integer, MWFResponsible> s_cache = new CCache("AD_WF_Responsible", 10);

    public static MWFResponsible get(Properties ctx, int AD_WF_Responsible_ID) {
        Integer key = new Integer(AD_WF_Responsible_ID);
        MWFResponsible retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWFResponsible(ctx, AD_WF_Responsible_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MWFResponsible(Properties ctx, int AD_WF_Responsible_ID, String trxName) {
        super(ctx, AD_WF_Responsible_ID, trxName);
    }

    public MWFResponsible(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isInvoker() {
        return this.getAD_User_ID() == 0 && this.getAD_Role_ID() == 0;
    }

    public boolean isRole() {
        return "R".equals(this.getResponsibleType()) && this.getAD_Role_ID() != 0;
    }

    public MRole getRole() {
        if (!this.isRole()) {
            return null;
        }
        return MRole.get(this.getCtx(), this.getAD_Role_ID());
    }

    public boolean isHuman() {
        return "H".equals(this.getResponsibleType()) && this.getAD_User_ID() != 0;
    }

    public boolean isOrganization() {
        return "O".equals(this.getResponsibleType()) && this.getAD_Org_ID() != 0;
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("R".equals(this.getResponsibleType()) && this.getAD_Role_ID() == 0 && this.getAD_Client_ID() > 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@RequiredEnter@ @AD_Role_ID@"));
            return false;
        }
        if (!"H".equals(this.getResponsibleType()) && this.getAD_User_ID() == 0) {
            this.setAD_User_ID(0);
        }
        if (!"R".equals(this.getResponsibleType()) && this.getAD_Role_ID() == 0) {
            this.setAD_Role_ID(0);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWFResponsible[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getResponsibleType());
        if (this.getAD_User_ID() != 0) {
            sb.append(",AD_User_ID=").append(this.getAD_User_ID());
        }
        if (this.getAD_Role_ID() != 0) {
            sb.append(",AD_Role_ID=").append(this.getAD_Role_ID());
        }
        sb.append("]");
        return sb.toString();
    }
}

