/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.small;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MMailMsg;
import org.compiere.model.MStore;
import org.compiere.model.MUserMail;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.HtmlCode;
import org.compiere.util.Language;
import org.compiere.util.MimeType;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUser;

public final class WebUtil {
    private static CLogger log = CLogger.getCLogger(WebUtil.class);

    public static void createTimeoutPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, String message) throws ServletException, IOException {
        log.info(message);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        String windowTitle = "Timeout";
        if (wsc != null) {
            windowTitle = Msg.getMsg(wsc.ctx, "Timeout");
        }
        WebDoc doc = WebDoc.create(windowTitle);
        body body2 = doc.getBody();
        if (message != null && message.length() > 0) {
            body2.addElement((Element)new p(message, "center"));
        }
        body2.addElement((Element)WebUtil.getLoginButton(wsc == null ? null : wsc.ctx));
        body2.addElement((Element)new hr());
        body2.addElement((Element)new small(servlet.getClass().getName()));
        WebUtil.createResponse(request, response, servlet, null, doc, false);
    }

    public static void createErrorPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, String message) throws ServletException, IOException {
        log.info(message);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        String windowTitle = "Error";
        if (wsc != null) {
            windowTitle = Msg.getMsg(wsc.ctx, "Error");
        }
        if (message != null) {
            windowTitle = windowTitle + ": " + message;
        }
        WebDoc doc = WebDoc.create(windowTitle);
        body b2 = doc.getBody();
        b2.addElement((Element)new p(servlet.getServletName(), "center"));
        b2.addElement((Element)new br());
        WebUtil.createResponse(request, response, servlet, null, doc, true);
    }

    public static void createLoginPage(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Properties ctx, String AD_Message) throws ServletException, IOException {
        request.getSession().invalidate();
        String url = WebEnv.getBaseDirectory("index.html");
        WebDoc doc = null;
        doc = ctx != null && AD_Message != null && !AD_Message.equals("") ? WebDoc.create(Msg.getMsg(ctx, AD_Message)) : (AD_Message != null ? WebDoc.create(AD_Message) : WebDoc.create(false));
        script script2 = new script("window.top.location.replace('" + url + "');");
        doc.getBody().addElement((Element)script2);
        WebUtil.createResponse(request, response, servlet, null, doc, false);
    }

    public static button getLoginButton(Properties ctx) {
        String text = "Login";
        if (ctx != null) {
            text = Msg.getMsg(ctx, "Login");
        }
        button button2 = new button();
        button2.setType("button").setName("Login").addElement(text);
        StringBuffer cmd = new StringBuffer("window.top.location.replace('");
        cmd.append(WebEnv.getBaseDirectory("index.html"));
        cmd.append("');");
        button2.setOnClick(cmd.toString());
        return button2;
    }

    public static Properties getCookieProprties(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i2 = 0; i2 < cookies.length; ++i2) {
                if (!cookies[i2].getName().equals("adempiereInfo")) continue;
                return WebUtil.propertiesDecode(cookies[i2].getValue());
            }
        }
        return new Properties();
    }

    public static String getParameter(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return null;
        }
        String enc = request.getCharacterEncoding();
        try {
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
                enc = request.getCharacterEncoding();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", e);
            enc = request.getCharacterEncoding();
        }
        String data = request.getParameter(parameter);
        if (data == null || data.length() == 0) {
            return data;
        }
        if (enc != null && !"UTF-8".equals(enc)) {
            try {
                String dataEnc = new String(data.getBytes(enc), "UTF-8");
                log.log(Level.FINER, "Convert " + data + " (" + enc + ")-> " + dataEnc + " (" + "UTF-8" + ")");
                data = dataEnc;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Convert " + data + " (" + enc + ")->" + "UTF-8");
            }
        }
        String inStr = data;
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf("&#");
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 2, inStr.length());
            int j = inStr.indexOf(";");
            if (j < 0) {
                inStr = "&#" + inStr;
                break;
            }
            String token = inStr.substring(0, j);
            try {
                int intToken = Integer.parseInt(token);
                outStr.append((char)intToken);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Token=" + token, e);
                outStr.append("&#").append(token).append(";");
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf("&#");
        }
        outStr.append(inStr);
        String retValue = outStr.toString();
        log.finest(parameter + "=" + data + " -> " + retValue);
        return retValue;
    }

    public static int getParameterAsInt(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return 0;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(data);
        }
        catch (Exception e) {
            log.warning(parameter + "=" + data + " - " + e);
            return 0;
        }
    }

    public static BigDecimal getParameterAsBD(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return Env.ZERO;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return Env.ZERO;
        }
        try {
            return new BigDecimal(data);
        }
        catch (Exception e) {
            try {
                DecimalFormat format = DisplayType.getNumberFormat(22);
                Object oo = format.parseObject(data);
                if (oo instanceof BigDecimal) {
                    return (BigDecimal)oo;
                }
                if (oo instanceof Number) {
                    return new BigDecimal(((Number)oo).doubleValue());
                }
                return new BigDecimal(oo.toString());
            }
            catch (Exception e2) {
                log.fine(parameter + "=" + data + " - " + e2);
                return Env.ZERO;
            }
        }
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter) {
        return WebUtil.getParameterAsDate(request, parameter, null);
    }

    public static Timestamp getParameterAsDate(HttpServletRequest request, String parameter, Language language) {
        Date date;
        SimpleDateFormat format;
        if (request == null || parameter == null) {
            return null;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return null;
        }
        if (language != null) {
            try {
                format = DisplayType.getDateFormat(15, language);
                date = format.parse(data);
                if (date != null) {
                    return new Timestamp(date.getTime());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            format = DisplayType.getDateFormat(15);
            date = format.parse(data);
            if (date != null) {
                return new Timestamp(date.getTime());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return Timestamp.valueOf(data);
        }
        catch (Exception e) {
            log.warning(parameter + " - cannot parse: " + data);
            return null;
        }
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter) {
        return WebUtil.getParameterAsBoolean(request, parameter, null);
    }

    public static boolean getParameterAsBoolean(HttpServletRequest request, String parameter, String expected) {
        if (request == null || parameter == null) {
            return false;
        }
        String data = WebUtil.getParameter(request, parameter);
        if (data == null || data.length() == 0) {
            return false;
        }
        if (expected == null) {
            return true;
        }
        return expected.equalsIgnoreCase(data);
    }

    public static String getParamOrNull(HttpServletRequest request, String parameter) {
        String value = WebUtil.getParameter(request, parameter);
        if (value == null) {
            return value;
        }
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    public static void reload(String logMessage, String jsp, HttpSession session, HttpServletRequest request, HttpServletResponse response, ServletContext thisContext) throws ServletException, IOException {
        session.setAttribute("hdrMessage", (Object)logMessage);
        log.warning(" - " + logMessage + " - update not confirmed");
        thisContext.getRequestDispatcher(jsp).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void createResponse(HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, Properties cookieProperties, WebDoc doc, boolean debug) throws IOException {
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        if (cookieProperties != null) {
            Cookie cookie = new Cookie("adempiereInfo", WebUtil.propertiesEncode(cookieProperties));
            cookie.setComment("(c) adempiere, Inc - Jorg Janke");
            cookie.setSecure(false);
            cookie.setPath("/");
            if (cookieProperties.size() == 0) {
                cookie.setMaxAge(0);
            } else {
                cookie.setMaxAge(2592000);
            }
            response.addCookie(cookie);
        }
        if (debug && WebEnv.DEBUG) {
            WebEnv.addFooter(request, response, servlet, doc.getBody());
        }
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "error writing");
        }
        out.close();
    }

    public static script getClearFrame(String targetFrame) {
        StringBuffer cmd = new StringBuffer();
        cmd.append("<!-- clear frame\n").append("var d = parent.").append(targetFrame).append(".document;\n").append("d.open();\n").append("d.write('<link href=\"").append(WebEnv.getStylesheetURL()).append("\" rel=\"stylesheet\">');\n").append("d.close();\n").append("// -- clear frame -->");
        return new script(cmd.toString());
    }

    public static HtmlCode getForward(String url, int delaySec) {
        if (delaySec <= 0) {
            delaySec = 3;
        }
        HtmlCode retValue = new HtmlCode();
        a a2 = new a(url);
        a2.addElement(url);
        retValue.addElement((Element)a2);
        script script2 = new script("setTimeout(\"window.top.location.replace('" + url + "')\"," + (delaySec + 1000) + ");");
        retValue.addElement((Element)script2);
        return retValue;
    }

    public static void createForwardPage(HttpServletResponse response, String title2, String forwardURL, int delaySec) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        WebDoc doc = WebDoc.create(title2);
        body b2 = doc.getBody();
        b2.addElement((Element)WebUtil.getForward(forwardURL, delaySec));
        PrintWriter out = response.getWriter();
        doc.output(out);
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "Error writing");
        }
        out.close();
        log.fine(forwardURL + " - " + title2);
    }

    public static boolean exists(String test) {
        if (test == null) {
            return false;
        }
        return test.length() > 0;
    }

    public static boolean exists(HttpServletRequest request, String parameter) {
        if (request == null || parameter == null) {
            return false;
        }
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEncoding=UTF-8", e);
        }
        return WebUtil.exists(request.getParameter(parameter));
    }

    public static boolean isEmailValid(String email) {
        if (email == null || email.length() == 0) {
            return false;
        }
        try {
            InternetAddress ia = new InternetAddress(email, true);
            if (ia != null) {
                return true;
            }
        }
        catch (AddressException ex) {
            log.warning(email + " - " + ex.getLocalizedMessage());
        }
        return false;
    }

    public static String propertiesEncode(Properties pp) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            pp.store(bos, "adempiere");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "store", e);
        }
        String result = new String(bos.toByteArray());
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "encodeUTF-8", e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(result, enc);
                log.info("encode: " + enc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "encode", ex);
            }
        }
        return result;
    }

    public static Properties propertiesDecode(String data) {
        String result = null;
        try {
            result = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "decodeUTF-8", e);
            String enc = System.getProperty("file.encoding");
            try {
                result = URLEncoder.encode(data, enc);
                log.log(Level.SEVERE, "decode: " + enc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "decode", ex);
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(result.getBytes());
        Properties pp = new Properties();
        try {
            pp.load(bis);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "load", e);
        }
        return pp;
    }

    public static option[] convertToOption(NamePair[] list, String default_ID) {
        int size = list.length;
        option[] retValue = new option[size];
        for (int i2 = 0; i2 < size; ++i2) {
            boolean selected = false;
            if (i2 == 0 && (default_ID == null || default_ID.length() == 0)) {
                selected = true;
            }
            String name = Util.maskHTML(list[i2].getName());
            retValue[i2] = new option(list[i2].getID()).addElement(name);
            if (default_ID != null && default_ID.equals(list[i2].getID())) {
                selected = true;
            }
            retValue[i2].setSelected(selected);
        }
        return retValue;
    }

    public static tr createField(tr line, String FORMNAME, String PARAMETER, String labelText, String inputType, Object value, int sizeDisplay, int size, boolean longField, boolean mandatory, String onChange, StringBuffer script2) {
        if (line == null) {
            line = new tr();
        }
        String labelInfo = labelText;
        if (mandatory) {
            labelInfo = labelInfo + "&nbsp;<font color=\"red\">*</font>";
            String fName = "document." + FORMNAME + "." + PARAMETER;
            script2.append(fName).append(".required=true; ");
        }
        label llabel = new label().setFor(PARAMETER).addElement(labelInfo);
        llabel.setID("ID_" + PARAMETER + "_Label");
        line.addElement((Element)new td().addElement((Element)llabel).setAlign("right"));
        input iinput = new input(inputType, PARAMETER, value == null ? "" : value.toString());
        iinput.setSize(sizeDisplay).setMaxlength(size);
        iinput.setID("ID_" + PARAMETER);
        if (onChange != null && onChange.length() > 0) {
            iinput.setOnChange(onChange);
        }
        iinput.setTitle(labelText);
        td field = new td().addElement((Element)iinput).setAlign("left");
        if (longField) {
            field.setColSpan(3);
        }
        line.addElement((Element)field);
        return line;
    }

    public static input createClosePopupButton() {
        input close = new input("button", "closePopup", "Close");
        close.setTitle("Close PopUp");
        close.setOnClick("closePopup();return false;");
        return close;
    }

    public static String streamAttachment(HttpServletResponse response, MAttachment attachment, int attachmentIndex) {
        if (attachment == null) {
            return "No Attachment";
        }
        int realIndex = -1;
        MAttachmentEntry[] entries = attachment.getEntries();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            MAttachmentEntry entry = entries[i2];
            if (entry.getIndex() != attachmentIndex) continue;
            realIndex = i2;
            break;
        }
        if (realIndex < 0) {
            log.fine("No Attachment Entry for Index=" + attachmentIndex + " - " + attachment);
            return "Attachment Entry not found";
        }
        MAttachmentEntry entry = entries[realIndex];
        if (entry.getData() == null) {
            log.fine("Empty Attachment Entry for Index=" + attachmentIndex + " - " + attachment);
            return "Attachment Entry empty";
        }
        try {
            int bufferSize = 2048;
            int fileLength = entry.getData().length;
            response.setContentType(entry.getContentType());
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            log.fine(entry.toString());
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            out.write(entry.getData());
            out.flush();
            out.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + entry.getContentType());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + ex;
        }
        return null;
    }

    public static String streamFile(HttpServletResponse response, File file) {
        if (file == null) {
            return "No File";
        }
        if (!file.exists()) {
            return "File not found: " + file.getAbsolutePath();
        }
        MimeType mimeType = MimeType.get(file.getAbsolutePath());
        try {
            int bufferSize = 2048;
            int fileLength = (int)file.length();
            response.setContentType(mimeType.getMimeType());
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            log.fine(file.toString());
            long time = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            int c = 0;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            out.flush();
            out.close();
            in.close();
            time = System.currentTimeMillis() - time;
            double speed = (double)(fileLength / 1024) / ((double)time / 1000.0);
            log.info("Length=" + fileLength + " - " + time + " ms - " + speed + " kB/sec - " + mimeType);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error - " + ex;
        }
        return null;
    }

    public static void deleteCookieWebUser(HttpServletRequest request, HttpServletResponse response, String COOKIE_NAME) {
        Cookie cookie = new Cookie(COOKIE_NAME, " ");
        cookie.setComment("adempiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(1);
        response.addCookie(cookie);
    }

    public static String sendEMail(HttpServletRequest request, WebUser to, String msgType, Object[] parameter) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MStore wStore = wsc.wstore;
        MMailMsg mailMsg = wStore.getMailMsg(msgType);
        StringBuffer subject = new StringBuffer(mailMsg.getSubject());
        if (parameter.length > 0 && parameter[0] != null) {
            subject.append(parameter[0]);
        }
        StringBuffer message = new StringBuffer();
        String hdr = wStore.getEMailFooter();
        if (hdr != null && hdr.length() > 0) {
            message.append(hdr).append("\n");
        }
        message.append(mailMsg.getMessage());
        if (parameter.length > 1 && parameter[1] != null) {
            message.append(parameter[1]);
        }
        if (mailMsg.getMessage2() != null) {
            message.append("\n").append(mailMsg.getMessage2());
            if (parameter.length > 2 && parameter[2] != null) {
                message.append(parameter[2]);
            }
        }
        if (mailMsg.getMessage3() != null) {
            message.append("\n").append(mailMsg.getMessage3());
            if (parameter.length > 3 && parameter[3] != null) {
                message.append(parameter[3]);
            }
        }
        message.append("\n---------.----------.----------.----------.----------.----------\n").append("http://").append(request.getServerName()).append(request.getContextPath()).append("/ - ").append(wStore.getName()).append("\n").append("Request from: ").append(WebUtil.getFrom(request)).append("\n");
        String ftr = wStore.getEMailFooter();
        if (ftr != null && ftr.length() > 0) {
            message.append(ftr);
        }
        EMail email = wStore.createEMail(to.getEmail(), subject.toString(), message.toString());
        if (msgType == "OA") {
            String orderEMail = wStore.getWebOrderEMail();
            String storeEMail = wStore.getWStoreEMail();
            if (orderEMail != null && orderEMail.length() > 0 && !orderEMail.equals(storeEMail)) {
                email.addBcc(orderEMail);
            }
        }
        String retValue = email.send();
        MUserMail um = new MUserMail(mailMsg, to.getAD_User_ID(), email);
        um.save();
        return retValue;
    }

    public static String getFrom(HttpServletRequest request) {
        String host = request.getRemoteHost();
        if (!host.equals(request.getRemoteAddr())) {
            host = host + " (" + request.getRemoteAddr() + ")";
        }
        return host;
    }

    public static void addCookieWebUser(HttpServletRequest request, HttpServletResponse response, String webUser, String COOKIE_NAME) {
        Cookie cookie = new Cookie(COOKIE_NAME, webUser);
        cookie.setComment("adempiere Web User");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(2592000);
        response.addCookie(cookie);
    }

    public static void resendCode(HttpServletRequest request, WebUser wu) {
        String msg = WebUtil.sendEMail(request, wu, "UV", new Object[]{request.getServerName(), wu.getName(), wu.getEMailVerifyCode()});
        if ("OK".equals(msg)) {
            wu.setPasswordMessage("EMail sent");
        } else {
            wu.setPasswordMessage("Problem sending EMail: " + msg);
        }
    }

    public static boolean updateFields(HttpServletRequest request, WebUser wu, boolean updateEMailPwd) {
        if (updateEMailPwd) {
            String s = WebUtil.getParameter(request, "PasswordNew");
            wu.setPasswordMessage(null);
            wu.setPassword(s);
            if (wu.getPasswordMessage() != null) {
                return false;
            }
            s = WebUtil.getParameter(request, "EMail");
            if (!WebUtil.isEmailValid(s)) {
                wu.setPasswordMessage("EMail Invalid");
                return false;
            }
            wu.setEmail(s.trim());
        }
        StringBuffer mandatory = new StringBuffer();
        String s = WebUtil.getParameter(request, "Name");
        if (s != null && s.length() != 0) {
            wu.setName(s.trim());
        } else {
            mandatory.append(" - Name");
        }
        s = WebUtil.getParameter(request, "Company");
        if (s != null && s.length() != 0) {
            wu.setCompany(s);
        }
        if ((s = WebUtil.getParameter(request, "Title")) != null && s.length() != 0) {
            wu.setTitle(s);
        }
        if ((s = WebUtil.getParameter(request, "Address")) != null && s.length() != 0) {
            wu.setAddress(s);
        } else {
            mandatory.append(" - Address");
        }
        s = WebUtil.getParameter(request, "Address2");
        if (s != null && s.length() != 0) {
            wu.setAddress2(s);
        }
        if ((s = WebUtil.getParameter(request, "City")) != null && s.length() != 0) {
            wu.setCity(s);
        } else {
            mandatory.append(" - City");
        }
        s = WebUtil.getParameter(request, "Postal");
        if (s != null && s.length() != 0) {
            wu.setPostal(s);
        } else {
            mandatory.append(" - Postal");
        }
        s = WebUtil.getParameter(request, "C_Country_ID");
        if (s != null && s.length() != 0) {
            wu.setC_Country_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "C_Region_ID")) != null && s.length() != 0) {
            wu.setC_Region_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "RegionName")) != null && s.length() != 0) {
            wu.setRegionName(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone")) != null && s.length() != 0) {
            wu.setPhone(s);
        }
        if ((s = WebUtil.getParameter(request, "Phone2")) != null && s.length() != 0) {
            wu.setPhone2(s);
        }
        if ((s = WebUtil.getParameter(request, "C_BP_Group_ID")) != null && s.length() != 0) {
            wu.setC_BP_Group_ID(s);
        }
        if ((s = WebUtil.getParameter(request, "Fax")) != null && s.length() != 0) {
            wu.setFax(s);
        }
        if (mandatory.length() > 0) {
            mandatory.insert(0, "Enter Mandatory");
            wu.setSaveErrorMessage(mandatory.toString());
            return false;
        }
        return wu.save();
    }
}

