/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebUtil;

public class WebSessionCtx
implements Serializable {
    private static final long serialVersionUID = -5069858671373130221L;
    public static final String CTX_SERVER_CONTEXT = "context";
    public static final String CTX_DOCUMENT_DIR = "documentDir";
    public static final String HDR_MESSAGE = "hdrMessage";
    public static final String HDR_INFO = "hdrInfo";
    private static CLogger log = CLogger.getCLogger(WebSessionCtx.class);
    private static CCache<Integer, Properties> s_cacheCtx = new CCache("WebSessionCtx", 30, 60);
    public static final String NAME = "WebSessionCtx";
    public static int s_counter = 0;
    public int counter = ++s_counter;
    public Properties ctx = null;
    public Language language = null;
    public SimpleDateFormat dateFormat = null;
    public SimpleDateFormat dateTimeFormat = null;
    public DecimalFormat amountFormat = null;
    public DecimalFormat integerFormat = null;
    public DecimalFormat numberFormat = null;
    public DecimalFormat quantityFormat = null;
    public String loginInfo = "";
    public MStore wstore = null;

    public static WebSessionCtx get(HttpServletRequest request, int W_Store_ID) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession(true);
        }
        if (session == null) {
            return null;
        }
        WebSessionCtx wsc = (WebSessionCtx)session.getAttribute(NAME);
        if (wsc == null) {
            wsc = new WebSessionCtx(request, W_Store_ID);
            session.setAttribute(NAME, (Object)wsc);
        }
        return wsc;
    }

    public static WebSessionCtx get(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession(true);
        }
        if (session == null) {
            return null;
        }
        WebSessionCtx wsc = (WebSessionCtx)session.getAttribute(NAME);
        if (wsc == null) {
            wsc = new WebSessionCtx(request);
            session.setAttribute(NAME, (Object)wsc);
        }
        return wsc;
    }

    private WebSessionCtx(HttpServletRequest request) {
        log.info(request.getContextPath() + " (" + request.getRemoteAddr() + " - " + request.getLocale() + ") #" + this.counter);
        this.ctx = new Properties();
        this.setLanguage(request);
        HttpSession session = request.getSession(false);
        ServletContext sc = session.getServletContext();
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = sc.getInitParameter(key);
            this.ctx.setProperty(key, value);
            log.config(key + "=" + value);
        }
        this.setWStore(request.getContextPath());
        this.ctx = this.getDefaults();
        this.ctx.put(CTX_SERVER_CONTEXT, request.getServerName() + request.getContextPath());
        session.setAttribute("ctx", (Object)this.ctx);
        log.fine("#" + this.ctx.size());
    }

    private WebSessionCtx(HttpServletRequest request, int W_Store_ID) {
        log.info(request.getContextPath() + " (" + request.getRemoteAddr() + " - " + request.getLocale() + ") #" + this.counter);
        this.ctx = new Properties();
        this.setLanguage(request);
        HttpSession session = request.getSession(false);
        ServletContext sc = session.getServletContext();
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = sc.getInitParameter(key);
            this.ctx.setProperty(key, value);
            log.config(key + "=" + value);
        }
        this.setWStore(W_Store_ID);
        this.ctx = this.getDefaults();
        this.ctx.put(CTX_SERVER_CONTEXT, request.getServerName() + request.getContextPath());
        session.setAttribute("ctx", (Object)this.ctx);
        log.fine("#" + this.ctx.size());
    }

    private void setWStore(String contextPath) {
        int W_Store_ID = Env.getContextAsInt(this.ctx, "W_Store_ID");
        if (W_Store_ID != 0) {
            this.wstore = MStore.get(this.ctx, W_Store_ID);
            if (this.wstore.getW_Store_ID() != 0) {
                log.info("From web.xml - " + this.wstore);
                return;
            }
        }
        if ("/adempiere".equals(contextPath)) {
            return;
        }
        this.wstore = MStore.get(this.ctx, contextPath);
        if (this.wstore == null) {
            throw new IllegalStateException("No Web Store found - " + contextPath);
        }
    }

    public void setWStore(int W_Store_ID) {
        if (W_Store_ID != 0) {
            this.wstore = MStore.get(this.ctx, W_Store_ID);
            if (this.wstore.getW_Store_ID() != 0) {
                log.info("From web.xml - " + this.wstore);
                return;
            }
        }
        if (this.wstore == null) {
            throw new IllegalStateException("No Web Store found - ID: " + W_Store_ID);
        }
    }

    private Properties getDefaults() {
        String pKey;
        Enumeration<Object> e;
        if (this.wstore == null) {
            return new Properties();
        }
        Integer key = new Integer(this.wstore.getW_Store_ID());
        Properties newCtx = s_cacheCtx.get(key);
        if (newCtx == null) {
            String docDir;
            log.info(this.wstore.getWebContext());
            newCtx = new Properties();
            e = this.ctx.keys();
            while (e.hasMoreElements()) {
                pKey = (String)e.nextElement();
                newCtx.setProperty(pKey, this.ctx.getProperty(pKey));
            }
            Env.setContext(newCtx, "#AD_Client_ID", this.wstore.getAD_Client_ID());
            Env.setContext(newCtx, "#AD_Org_ID", this.wstore.getAD_Org_ID());
            Env.setContext(newCtx, "#SalesRep_ID", this.wstore.getSalesRep_ID());
            Env.setContext(newCtx, "#M_PriceList_ID", this.wstore.getM_PriceList_ID());
            Env.setContext(newCtx, "#M_Warehouse_ID", this.wstore.getM_Warehouse_ID());
            String s = this.wstore.getWebParam1();
            Env.setContext(newCtx, "webParam1", s == null ? "" : s);
            s = this.wstore.getWebParam2();
            Env.setContext(newCtx, "webParam2", s == null ? "" : s);
            s = this.wstore.getWebParam3();
            Env.setContext(newCtx, "webParam3", s == null ? "" : s);
            s = this.wstore.getWebParam4();
            Env.setContext(newCtx, "webParam4", s == null ? "" : s);
            s = this.wstore.getWebParam5();
            Env.setContext(newCtx, "webParam5", s == null ? "" : s);
            s = this.wstore.getWebParam6();
            Env.setContext(newCtx, "webParam6", s == null ? "" : s);
            s = this.wstore.getStylesheet();
            if (s == null) {
                s = "standard";
            } else {
                int index = s.lastIndexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
            }
            Env.setContext(newCtx, "Stylesheet", s);
            s = this.wstore.getWebInfo();
            if (s != null && s.length() > 0) {
                Env.setContext(newCtx, HDR_INFO, s);
            }
            Env.setContext(newCtx, "#M_PriceList_ID", this.wstore.getM_PriceList_ID());
            if (Env.getContextAsInt(newCtx, "#AD_User_ID") == 0) {
                Env.setContext(newCtx, "#AD_User_ID", this.wstore.getSalesRep_ID());
            }
            if (Env.getContextAsInt(newCtx, "#AD_Role_ID") == 0) {
                int AD_Role_ID = 0;
                Env.setContext(newCtx, "#AD_Role_ID", AD_Role_ID);
            }
            MClient client = MClient.get(newCtx, this.wstore.getAD_Client_ID());
            Env.setContext(newCtx, "name", client.getName());
            Env.setContext(newCtx, "description", client.getDescription());
            if (newCtx.getProperty("#AD_Language") == null && client.getAD_Language() != null) {
                Env.setContext(newCtx, "#AD_Language", client.getAD_Language());
            }
            Env.setContext(newCtx, CTX_DOCUMENT_DIR, (docDir = client.getDocumentDir()) == null ? "" : docDir);
            if (newCtx.getProperty("#AD_Language") == null) {
                Env.setContext(newCtx, "#AD_Language", "en_US");
            }
            s_cacheCtx.put(key, newCtx);
        }
        e = newCtx.keys();
        while (e.hasMoreElements()) {
            pKey = (String)e.nextElement();
            this.ctx.setProperty(pKey, newCtx.getProperty(pKey));
        }
        return this.ctx;
    }

    private void setLanguage(HttpServletRequest request) {
        Properties cProp = WebUtil.getCookieProprties(request);
        String AD_Language = WebUtil.getParameter(request, "#AD_Language");
        if (AD_Language == null && (AD_Language = cProp.getProperty("#AD_Language")) == null) {
            Locale locale = request.getLocale();
            AD_Language = Language.getAD_Language(locale);
        }
        if (AD_Language != null) {
            Language lang = Language.getLanguage(AD_Language);
            Env.verifyLanguage(this.ctx, lang);
            Env.setContext(this.ctx, "#AD_Language", lang.getAD_Language());
            Msg.getMsg(this.ctx, "0");
            cProp.setProperty("#AD_Language", lang.getAD_Language());
            this.setLanguage(lang);
        } else if (this.language == null) {
            this.setLanguage(Language.getBaseLanguage());
        }
    }

    private void setLanguage(Language lang) {
        this.language = lang;
        this.dateFormat = DisplayType.getDateFormat(15, this.language);
        this.dateTimeFormat = DisplayType.getDateFormat(16, this.language);
        this.amountFormat = DisplayType.getNumberFormat(12, this.language);
        this.integerFormat = DisplayType.getNumberFormat(11, this.language);
        this.numberFormat = DisplayType.getNumberFormat(22, this.language);
        this.quantityFormat = DisplayType.getNumberFormat(29, this.language);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String toString() {
        return "WSessionCtx#" + this.counter;
    }
}

